/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.core.InternalApi;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

@InternalApi
public final class StorageException
extends BaseHttpServiceException {
    private static final String INTERNAL_ERROR = "internalError";
    private static final String CONNECTION_CLOSED_PREMATURELY = "connectionClosedPrematurely";
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(504), null), (Object)new BaseServiceException.Error(Integer.valueOf(503), null), (Object)new BaseServiceException.Error(Integer.valueOf(502), null), (Object)new BaseServiceException.Error(Integer.valueOf(500), null), (Object)new BaseServiceException.Error(Integer.valueOf(429), null), (Object)new BaseServiceException.Error(Integer.valueOf(408), null), (Object[])new BaseServiceException.Error[]{new BaseServiceException.Error(null, "internalError"), new BaseServiceException.Error(null, "connectionClosedPrematurely")});
    private static final long serialVersionUID = -4168430271327813063L;

    public StorageException(int code, String message) {
        this(code, message, null);
    }

    public StorageException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
    }

    public StorageException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, RETRYABLE_ERRORS, cause);
    }

    public StorageException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
    }

    public StorageException(GoogleJsonError error) {
        super(error, true, RETRYABLE_ERRORS);
    }

    public static StorageException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate((RetryHelper.RetryHelperException)ex);
        throw new StorageException(0, ex.getMessage(), ex.getCause());
    }

    public static StorageException translate(IOException exception) {
        if (exception.getMessage().contains("Connection closed prematurely")) {
            return new StorageException(0, exception.getMessage(), CONNECTION_CLOSED_PREMATURELY, exception);
        }
        return new StorageException(exception);
    }
}

