<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2024 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'حول هذا المقرر الدراسي';
$string['activity'] = 'النشاط';
$string['action:changeassetvisibility'] = 'تغيير مرئية الأصل';
$string['action:duplicateasset'] = 'تكرار الأصل';
$string['action:changesectionvisibility'] = 'تغيير مرئية القسم';
$string['action:highlightsectionvisibility'] = 'تمييز مرئية القسم';
$string['action:sectiontoc'] = 'الحصول على جدول محتويات القسم';
$string['addanewsection'] = 'إنشاء قسم جديد';
$string['addresourceoractivity'] = 'إنشاء نشاط التعليم';
$string['admin'] = 'المسؤول';
$string['advancedbrandingheading'] = 'إدراج علامة تجارية متقدّم';
$string['ago'] = 'مضت';
$string['answered'] = 'تمت الإجابة';
$string['appendices'] = 'الأدوات';
$string['arialabelnewsarticle'] = 'مقال إخباري';
$string['assigndraft'] = 'مسودة تتطلب تأكيدك';
$string['assignreopened'] = 'تم إعادة الفتح';
$string['at'] = 'عند';
$string['attempted'] = 'تمت المحاولة';
$string['basics'] = 'الأساسيات';
$string['brandingheading'] = 'إدراج علامات تجارية';
$string['browse'] = 'استعراض';
$string['browseallcourses'] = 'استعراض كل المقررات الدراسية';
$string['cachedef_activity_deadlines'] = 'التخزين المؤقت للمواعيد النهائية لنشاط المستخدمين.';
$string['cachedef_generalstaticappcache'] = 'محاذاة ذاكرة التخزين المؤقت على مستوى التطبيق الثابت العام';
$string['cachedef_course_completion_progress'] = 'يستخدم ذلك لتخزين بيانات الإكمال مؤقتًا لكل مقرر دراسي / مستخدم.';
$string['cachedef_course_completion_progress_ts'] = 'يستخدم ذلك بحيث نستطيع إبطال ذاكرات التخزين المؤقت على مستوى الجلسات إذا تم تغيير إعدادات إكمال المقرر الدراسي لأحد المقررات الدراسية أو الوحدات النمطية.';
$string['cachedef_webservicedefinitions'] = 'التخزين المؤقت لتعريفات خدمة الويب المنشأة تلقائيًا.';
$string['card'] = 'بطاقة';
$string['categoryedit'] = 'تحرير فئة';
$string['category_color'] = 'لون الفئة';
$string['category_color_description'] = 'لون فئة المقرر الدراسي. تتخذ المقررات الدراسية الفرعية أقرب تكوين للفئة الأساسية';
$string['category_color_palette'] = 'لوح الألوان';
$string['category_color_palette_description'] = 'انظر القيمة الست عشرية المقابلة للون المحدد. لن يؤثر هذا في أي تكوين، فهو هو مجرد نموذج لمساعدة المستخدمين على إنشاء قيمة التكوين.';
$string['changecoverimage'] = 'تغيير صورة الغلاف';
$string['changefullname'] = 'تغيير اسم الموقع';
$string['chapters'] = 'الفصول';
$string['choosereadme'] = '<div class="clearfix" dir="rtl"><div class="theme_screenshot"><h2>محاذاة</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'إغلاق';
$string['conditional'] = 'شرطي';
$string['contents'] = 'المحتويات';
$string['contributed'] = 'ممنوح';
$string['courses'] = 'المقررات الدراسية';
$string['coursecontacts'] = 'جهات اتصال المقرر الدراسي';
$string['coursedisplay'] = 'عرض المقرر الدراسي';
$string['coursefootertoggle'] = 'تذييل المقرر الدراسي';
$string['coursefootertoggledesc'] = 'يعرض تذييل المقرر الدراسي معلومات مفيدة للمستخدمين حول صفحة المقرر الدراسي بما في ذلك جهات اتصال المقرر الدراسي ووصف المقرر الدراسي والنشاط الحديث في المقرر الدراسي.';
$string['courseformatnotification'] = 'تنسيق المقرر الدراسي الحالي الذي تستخدمه غير مدعوم بشكل كامل من قبل شكل Snap. وللحصول على أفضل تجربة، يوصي Open LMS باستخدام الموضوعات أو تنسيقات المقرر الدراسي الأسبوعية مع شكل Snap. يمكن تغيير تنسيق المقرر الدراسي في <a href="{$a}">إعدادات المقرر الدراسي</a>.';
$string['coursefixydefaulttext'] = 'أنت غير مسجل حاليًا في أي مقررات دراسية.<br>ستظهر المقررات الدراسية التي أنت مسجل فيها هنا.';
$string['coursegrade'] = 'تقدير المقرر الدراسي:';
$string['coursepartialrender'] = 'تمكين التحميل البطيء لأقسام المقرر الدراسي';
$string['coursepartialrenderdesc'] = 'في حالة التمكين، يتم تحميل أقسام المقرر الدراسي عند الطلب من قبل المستخدم. ويساعد هذا الإجراء المقررات الدراسية التي تحتوي على كميات كبيرة من المحتوى على التحميل بشكل أسرع.';
$string['coursenavigation'] = 'تنقل إلى المقرر الدراسي';
$string['coursesummaryfilesunsuitable'] = 'يرجى تفريغ ملفات تلخيص المقررات الدراسية الخاصة بك قبل محاولة تغيير صورة الغلاف';
$string['courseactionslabel'] = 'الإجراءات';
$string['courseactivitieslabel'] = 'أنشطة القسم';
$string['coursetools'] = 'لوحة المقرر الدراسي';
$string['coverdisplay'] = 'عرض الغلاف';
$string['covercarousel'] = 'مكتبة الأغلفة';
$string['covercarousellabel'] = 'المكتبة';
$string['covercarouselon'] = 'استخدام مكتبة الأغلفة';
$string['covercarouseldescription'] = '<p dir="rtl">تُعَد المكتبة مجموعة من الشعارات الدوارة، أو عرض الشرائح الذي يتم عرضه على الصفحة الرئيسية لموقعك بدلاً من صورة الغلاف.</p>
<p dir="rtl">أضِف ما يصل إلى 3 صور، وعنوانًا لكل شريحة، وعنوانًا فرعيًا اختياريًا. وتعمل الصور بحجم 1200 × 600 بكسل بشكل أفضل.</p>';
$string['covercarouselsronly'] = 'هذه مكتبة بشرائح ذاتية الدوران. قم بتنشيط أي من الأزرار لتعطيل الدوران. واستخدم الأزرار "التالي" و"السابق" للتنقل أو انتقل إلى شريحة ما سريعًا باستخدام نقاط الشرائح.';
$string['covercarouselplaybutton'] = 'استئناف الشرائح ذاتية الدوران للمكتبة.';
$string['covercarouselpausebutton'] = 'إيقاف الشرائح ذاتية الدوران مؤقتًا للمكتبة.';
$string['coverimage'] = 'صورة الغلاف';
$string['covervideo'] = 'فيديو الغلاف';
$string['comingsoon'] = 'يتوفر قريبًا!';
$string['createsection'] = 'إنشاء قسم';
$string['current'] = 'حالي';
$string['customcss'] = 'CSS مخصص';
$string['customcssdesc'] = 'يُرجى الانتباه إلى أن القوة الكبيرة تصاحبها مسؤولية كبيرة. ومن ثَم، تقع على عاتقك مسؤولية حل أي مشكلة تسببها CSS المضافة هنا. ولا يقوم دعم Open LMS باستكشاف الأخطاء وإصلاحها ولا يوفر أي مساعدة بشأن المحتوى المتعلق بـ CSS.';
$string['customtopbar'] = 'شريط التنقل';
$string['customisenavbar'] = 'تغيير ألوان شريط التنقل';
$string['customisenavbutton'] = 'تغيير ألوان زر "المقررات الدراسية الخاصة بي"';
$string['customisecustommenu'] = 'تغيير لون نص القائمة المخصص';
$string['custommenutext'] = 'لون نص القائمة المخصص';
$string['deadlines'] = 'المواعيد النهائية';
$string['deadlinestoggle'] = 'المواعيد النهائية';
$string['deadlinestoggledesc'] = 'تعرض للمستخدمين أي مواعيد نهائية للأنشطة القادمة الموجودة في المقررات الدراسية المسجلة.';
$string['defaultsummary'] = 'تُستخدم تلك المساحة لوصف ما يدور حوله هذا الموضوع - بالنص والصورة والصوت والفيديو.';
$string['defaultintrosummary'] = 'مرحبًا بك في مقررك الدراسي الجديد {‎$a}.<br>ابدأ بوصف ما يدور حوله مقررك الدراسي باستخدام النص والصورة والصوت والفيديو.';
$string['defaultsectiontitle'] = 'قسم بدون عنوان';
$string['debugerrors'] = 'تصحيح الأخطاء';
$string['deleteassetconfirm'] = 'حذف {$a}';
$string['deletingasset'] = 'حذف {$a}';
$string['deletingassetname'] = 'حذف {$a->type} "{$a->name}"';
$string['deletesectionconfirm'] = 'حذف القسم';
$string['deletingsection'] = 'حذف القسم "{$a}"';
$string['draft'] = 'لم يتم نشره للطلاب';
$string['dropzonelabel'] = 'أفلِت الملفات لإرفاقها أو <span class="fake-link">استعرض</span>';
$string['due'] = '{$a} مستحق';
$string['edit'] = 'تحرير "{$a}"';
$string['editcoursecontent'] = 'تحرير الكتل';
$string['editcoursesettings'] = 'إعدادات المقرر الدراسي';
$string['editcoursetopic'] = 'تحرير قسم';
$string['editcustomfooter'] = 'تحرير التذييل';
$string['editcustommenu'] = 'تحرير القائمة المخصصة';
$string['error'] = 'خطأ';
$string['errorgettingfeed'] = 'حدث خطأ أثناء جلب عناصر الموجز.';
$string['error:categorycolorinvalidjson'] = 'تنسيق JSON لفئات المقرر الدراسي غير صحيح';
$string['error:categorycolorinvalidvalue'] = 'معرف السجل أو قيمة اللون للفئة "{$a}" غير صالحة';
$string['error:categorynotfound'] = 'لم يتم العثور على سجل الفئة بمعرف "{$a}"';
$string['error:coverimageexceedsmaxbytes'] = 'صورة الغلاف تتجاوز الحد الأقصى المسموح به لحجم الملف على مستوى الموقع ({$a})';
$string['error:coverimageresolutionlow'] = 'لأفضل جودة، نوصي بصورة أكبر بعرض 1024 بيكسل على الأقل.';
$string['error:duplicatedcategoryids'] = 'تنسيق JSON غير صحيح، يتم تكرار بعض المعرفات';
$string['error:failedtochangeassetvisibility'] = 'فشل إخفاء/إظهار الأصل';
$string['error:failedtochangesectionvisibility'] = 'فشل إخفاء/إظهار القسم';
$string['error:failedtohighlightsection'] = 'فشل تمييز القسم';
$string['error:failedtoduplicateasset'] = 'فشل التكرار';
$string['error:failedtodeleteasset'] = 'فشل حذف الأصل';
$string['error:failedtotoc'] = 'فشل في الحصول على TOC.';
$string['extension'] = 'تمديد {$a}';
$string['extra_section_menu'] = 'قائمة قسم إضافي';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'عنوان url الخاص بصفحتك على facebook.';
$string['favicon'] = 'أيقونة المفضلة';
$string['favicondesc'] = 'يظهر رمز الموقع في شريط عناوين مستعرض الويب الخاص بك، وفي الإشارات المرجعية للمستخدم، وفي اختصارات الأجهزة المحمولة.';
$string['favorite'] = 'المفضلة {$a}';
$string['favorited'] = 'مضاف إلى المفضلة {$a}';
$string['featurespots'] = 'مواضع الميزات';
$string['featurespotsedit'] = 'تحرير مواضع الميزات';
$string['featurespotshelp'] = '<p dir="rtl">أضِف ما يصل إلى 6 مواضع ميزات إلى الصفحة الأمامية لموقعك لإبراز الفوائد الأساسية للمستخدمين الحاليين والمحتملين.</p>
<p dir="rtl">يمكنك إضافة صورة، وعنوان، ووصف للمحتوى لكل ميزة. <strong>لعرض الميزة في الصفحة الأولى، يجب إدخال عنوان.</strong> أما قسما الصورة ووصف المحتوى فهما اختياريان.</p>
<p dir="rtl">مقاس الصورة الموصى به مربع ولا يزيد على 200 × 200 بكسل.</p>';
$string['featurespotsheading'] = 'عنوان مواضع الميزات';
$string['featureonetitle'] = 'عنوان الميزة 1';
$string['featuretwotitle'] = 'عنوان الميزة 2';
$string['featurethreetitle'] = 'عنوان الميزة 3';
$string['featurefourtitle'] = 'عنوان الميزة 4';
$string['featurefivetitle'] = 'عنوان الميزة 5';
$string['featuresixtitle'] = 'عنوان الميزة 6';
$string['featureonetitlelink'] = 'رابط عنوان الميزة 1';
$string['featuretwotitlelink'] = 'رابط عنوان الميزة 2';
$string['featurethreetitlelink'] = 'رابط عنوان الميزة 3';
$string['featurefourtitlelink'] = 'رابط عنوان الميزة 4';
$string['featurefivetitlelink'] = 'رابط عنوان الميزة 5';
$string['featuresixtitlelink'] = 'رابط عنوان الميزة 6';
$string['featuretitlelinkdesc'] = 'اكتب عنوان URL الذي تريد ربط موضع هذه الميزة به. يمكنك إضافة روابط خارجية أو داخلية داخل موقعك. لإضافة رابط داخلي، يرجى نسخه من عنوان URL الخاص بالموقع بما في ذلك /. على سبيل المثال، للحصول على رابط لمقرر دراسي ما، سيكون "course/view.php?id=160". ولإضافة رابط خارجي، ابدأ الرابط بـ https://';
$string['featureonetitlecb'] = 'تفتح الميزة 1 في نافذة جديدة';
$string['featuretwotitlecb'] = 'تفتح الميزة 2 في نافذة جديدة';
$string['featurethreetitlecb'] = 'تفتح الميزة 3 في نافذة جديدة';
$string['featurefourtitlecb'] = 'تفتح الميزة 4 في نافذة جديدة';
$string['featurefivetitlecb'] = 'تفتح الميزة 5 في نافذة جديدة';
$string['featuresixtitlecb'] = 'تفتح الميزة 6 في نافذة جديدة';
$string['featuretitlecbdesc'] = 'في حالة التمكين، سيتم فتح الرابط الذي تمت إضافته إلى الموضع المميز في نافذة جديدة';
$string['featureonetext'] = 'محتوى الميزة 1';
$string['featuretwotext'] = 'محتوى الميزة 2';
$string['featurethreetext'] = 'محتوى الميزة 3';
$string['featurefourtext'] = 'محتوى الميزة 4';
$string['featurefivetext'] = 'محتوى الميزة 5';
$string['featuresixtext'] = 'محتوى الميزة 6';
$string['featureoneimage'] = 'صورة الميزة 1';
$string['featuretwoimage'] = 'صورة الميزة 2';
$string['featurethreeimage'] = 'صورة الميزة 3';
$string['featurefourimage'] = 'صورة الميزة 4';
$string['featurefiveimage'] = 'صورة الميزة 5';
$string['featuresiximage'] = 'صورة الميزة 6';
$string['featuredcategoriesandcourses'] = 'الفئات والمقررات الدراسية المميزة';
$string['featuredcourses'] = 'المقررات الدراسية المميزة';
$string['featuredcourseshelp'] = 'قم بإبراز ما يصل إلى 8 مقررات دراسية مميزة إلى الصفحة الأمامية من موقعك. واكتب معرف المقرر الدراسي لتمييز مقرر دراسي.';
$string['featuredcoursesheading'] = 'عنوان المقررات الدراسية المميزة';
$string['featuredcourseone'] = 'المقرر الدراسي المميز 1';
$string['featuredcoursetwo'] = 'المقرر الدراسي المميز 2';
$string['featuredcoursethree'] = 'المقرر الدراسي المميز 3';
$string['featuredcoursefour'] = 'المقرر الدراسي المميز 4';
$string['featuredcoursefive'] = 'المقرر الدراسي المميز 5';
$string['featuredcoursesix'] = 'المقرر الدراسي المميز 6';
$string['featuredcourseseven'] = 'المقرر الدراسي المميز 7';
$string['featuredcourseeight'] = 'المقرر الدراسي المميز 8';
$string['featuredcoursesedit'] = 'تحرير المقررات الدراسية المميزة';
$string['featuredcoursesbrowseall'] = 'استعراض كل المقررات الدراسية';
$string['featuredcoursesbrowsealldesc'] = 'إضافة رابط استعراض جميع المقررات الدراسية';
$string['featuredcategories'] = 'الفئات المميزة';
$string['featuredcategorieshelp'] = 'يمكنك إبراز ما يصل إلى 8 فئات مميزة في الصفحة الأولى لموقعك. اكتب معرّف الفئة لتعيينها إلى فئة مميزة.';
$string['featuredcategoriesheading'] = 'عنوان الفئات المميزة';
$string['featuredcategoryone'] = 'الفئة المميزة 1';
$string['featuredcategorytwo'] = 'الفئة المميزة 2';
$string['featuredcategorythree'] = 'الفئة المميزة 3';
$string['featuredcategoryfour'] = 'الفئة المميزة 4';
$string['featuredcategoryfive'] = 'الفئة المميزة 5';
$string['featuredcategoriesix'] = 'الفئة المميزة 6';
$string['featuredcategorieseven'] = 'الفئة المميزة 7';
$string['featuredcategoryeight'] = 'الفئة المميزة 8';
$string['featuredcategoriesedit'] = 'تحرير الفئات المميزة';
$string['featuredcategoriesbrowseall'] = 'استعراض كل الفئات';
$string['featuredcategoriesbrowsealldesc'] = 'إضافة رابط لاستعراض كل الفئات';
$string['feature_spot_background_color'] = 'لون الخلفية';
$string['feature_spot_title_color'] = 'لون نص العنوان';
$string['feature_spot_description_color'] = 'لون نص الوصف';
$string['feature_spot_title_color_lower'] = 'لون نص العنوان';
$string['feature_spot_description_color_lower'] = 'لون نص الوصف';
$string['feedbackavailable'] = 'الملاحظات المتاحة';
$string['feedbacktoggle'] = 'الملاحظات والتقدير';
$string['feedbacktoggledesc'] = 'يعرض للمتعلمين أحدث الملاحظات الخاصة بهم، وأحدث الواجبات المرسلة التي تحتاج إلى تقدير للمعلمين.';
$string['footnote'] = 'تذييل الموقع';
$string['footnotedesc'] = 'يمكنك إضافة معلومات موقعك بتنسيق HTML وتضمين روابط أو صور أو قوائم أحداث.';
$string['forcepwdwarningpersonalmenu'] = 'يجب عليك <a href="{$a}">تغيير كلمة مرورك</a> قبل استخدام القائمة الشخصية.';
$string['forumauthor'] = 'المؤلف';
$string['forumlastpost'] = 'آخر مشاركة';
$string['forumpicturegroup'] = 'المجموعة';
$string['forumreplies'] = 'ردود';
$string['forumtopic'] = 'الموضوع';
$string['forumposts'] = 'مشاركات المنتدى';
$string['forumpoststoggle'] = 'مشاركات المنتدى';
$string['forumpoststoggledesc'] = 'عرض أحدث 10 مشاركات بالمنتديات للمستخدمين من المقررات الدراسية الخاصة بهم';
$string['fullname'] = 'اسم الموقع';
$string['fullnamedesc'] = 'اسم موقعك.';
$string['gotoactivity'] = 'الانتقال إلى النشاط {‎$a}';
$string['graderadviseuserreport'] = 'لا يعمل "تقرير واضع التقدير" جيدًا على الأجهزة المحمولة. لذا يوصى باستخدام "تقرير المستخدم" بدلاً من ذلك';
$string['grading'] = 'التقدير';
$string['help'] = 'مساعدة';
$string['helpguide'] = 'دليل المساعدة';
$string['headingfont'] = 'خط العنوان';
$string['headingfont_desc'] = 'يُستخدم هذا الخط "sans-serif" في العناوين (عناصر العناوين من h1 إلى h6) عبر موقعك، وإذا كنت تستخدم خط ويب مخصصًا، فتذكّر أن تضيفه إلى HTML الإضافي الخاص بـ Moodle. أما إذا أردت تعديل أنماط خطوط عناصر أخرى، فيُرجى استخدام خيار CSS المخصص، وللاطلاع على أمثلة على كيفية القيام بذلك، يُرجى مراجعة هذه <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">الوثائق</a>.';
$string['helpwithlogin'] = 'المساعدة في تسجيل الدخول';
$string['helpwithloginandguest'] = 'المساعدة في تسجيل الدخول / وصول الضيف';
$string['loginrequiredmessage'] = '* يشير إلى حقل مطلوب';
$string['hiddencoursestoggle'] = 'المقررات الدراسية المخفية';
$string['highlightedsection'] = 'مميَّز';
$string['home'] = 'الصفحة الرئيسية';
$string['image'] = 'صورة';
$string['images'] = 'الصور';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'عنوان url الخاص بحساب instagram الخاص بك.';
$string['introduction'] = 'مقدمة';
$string['jsontext'] = 'نص JSON';
$string['jsontextdescription'] = 'تقوم منطقة النص بالتحقق من صحة JSON المحدد، لذلك يتم السماح فقط بالفئات الموجودة، وتكون القيم العددية كسجلات المعرف (سجلات الفئة) فقط صالحة ويتم قبول القيم الست عشرية فقط كألوان. وفي ما يلي أحد الأمثلة على ذلك:<br>{"1":"#FAAFFF"،<br>"45":"#AFF"،<br>"65":"#FFF228"،<br>"12":"#CC0084"،<br>"56":"#CC0087"،<br>"89":"#CCF084"}';
$string['knowledgebase'] = 'فتح قاعدة معارف Open LMS';
$string['list'] = 'قائمة';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'عنوان url لـ LinkedIn الخاص بمؤسستك.';
$string['leftnav'] = 'جدول المحتويات';
$string['leftnavdesc'] = 'حدد مكان عرض جدول البيانات. تقدم القائمة مجال أوسع للمحتوى وتعمل بشكل جيد مع المقررات الدراسية التي تتضمن العديد من المواضيع.';
$string['loading'] = 'يتم الآن التحميل...';
$string['loggedinasguest'] = 'أنت مسجل الدخول كضيف';
$string['loggedoutmsg'] = 'أنت مسجل الخروج حاليًا. إذا كنت تريد متابعة استخدام هذا الموقع، يرجى تسجيل الدخول مرة أخرى.';
$string['loggedoutmsgtitle'] = 'أنت مسجل الخروج';
$string['loggedoutfailmsg'] = 'يجب أن تسجل الدخول إلى {$a}.';
$string['loginform'] = 'تسجيل الدخول';
$string['logo'] = 'الشعار';
$string['logodesc'] = 'يتم عرض شعارك في الرأس عبر الموقع بالكامل.';
$string['menu'] = 'المقررات الدراسية الخاصة بي';
$string['messageread'] = 'رسالة مقروءة';
$string['messages'] = 'الرسائل';
$string['messagestoggle'] = 'الرسائل';
$string['messagestoggledesc'] = 'اعرض للمستخدمين أحدث رسائلهم المستلمة خلال آخر 12 أسبوعًا. لتمكين هذا الخيار، تأكد من تنشيط ميزة المراسلة في صفحة الميزات المتقدمة.';
$string['more'] = 'المزيد';
$string['morenews'] = 'مزيد من الأخبار';
$string['moreoptionslabel'] = 'المزيد من الخيارات';
$string['movingstartedhelp'] = 'انتقل إلى حيث تريد وضع القسم "{$a}"';
$string['movingdropsectionhelp'] = 'ضع القسم "{$a->moving}" قبل القسم "{$a->before}"';
$string['moving'] = 'نقل "{$a}"';
$string['movingcount'] = 'نقل كائنات {$a}';
$string['movefailed'] = 'فشل نقل "{$a}"';
$string['move'] = 'نقل "{$a}"';
$string['movehere'] = 'نقل إلى هنا';
$string['movesection'] = 'نقل قسم';
$string['navbarbg'] = 'لون الخلفية';
$string['navbarlink'] = 'لون النص';
$string['navbarbuttoncolor'] = 'لون الخلفية';
$string['navbarbuttonlink'] = 'لون النص';
$string['nextsection'] = 'القسم التالي';
$string['nodeadlines'] = 'ليس لديك مواعيد نهائية قادمة.';
$string['noforumposts'] = 'ليس لديك مشاركات منتديات ذات صلة.';
$string['nograded'] = 'ليس لديك ملاحظات حديثة.';
$string['nograding'] = 'ليس لديك تقديمات للتقدير.';
$string['nomessages'] = 'ليس لديك رسائل.';
$string['notanswered'] = 'لم تتم إجابته';
$string['notattempted'] = 'لم يتم إجراء محاولة';
$string['notcontributed'] = 'غير ممنوح';
$string['notpublished'] = 'لم يتم نشره للطلاب';
$string['notsubmitted'] = 'غير مقدَّم';
$string['overdue'] = 'متأخر';
$string['pausegraphicsanim'] = 'إيقاف نسق الرسوم المتبادلة GIF.';
$string['personalmenu'] = 'القائمة الشخصية';
$string['personalmenuandsnapfeeds'] = 'القائمة الشخصية والموجزات في Snap';
$string['personalmenufeatures'] = 'ميزات القائمة الشخصية';
$string['personalmenulogintoggle'] = 'إظهار القائمة الشخصية عند تسجيل الدخول';
$string['personalmenulogintoggledesc'] = 'فتح القائمة الشخصية مباشرة بعد تسجيل الدخول';
$string['personalmenuadvancedfeedsenable'] = 'قم بتمكين الموجزات المتقدمة';
$string['personalmenuadvancedfeedsenabledesc'] = 'تقوم المواجز المتقدمة بتحميل بعض عناصر القائمة الشخصية التي تتيح أوقات تحميل أسرع وتحديث المحتوى حسب الطلب.';
$string['personalmenuadvancedfeedsperpage'] = 'عدد مرات عرض عناصر المواجز المتقدمة';
$string['personalmenuadvancedfeedsperpagedesc'] = 'اختر عدد العناصر المراد عرضها في الموجز. يمكن للمستخدمين تحديد <strong>عرض المزيد</strong> لعرض عناصر إضافية.';
$string['personalmenuadvancedfeedslifetime'] = 'عمر المواجز المتقدمة';
$string['personalmenuadvancedfeedslifetimedesc'] = 'اختر مقدار الوقت الذي سيتم فيه تخزين المواجز مؤقتًا في المستعرض بعد تسجيل الدخول. لن يؤدي تعيين القيمة إلى 0 إلى تخزين المواجز في المستعرض مؤقتًا.';
$string['personalmenurefreshdeadlines'] = 'حَدِّث المواعيد النهائية باستخدام التكليف الدراسي المجدول.';
$string['personalmenurefreshdeadlinesdesc'] = 'عند تشغيل المهمة، سيتم تحديث بيانات الموعد النهائي للحصول على أوقات تحميل أسرع للصفحات.';
$string['personalmenuenablepersonalmenu'] = 'تمكين القائمة الشخصية';
$string['personalmenuenablepersonalmenuheading'] = 'القائمة الشخصية';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'ملاحظة: إذا تم تعطيل القائمة الشخصية، فستتمكن من الوصول إلى المقررات الدراسية الخاصة بك من صفحة المقررات الدراسية الخاصة بي. يُرجى التأكد من تمكين كتلة النظرة العامة على المقرر الدراسي، بحيث تصبح المقررات الدراسية مرئية في الصفحة.';
$string['personalmenuenablepersonalmenudesc'] = 'سيفتح رابط المقررات الدراسية الخاصة بي القائمة الشخصية. إذا تم تعطيله، فسيتم إعادة التوجيه إلى صفحة المقررات الدراسية الخاصة بي.';
$string['mycoursessnapfeedsheading'] = 'الموجزات في Snap';
$string['mycoursessnapfeedsdesc'] = 'ملاحظة: تصبح <strong>الموجزات المتقدمة</strong> متاحة فقط عند تحديد واحد على الأقل من الخيارات <strong>المواعيد النهائية</strong> أو <strong>الملاحظات والتقدير</strong> أو <strong>الرسائل</strong> أو <strong>مشاركات المنتدى</strong>.';
$string['refreshdeadlinestasksettingheading'] = 'حَدِّث المواعيد النهائية باستخدام المهمة الدراسية المجدولة';
$string['pld'] = 'PLD';
$string['pluginname'] = 'محاذاة';
$string['poster'] = 'صورة الغلاف';
$string['posterdesc'] = 'صورة رأس كبيرة لصفحة موقعك الأمامية. تعمل الصور الأفقية بحجم (1200 × 600 بكسل) أو الأكبر حجمًا بشكل أفضل.';
$string['poweredbyrunby'] = 'تم الإنشاء باستخدام <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>، منتج مستند إلى.<a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>حقوق الطبع والنشر © لسنة {‎$a->year} Open LMS، جميع الحقوق محفوظة.';
$string['previoussection'] = 'القسم السابق';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'معرف المقرر الدراسي الخاص بالمقرر الدراسي الذي يفضله المستخدم';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'معرف المستخدم الخاص بالمقرر الدراسي الذي يفضله المستخدم';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'الطابع الزمني الخاص بالمستخدم عند قيام المستخدم بتفضيل المقرر الدراسي';
$string['privacy:metadata:theme_snap_course_favorites'] = 'تخزين تفضيلات المقرر الدراسي الخاصة بالمستخدم في Snap';
$string['problemsfound'] = 'تم العثور على مشكلات';
$string['progress'] = 'التقدم';
$string['readmore'] = 'قراءة المزيد&nbsp;»';
$string['recentactivity'] = 'النشاط الحديث';
$string['recentfeedback'] = 'ملاحظات';
$string['region-main'] = 'رئيسي';
$string['region-side-main-box'] = 'رئيسي';
$string['region-side-post'] = 'لليمين';
$string['region-side-pre'] = 'لليسار';
$string['region-side-top'] = 'أعلى';
$string['released'] = 'المحرَّر: {$a}';
$string['reopened'] = 'تم إعادة الفتح';
$string['resourcedisplay'] = 'عرض المورد';
$string['resourcedisplayhelp'] = 'حدد كيفية ظهور المرفقات والروابط في مقررك الدراسي. لا تدعم السمة Snap ملفات الوسائط المتعددة في وصف بطاقات الموارد والأنشطة الصغيرة.';
$string['resumegraphicsanim'] = 'إيقاف نسق الرسومات المتبادلة GIF.';
$string['displaydescription'] = 'عرض الوصف';
$string['displaydescriptionhelp'] = 'حدد لإظهار وصف لأنشطة المورد في صفحة جديدة أولاً. وسيقوم الطلاب بالوصول إلى المحتوى من الوصف.';
$string['search'] = 'محتويات البحث';
$string['showcoursegradepersonalmenu'] = 'التقديرات';
$string['showcoursegradepersonalmenudesc'] = 'تعرض للمستخدمين تقديراتهم في بطاقات المقرر الدراسي في القائمة الشخصية';
$string['socialmedia'] = 'الوسائط الاجتماعية';
$string['submitted'] = 'تم إرساله';
$string['sitedescription'] = 'وصف الموقع';
$string['subtitle'] = 'العنوان الفرعي';
$string['subtitle_desc'] = 'يصف بإيجاز موقعك للمستخدمين.';
$string['summarylabel'] = 'ملخص القسم';
$string['themecolor'] = 'لون الموقع';
$string['themecolordesc'] = 'تحقق الألوان الزاهية نتائج أفضل وسوف تمنح موقعك مظهرًا عصريًا.';
$string['title'] = 'العنوان';
$string['top'] = 'أعلى';
$string['topbarbgcolor'] = 'لون شريط التنقل';
$string['topbarlinkcolor'] = 'رابط شريط التنقل ولون الرمز';
$string['topbarbuttoncolor'] = 'خلفية المقررات الدراسية الخاصة بي';
$string['togglenavigation'] = 'تغيير التنقل';
$string['topicactions'] = 'إجراءات الموضوع';
$string['xakatwitter'] = '𝕏';
$string['xakatwitterdesc'] = 'عنوان URL الخاص بحسابك على 𝕏.';
$string['unenrolme'] = 'إلغاء تسجيلي';
$string['enrolme'] = 'سجلني';
$string['unread'] = 'غير مقروء';
$string['unsupportedcoverimagetype'] = 'نوع صورة الغلاف ({$a}) غير مدعوم';
$string['via'] = 'عبر';
$string['viewcourse'] = 'عرض المقرر الدراسي';
$string['viewmore'] = 'عرض المزيد';
$string['viewyourprofile'] = 'عرض ملف تعريفك';
$string['viewmyfeedback'] = 'عرض ملاحظاتي';
$string['viewcalendar'] = 'عرض تقويمي';
$string['viewforumposts'] = 'عرض مشاركات منتدياتي';
$string['viewmessaging'] = 'عرض رسائلي';
$string['vieworiginalimage'] = 'عرض الصورة الأصلية';
$string['visibility'] = 'الرؤية';
$string['xofyanswered'] = '{$a->completed} من أصل {$a->participants} قاموا بالإجابة';
$string['xofyattempted'] = '{$a->completed} من أصل {$a->participants} قاموا بالمحاولة';
$string['xofycontributed'] = '{$a->completed} من أصل {$a->participants} قاموا بالمساهمة';
$string['xofysubmitted'] = '{$a->completed} من أصل {$a->participants} قاموا بالتقديم';
$string['xungraded'] = '{$a} غير مُقدر';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'عنوان url الخاص بقناة youtube الخاصة بك.';
$string['showallsectionsdisabled'] = 'نظرًا للغة التصميم الخاصة بها، لا يتوفر خيار "إظهار كل الأقسام في صفحة واحدة" في Snap.';
$string['disabled'] = 'مُعطَّل';
$string['showappearancedisabled'] = 'تمنع لغة تصميم Snap التغييرات التي يتم إجراؤها على إعدادات "المظهر".';
$string['pbb'] = 'العلامة التجارية المستندة إلى ملف التعريف';
$string['pbb_description'] = 'بتمكين <strong>العلامة التجارية المستندة إلى ملف التعريف</strong>، ستتمكن من تخصيص تجربة العلامة التجارية لمجموعة محددة من المستخدمين بناءً على حقل ملف تعريف المستخدم الذي تم اختياره.<ul dir="rtl"><li>سيتم <em>تغيير</em> قيمة حقل المستخدم؛ مع تحويل كل الأحرف إلى الحالة الصغيرة والفصل بينها بشرطة (-)</li>
<li>سيتم إلحاق السلسلة <code>snap-pbb-</code></li>
<li>ستتم إضافة هذه الفئة إلى وسم <code>body</code> في Html</li></ul>على سبيل المثال، سيتم تغيير قيمة حقل المستخدم <em>Blueberry Extravaganza</em> لتكون <code>snap-pbb-blueberry-extravaganza</code><br /><br />تُستخدم هذه الميزة بالاقتران بـ CSS المخصصة، وستحتاج إلى إضافة محددات CSS باستخدام فئات جديدة في القسم <a class="snap-settings-tab-link" href="#themesnapbranding">الأساسيات</a>.';
$string['pbb_enable'] = 'تمكين العلامة التجارية المستندة إلى ملف التعريف';
$string['pbb_enable_description'] = 'إضافة الفئة فقط إلى وسم النص الأساسي إذا كان نشطًا.';
$string['pbb_field'] = 'حقل المستخدم المراد استخدامه';
$string['pbb_field_description'] = 'سيتم تغيير قيمة هذا الحقل واستخدامها كاسم لفئة CSS ملحق به <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'التخزين المؤقت للعلامة التجارية المستندة إلى ملف التعريف.';
$string['cachedef_course_card_bg_image'] = 'التخزين المؤقت لصورة خلفية المقرر الدراسي.';
$string['cachedef_course_card_teacher_avatar'] = 'التخزين المؤقت للأشكال الرمزية للمعلم.';
$string['cachedef_course_card_teacher_avatar_index'] = 'التخزين المؤقت لفهرس الأشكال الرمزية للمعلم.';
$string['accessforumstringdis'] = 'خيارات العرض';
$string['accessforumstringmov'] = 'خيارات النقل';
$string['accesscalendarstring'] = 'التقويم';
$string['accessglobalsearchstring'] = 'بحث';
$string['admineventwarning'] = 'لرؤية الأحداث من جميع المقررات الدراسية،';
$string['gotocalendarsnap'] = 'انتقل إلى تقويم الموقع.';
$string['quizattemptswarn'] = 'استبعاد محاولات المستخدمين المعلقين';
$string['quizfeedback'] = 'ملاحظات';
$string['validratio'] = 'تتوافق تركيبة الألوان هذه مع قيمة النسبة الدنيا WCAG 2.0 4.5:1';
$string['invalidratio'] = 'لا تتوافق تركيبة الألوان هذه مع <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a>. القيمة: "{$a}"';
$string['imageinvalidratio'] = 'قد تواجه هذه الصورة مشكلات تباين بسبب عدم التوافق مع قيمة النسبة الدنيا WCAG 2.0 4.5:1. متوسط قيمة البكسل: "{$a}"';
$string['catinvalidratio'] = 'لا تتوافق فئات الألوان التالية مع <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a> : مقابل لون خلفية الموقع (أبيض): "{a$->white}" مقابل لون خلفية شريط التنقل: "{a$->custombar}". مقابل لون خلفية زر المقررات الدراسية الخاصة بي: "{a$->customnav}"';
$string['spotinvalidratio'] = 'لا يتوافق لون الخلفية مع <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a> القيمة الحالية مقابل {$a->name}: {$a->value}.';
$string['imageinvalidratiocategory'] = 'قد تواجه هذه الصورة مشاكل تباين مع لون الشكل بسبب عدم التوافق مع قيمة النسبة الدنيا WCAG 2.0 4.5:1. متوسط قيمة البكسل: "{$a}"';
$string['browseallcategories'] = 'استعراض كل الفئات';
$string['lazyload_mod_page'] = 'تمكين التحميل البطيء الافتراضي لموارد الصفحات';
$string['lazyload_mod_page_description'] = 'في حالة التمكين، يقوم الإعداد بتقليل أوقات تحميل صفحات المقرر الدراسي بشكل كبير فيما يخص المقررات الدراسية التي تحتوي على العديد من الصفحات.';
$string['pmadvancedfeed_viewmore'] = 'عرض المزيد';
$string['pmadvancedfeed_reload'] = 'تحديث';
$string['multimediacard'] = 'لن يتم عرض ملفات الوسائط المتعددة في طرق عرض بطاقة النشاط الخاصة بالسمة Snap. وسيتم تطبيق هذا في الصفحة الرئيسية وصفحات المقرر الدراسي فقط لبطاقات الموارد والأنشطة الصغيرة.';
$string['enabledlogin'] = 'خيارات تسجيل الدخول التي تم عرضها';
$string['enabledlogindesc'] = 'حدد خيارات تسجيل الدخول التي يجب عرضها.';
$string['moodlelogin'] = 'عرض تسجيل الدخول إلى Moodle فقط';
$string['alternativelogin'] = 'عرض خيارات تسجيل الدخول البديلة فقط';
$string['bothlogin'] = 'عرض كلًا من خيارات تسجيل الدخول';
$string['enabledloginorder'] = 'ترتيب خيارات تسجيل الدخول';
$string['enabledloginorderdesc'] = 'حدد خيار تسجيل الدخول الذي يجب عرضه أولًا.';
$string['moodleloginfirst'] = 'عرض تسجيل الدخول إلى Moodle أولًا';
$string['alternativeloginfirst'] = 'عرض خيارات تسجيل الدخول البديلة أولًا';
$string['alternativeloginoptions'] = 'خيارات تسجيل الدخول البديلة';
$string['openmessagedrawer'] = 'فتح درج المراسلة.';
$string['refreshdeadlinestask'] = 'قم بتحديث المواعيد النهائية للبيانات المُخَزّنة مؤقتًا. ينبغي تشغيل ذلك قبل تسجيل دخول جميع المستخدمين.';
$string['resetdeadlinesquerycounttask'] = 'إعادة تعيين عدد الاستعلامات عن المواعيد النهائية';
$string['refreshdeadlinestaskoff'] = 'لم يتم البحث عن بيانات لتعبئتها. يرجى تشغيل الإعداد "تحديث المواعيد النهائية باستخدام المهمة المجدولة" في إعدادات القائمة الشخصية لـ Snap للسماح لهذه المهمة بملء بيانات ذاكرة التخزين المؤقت للمواعيد النهائية.';
$string['activityrestriction'] = 'تقييد النشاط';
$string['hideandshowactioncb'] = 'إخفاء وإظهار إجراء مربع اختيار النشاط';
$string['retryfeed'] = 'هذا الموجز غير متاح حاليًا، يرجى التحقق مرةً أخرى لاحقًا. الموجز: {‎$a}';
$string['loadingfeed'] = 'جارٍ التحميل...قد يستغرق بعض الوقت';
$string['hvpcustomcss'] = 'CSS المخصص لوحدة H5P';
$string['hvpcustomcssdesc'] = 'تخصيص CSS لوحدة H5P ‏(moodle.org/plugins/mod_hvp) في حال التثبيت.';
$string['courselimitstrdanger'] = 'لن يتم عرض شريط التقدم الخاص بحد المقرر الدراسي الذي تم التوصل إليه.';
$string['courselimitstrwarning'] = 'إذا تم إدراج ما يزيد على {‎$a} من المقررات الدراسية، فلن يتم عرض شريط التقدم';
$string['tilesformatcoursehomealttext'] = 'الصفحة الرئيسية للمقرر الدراسي';
$string['editmodetiles'] = 'تحرير المحتوى';
$string['totop'] = 'الانتقال إلى الأعلى';
$string['loginsetting'] = 'صفحة تسجيل الدخول';
$string['loginbgimgheading'] = 'قالب صفحة تسجيل الدخول';
$string['loginbgimgheadingdesc'] = 'تتيح Snap التغيير بين القوالب المختلفة التي سيتم عرضها في صفحة تسجيل الدخول. يُرجى التحديد من بين الخيارات المختلفة الموجودة في القائمة المنسدلة أدناه.';
$string['loginpagetemplate'] = 'حدد قالب صفحة تسجيل الدخول المراد استخدامه';
$string['classic_template'] = 'القالب الكلاسيكي';
$string['loginbgimg'] = 'صورة خلفية تسجيل الدخول';
$string['loginbgimgdesc'] = 'حدد الصور التي ستظهر في خلفية صفحة تسجيل الدخول. ولتحظى بتجربة أفضل مع الصور المعروضة، يُرجى رفع ملفات لها نسبة عرض إلى ارتفاع قدرها 16:9 (بدقة 720 بكسل أو بأبعاد 1280×720 بكسل). ويجب أن تكون للصور المرفوعة الأبعاد نفسها للعرض بشكل صحيح.';
$string['stylish_template'] = 'القالب الأنيق';
$string['activityedit'] = 'تحرير النشاط';
$string['snapfeedsblocktitle'] = 'الموجزات في Snap';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'عنوان URL الخاص بحسابك على TikTok.';
$string['snapfootersettings'] = 'تذييل Snap';
$string['snapfootercustomization'] = 'تخصيص التذييل';
$string['snapfootercustomizationdesc'] = 'يسمح Snap بتخصيص تذييل السمة، الذي يتم عرضه في جميع أنحاء الموقع. قم بتحسين تجربة المستخدم عن طريق إضافة روابط مفيدة أو موارد دعم أو أي معلومات قيمة أخرى حول مؤسستك ترغب في مشاركتها مع المتعلمين والمعلمين.';
$string['snapfootercolors'] = 'ألوان تذييل الموقع';
$string['snapfootercolorsdesc'] = 'يمكن تغيير ألوان التذييل: لتغيير لون الخلفية و/أو لون النص، حددهما في منتقيات الألوان التالية.';
$string['snapfooterbgcolor'] = 'لون خلفية التذييل';
$string['snapfootertxtcolor'] = 'لون نص التذييل';
$string['enableblockmyoverviewwarning'] = 'تم تعطيل كتلة النظرة العامة على المقرر الدراسي. من أجل عرض المقررات الدراسية، يُرجى تمكين الكتلة.';
$string['collapseicon'] = 'طي محتوى';
$string['expandicon'] = 'توسيع محتوى';
$string['imageproperties'] = 'خصائص الصورة';
$string['coverimagedesc'] = 'حدد الصورة لتظهر على الغلاف، مع التأكد من أن تكون بتنسيق ‎.jpeg أو ‎.png أو ‎.gif. ويجب ألا تتجاوز حجم الملف الأقصى المسموح به على مستوى الموقع ({‎$a}). للحصول على أفضل عرض، يُنصح باستخدام نسبة أبعاد 4:3 (1024×768 بكسل). كذلك، يُفضل مراعاة تركيبات الألوان التي تتماشى مع إرشادات WCAG 2.0، خصوصًا في ما يتعلق بالعنوان الأبيض للمقرر الدراسي، لتحسين تجربة المستخدم.';
$string['coverimagecropperdesc'] = 'حدد المنطقة المراد عرضها من الصورة باستخدام مربع الاقتصاص.';
$string['browserepositories'] = 'رفع صورة جديدة';
$string['saveimage'] = 'حفظ الصورة';
$string['selectimage'] = 'تحديد صورة';
$string['deleteimage'] = 'حذف صورة الغلاف';
$string['confirmdeletefile'] = 'سيؤدي هذا الإجراء إلى حذف صورة الغلاف. هل تريد بالتأكيد حذف الملف المحفوظ؟';
$string['coverimagesettingswarning'] = 'إذا قمت بتحديث صورة الغلاف مباشرة من صفحة إعدادات المقرر الدراسي، فستتم إعادة تعيين الصورة المقتصة. يرجى تذكر إعادة تحديد جزء الاقتصاص المراد بعد ذلك.';
$string['opens'] = 'يتم فتح {‎$a}';
$string['opened'] = 'تم فتح {‎$a}';
$string['year'] = 'سنة';
$string['homepage'] = 'الصفحة الرئيسية';
$string['allyears'] = 'كل السنوات';
$string['courselink'] = 'الانتقال إلى المقرر الدراسي';
