/**
 * This file is part of Moodle - http://moodle.org/
 *
 * Moodle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Moodle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package
 * @copyright Copyright (c) 2015 Open LMS (https://www.openlms.net)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_snap/cover_image",["jquery","core/log","core/ajax","core/notification","theme_snap/ajax_notification","./cropper"],(function($,log,ajax,notification,ajaxNotify,Cropper){var savedImageURL=$("#page-header").css("background-image"),temporalImageURL="none",temporalImageID=0,temporalFileName="",cropper=null,cropperRatio=6;$("#page-site-index").length&&(cropperRatio=3);var addCoverImageAlert=function(id,msg){let position=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;if("dialogue"===position)var alertPosition=".snap_cover_image_description";else alertPosition="#snap-coverimagecontrol";var closestr=M.util.get_string("closebuttontitle","moodle");$(id).length||$(alertPosition).before('<div id="'+id+'" class="snap-alert-cover-image alert alert-warning" role="alert">'+msg+'<button type="button" class="close" data-dismiss="alert" aria-label="'+closestr+'"><span aria-hidden="true">&times;</span></button></div>')},state1=function(){temporalImageURL="none",temporalImageID=0,temporalFileName="",$("#page-header").css("background-image",savedImageURL),"none"===savedImageURL&&($(".path-course-view #page-header").removeClass("mast-image"),$(".path-course-view #page-header .breadcrumb-item a").removeClass("mast-breadcrumb")),$("#snap-alert-cover-image-size").remove(),$("#snap-alert-cover-image-bytes").remove(),$("#snap-coverfiles").val(""),$("#snap-changecoverimageconfirmation .ok").removeClass("ajaxing"),$("#snap-changecoverimageconfirmation").removeClass("state-visible"),$('label[for="snap-coverfiles"]').removeClass("ajaxing"),$('label[for="snap-coverfiles"]').addClass("state-visible"),$("body").removeClass("cover-image-change")},state2=function(){$("#snap-alert-cover-image-upload-failed").remove(),$("#snap-changecoverimageconfirmation").removeClass("disabled"),$('label[for="snap-coverfiles"]').removeClass("state-visible"),$("#snap-changecoverimageconfirmation").addClass("state-visible"),$("body").removeClass("cover-image-change")},aspectRatioOptions=function(){$("#page-course-view-topics, #page-course-view-weeks").length&&($("#page-header #course-toc").length?(cropperRatio=3,cropper.setAspectRatio(cropperRatio)):(cropperRatio=6,cropper.setAspectRatio(cropperRatio)))},moodledialogue=function(courseShortName,categoryId,fpoptions,siteMaxBytes){var size,i,maxbytesstr=(size=siteMaxBytes,i=Math.floor(Math.log(size)/Math.log(1024)),1*(size/Math.pow(1024,i)).toFixed(2)+" "+["B","kB","MB","GB","TB"][i]);let title=M.util.get_string("imageproperties","theme_snap"),coverImageDesc=M.util.get_string("coverimagedesc","theme_snap",maxbytesstr),coverImageCropperDesc=M.util.get_string("coverimagecropperdesc","theme_snap"),coverImageSettingsWarning=M.util.get_string("coverimagesettingswarning","theme_snap"),browseRepositories=M.util.get_string("browserepositories","theme_snap"),selectImageString=M.util.get_string("selectimage","theme_snap"),deleteImageString=M.util.get_string("deleteimage","theme_snap"),previewDisplay="'display:none'",currentImageURL="";var currentImageUrl;"none"!==temporalImageURL?currentImageURL=temporalImageURL:(currentImageURL="none"===(currentImageUrl=savedImageURL)?($(".snap_cover_image_save_button").addClass("d-none"),""):($(".snap_cover_image_save_button").removeClass("d-none"),currentImageUrl=currentImageUrl.replace("url(","").replace(")","").replace(/['"]+/g,"").replace(";","").replace("croppedimage","coverimage").replace("course-image-cropped","course-image").replace("category-image-cropped","category-image").replace("site-image-cropped","site-image")),temporalImageURL=currentImageURL),""!==currentImageURL&&(previewDisplay="'display:block'");let content='<div class="mb-1 snap_cover_image_dialogue"><p class="snap_cover_image_description">'+coverImageDesc+'</p><p class="snap_cover_image_cropper_description d-none">'+coverImageCropperDesc+'</p><p class="snap_cover_image_cropper_description d-none">'+coverImageSettingsWarning+'</p><div class="input-group input-append w-100 snap_cover_image_options"><button class="btn btn-secondary snap_cover_image_browser" id="id_snap_cover_image_browser">'+browseRepositories+'</button><button class="btn btn-secondary snap_cover_image_delete_image_button d-none" id="id_snap_cover_image_delete_image">'+deleteImageString+'</button></div><div class="mdl-align"><div class="snap_cover_image_preview_box"><img id="id_snap_cover_image_preview" class="snap_cover_image_preview" alt="" style='+previewDisplay+"src="+currentImageURL+'></div></div><div class="snap_cover_image_save"><button class="btn btn-primary snap_cover_image_save_button d-none" id="id_snap_cover_image_save_button">'+selectImageString+"</button></div></div>";var dialogue=new M.core.dialogue({headerContent:title,bodyContent:content,width:"800px",modal:!0,visible:!1,render:!0,additionalBaseClass:"snap_cover_image_dialogue"});if(dialogue.show(),"none"!==savedImageURL&&$(".snap_cover_image_delete_image_button").removeClass("d-none"),""!==currentImageURL){$(".snap_cover_image_save_button").removeClass("d-none");var imageToCrop=document.getElementById("id_snap_cover_image_preview");cropper=new Cropper(imageToCrop,{viewMode:3,aspectRatio:cropperRatio,dragMode:"none",zoomable:!1,minCropBoxWidth:300}),aspectRatioOptions(),$(".snap_cover_image_cropper_description").removeClass("d-none"),$("#id_snap_cover_image_save_button").click((function(){if(null!==cropper.getCroppedCanvas()){var croppedImage=cropper.getCroppedCanvas().toDataURL("image/png");$(".path-course-view #page-header").addClass("mast-image"),$(".path-course-view #page-header .breadcrumb-item a").addClass("mast-breadcrumb"),$("#page-header").css("background-image","url("+croppedImage+")"),state2(),saveImage({},courseShortName,categoryId,cropper)}}))}$(".snap_cover_image_delete_image_button").click((function(e){e.preventDefault(),cropper=null;let cancelString=M.util.get_string("cancel","moodle"),confirmString=M.util.get_string("yes","moodle"),confirmDeleteString=M.util.get_string("confirmdeletefile","theme_snap");var cancelButton='<button id="delete_image_cancel_button" class="btn btn-secondary">'+cancelString+"</button>",confirmButton='<button id="delete_image_confirm_button" class="btn btn-primary">'+confirmString+"</button>";dialogue.hide();let deleteDialogueContent='<div class="mb-1 snap_cover_image_delete_dialogue"><p class="snap_cover_image_delete_description">'+confirmDeleteString+'</p><div class="snap_cover_image_delete_confirmation">'+cancelButton+confirmButton+"</div></div>";var confirmationDialogue=new M.core.dialogue({headerContent:title,bodyContent:deleteDialogueContent,width:"600px",modal:!0,visible:!1,render:!0,additionalBaseClass:"snap_cover_image_delete_image_dialogue"});confirmationDialogue.show(),confirmationDialogue.after("visibleChange",(function(){confirmationDialogue.get("visible")||(state1(),confirmationDialogue.destroy(!0))})),$("#delete_image_cancel_button").click((function(e){e.preventDefault(),confirmationDialogue.hide()})),$("#delete_image_confirm_button").click((function(e){e.preventDefault();var ajaxParams={};null!==categoryId?ajaxParams.categoryid=categoryId:null!==courseShortName&&(ajaxParams.courseshortname=courseShortName),ajaxParams.deleteimage=!0,ajax.call([{methodname:"theme_snap_cover_image",args:{params:ajaxParams},done:function(){temporalImageURL="none",temporalImageID=0,temporalFileName="",savedImageURL="none",cropper=null,state1(),$("#page-header").removeClass("mast-image"),$("#page-header .breadcrumb-item a").removeClass("mast-breadcrumb"),$("#page-header").data("servercoverfile","none"),$("#page-header").css("background-image","none"),confirmationDialogue.hide()},fail:function(response){ajaxNotify.ifErrorShowBestMsg(response)}}],!0,!0)}))})),$("body").addClass("cover-image-change"),$('label[for="snap-coverfiles"]').addClass("ajaxing"),$("#id_snap_cover_image_browser").click((function(e){e.preventDefault(),showFilepicker("image",fpoptions,filepickerCallback(courseShortName,categoryId),dialogue)})),$("#id_snap_cover_image_save_button").click((function(){dialogue.hide()})),$(".snap_cover_image_dialogue .closebutton, .moodle-dialogue-lightbox").click((function(){cropper=null,state1()})),dialogue.after("visibleChange",(function(){$("#snap-changecoverimageconfirmation .ok").hasClass("ajaxing")&&state2(),dialogue.get("visible")||dialogue.destroy(!0)}))},filepickerCallback=function(courseShortName,categoryId){return function(params){if(""!==params.url){if(temporalImageURL=params.url,temporalFileName=params.file,void 0!==params.id)temporalImageID=params.id;else if(void 0!==params.file){var fileNameWithoutSpaces=params.file.replace(/ .*/,""),regex=new RegExp("draft\\/(\\d+)\\/"+fileNameWithoutSpaces,"g"),urlId=params.url.match(regex);temporalImageID=urlId[0].match(/\d+/)[0]}!function(params,courseShortName,categoryId){var image=new Image;image.onerror=function(){document.getElementById("id_snap_cover_image_preview").setAttribute("style","display:none")},image.onload=function(){var input,imageWidth=this.width;if((input=document.getElementById("id_snap_cover_image_preview")).setAttribute("src",params.url),input.setAttribute("style","display:block"),$(".snap_cover_image_save_button").removeClass("d-none"),imageWidth<1024?($("#snap-alert-cover-image-size").remove(),addCoverImageAlert("snap-alert-cover-image-size",M.util.get_string("error:coverimageresolutionlow","theme_snap"),"dialogue")):$("#snap-alert-cover-image-size").remove(),null!==cropper)cropper.replace(params.url);else{var imageToCrop=document.getElementById("id_snap_cover_image_preview");if(temporalImageURL=params.url,temporalFileName=params.file,void 0!==params.id)temporalImageID=params.id;else if(void 0!==params.file){var fileNameWithoutSpaces=params.file.replace(/ .*/,""),regex=new RegExp("draft\\/(\\d+)\\/"+fileNameWithoutSpaces,"g"),urlId=params.url.match(regex);temporalImageID=urlId[0].match(/\d+/)[0]}cropper=new Cropper(imageToCrop,{viewMode:3,aspectRatio:cropperRatio,dragMode:"none",zoomable:!1,minCropBoxWidth:300})}aspectRatioOptions(),$(".snap_cover_image_cropper_description").removeClass("d-none"),$("#id_snap_cover_image_save_button").click((function(){var croppedImage=cropper.getCroppedCanvas().toDataURL("image/png");$(".path-course-view #page-header").addClass("mast-image"),$(".path-course-view #page-header .breadcrumb-item a").addClass("mast-breadcrumb"),$("#page-header").css("background-image","url("+croppedImage+")"),state2(),saveImage(params,courseShortName,categoryId,cropper)}))},image.src=params.url}(params,courseShortName,categoryId);var ajaxParams={};ajaxParams.fileid=temporalImageID,ajaxParams.imagefilename=temporalFileName,ajaxParams.contrastvalidation=!0,null!==categoryId?ajaxParams.categoryid=categoryId:null!==courseShortName&&(ajaxParams.courseshortname=courseShortName),ajax.call([{methodname:"theme_snap_cover_image",args:{params:ajaxParams},done:function(response){$("#snap-alert-cover-image-contrast").remove(),response.contrast&&addCoverImageAlert("snap-alert-cover-image-contrast",response.contrast,"dialogue")},fail:function(response){ajaxNotify.ifErrorShowBestMsg(response)}}],!0,!0)}}},showFilepicker=function(type,fpoptions,callback,dialogue){Y.use("core_filepicker",(function(Y){var options=fpoptions;options.formcallback=callback,M.core_filepicker.show(Y,options)})),$(".filepicker .closebutton").click((function(){dialogue.hide(),state1()}))},saveImage=function(params,courseShortName,categoryId,cropper){$("#snap-changecoverimageconfirmation .ok").off("click").click((function(){var ajaxParams={};if(null!==categoryId)ajaxParams.categoryid=categoryId;else{if(null===courseShortName)return;ajaxParams.courseshortname=courseShortName}if(void 0!==params.id)ajaxParams.fileid=params.id;else if(void 0!==params.file){var fileNameWithoutSpaces=params.file.replace(/ .*/,""),regex=new RegExp("draft\\/(\\d+)\\/"+fileNameWithoutSpaces,"g"),urlId=params.url.match(regex);ajaxParams.fileid=urlId[0].match(/\d+/)[0]}else ajaxParams.fileid=temporalImageID;void 0!==params.file?ajaxParams.imagefilename=params.file:ajaxParams.imagefilename=temporalFileName,void 0!==params.url?ajaxParams.originalimageurl=params.url:ajaxParams.originalimageurl=temporalImageURL,cropper.getCroppedCanvas().toBlob((blob=>{var reader=new FileReader;reader.readAsDataURL(blob),reader.onloadend=function(){var imageBase64Data=reader.result;ajaxParams.croppedimagedata=imageBase64Data,ajax.call([{methodname:"theme_snap_cover_image",args:{params:ajaxParams},done:function(response){state1(),!response.success&&response.warning&&addCoverImageAlert("snap-alert-cover-image-upload-failed",response.warning);var newUrl=response.imageurl.replace("url(","").replace(")","").replace(/['"]+/g,"").replace(";","");savedImageURL="url("+newUrl+")",temporalImageURL="none",temporalImageID=0,temporalFileName="",$("#page-header").css("background-image",savedImageURL),$("#page-header").addClass("mast-image"),$("#page-header .breadcrumb-item a").addClass("mast-breadcrumb"),$("#page-header").data("servercoverfile",$("#page-header").css("background-image")),$("#snap-changecoverimageconfirmation .ok").off("click")},fail:function(response){state1(),ajaxNotify.ifErrorShowBestMsg(response)}}],!0,!0)}}))}))},coverImage=function(ajaxParams){let courseShortName=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,categoryId=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,siteMaxBytes=arguments.length>3?arguments[3]:void 0;null===courseShortName&&null===categoryId||ajax.call([{methodname:"theme_snap_file_manager_options",args:[],done:function(data){var fpoptions=JSON.parse(data.fpoptions);$("#page-header").data("servercoverfile",$("#page-header").css("background-image")),$("#snap-coverimagecontrol").addClass("snap-js-enabled"),$("#snap-coverfiles").click((function(){moodledialogue(courseShortName,categoryId,fpoptions,siteMaxBytes)})),$("#snap-changecoverimageconfirmation .cancel").click((function(){moodledialogue(courseShortName,categoryId,fpoptions,siteMaxBytes)}))},fail:function(){}}],!0,!0)};return{courseImage:function(courseShortName,siteMaxBytes){coverImage({imagefilename:null,imagedata:null,categoryid:null,courseshortname:courseShortName},courseShortName,null,siteMaxBytes)},categoryImage:function(categoryId,siteMaxBytes){coverImage({imagefilename:null,imagedata:null,categoryid:categoryId,courseshortname:null},null,categoryId,siteMaxBytes)}}}));

//# sourceMappingURL=cover_image.min.js.map