/**
 * This file is part of Moodle - http://moodle.org/
 *
 * Moodle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Moodle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Moodle. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package
 * @module    theme_snap/accessibility
 * @author    Oscar Nadjar oscar.nadjar@openlms.net
 * @copyright Copyright (c) 2019 Open LMS (https://www.openlms.net)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_snap/accessibility",["jquery","core/str","core/event","core_form/events","theme_boost/bootstrap/tools/sanitizer","theme_boost/popover"],(function($,str,Event,FormEvents,_ref){let{DefaultWhitelist:DefaultWhitelist}=_ref;return{snapAxInit:function(localJouleGrader,allyReport,blockReports,localCatalogue){function Tabpanel(id){this._id=id,this.$tpanel=$("#"+id),this.$tabs=this.$tpanel.find(".tab"),this.$panels=this.$tpanel.find(".tab-pane"),this.bindHandlers(),this.init()}str.get_strings([{key:"accessforumstringdis",component:"theme_snap"},{key:"accessforumstringmov",component:"theme_snap"},{key:"calendar",component:"calendar"},{key:"accessglobalsearchstring",component:"theme_snap"},{key:"viewcalendar",component:"theme_snap"},{key:"viewmyfeedback",component:"theme_snap"},{key:"viewmessaging",component:"theme_snap"},{key:"viewforumposts",component:"theme_snap"},{key:"editcoursesettings",component:"theme_snap"},{key:"gradebook",component:"local_joulegrader"},{key:"gradebook",component:"core_grades"},{key:"numparticipants",component:"core_message"},{key:"pld",component:"theme_snap"},{key:"competencies",component:"core_competency"},{key:"outcomes",component:"core_outcome"},{key:"badges",component:"core_badges"},{key:"coursereport",component:"report_allylti"},{key:"pluginname",component:"local_catalogue"},{key:"experimental",component:"block_reports"}]).done((function(stringsjs){$("#page-mod-forum-discuss")&&($("div[data-content='forum-discussion'] select.custom-select.singleselect").attr("aria-label",stringsjs[0]),$("div[data-content='forum-discussion'] div.movediscussionoption select.custom-select.urlselect").attr("aria-label",stringsjs[1])),$("i.fa-calendar").parent().attr("aria-label",stringsjs[2]),$("input[name='TimeEventSelector[calendar]']").attr("aria-label",stringsjs[2]);var searchbutton=$("#mr-nav .simplesearchform a.btn.btn-open");$(searchbutton).attr({title:stringsjs[3],"aria-label":stringsjs[3]}),$.expr[":"].contains=$.expr.createPseudo((function(arg){return function(elem){return $(elem).text().toUpperCase().indexOf(arg.toUpperCase())>=0}}));var ctparticipantsnumber=stringsjs[11].split(" ");$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[8]+'")').attr("id","ct-course-settings"),$('section#coursetools ul#coursetools-list a:contains("'+ctparticipantsnumber[1]+'")').attr("id","ct-participants-number"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[13]+'")').attr("id","ct-competencies"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[14]+'")').attr("id","ct-outcomes"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[15]+'")').attr("id","ct-badges"),localJouleGrader?($('section#coursetools ul#coursetools-list a:contains("Open Grader")').attr("id","ct-open-grader"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[9]+'")').attr("id","ct-course-gradebook")):$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[10]+'")').attr("id","ct-course-gradebook"),blockReports&&($('section#coursetools ul#coursetools-list a:contains("Open Reports")').attr("id","ct-open-reports"),$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[18]+'")').attr("id","ct-open-reports-experimental")),allyReport&&$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[16]+'")').attr("id","ct-ally"),localCatalogue&&$('section#coursetools ul#coursetools-list a:contains("'+stringsjs[17]+'")').attr("id","ct-open-catalogue"),$('div[role="main"] div.sitetopic ul.section.img-text').attr("role","presentation")})),$(document).ready((function(){$("#page-mod-data-edit input[id*='url']").attr("type","url").attr("autocomplete","url"),$("#moodle-blocks aside#block-region-side-pre a.sr-only.sr-only-focusable").attr("tabindex","-1"),$(".mform").submit((function(){$("input.form-control.is-invalid:first").focus()}));var addtext=$('.groupmanagementtable #buttonscell p.arrow_button input[name="add"]').attr("value"),removetext=$(".groupmanagementtable #buttonscell p.arrow_button input[name='remove']").attr("value");new Tabpanel("snap-pm-accessible-tab"),new Tabpanel("modchooser-accessible-tab"),0==$(".dropdown-item.editing_pld").closest(".pld-dropdown").length&&$(".dropdown-item.editing_pld").wrap("<li class='pld-dropdown'></li>"),$(".dropdown-item.editing_pld").attr("role","button");var $window=$(window);function checkWidth(){var windowsize=$window.width();windowsize<1220?($(".groupmanagementtable #buttonscell p.arrow_button input[name='add']").attr("value","+"),$(".groupmanagementtable #buttonscell p.arrow_button input[name='remove']").attr("value","-")):windowsize>1220&&($(".groupmanagementtable #buttonscell p.arrow_button input[name='add']").attr("value",addtext),$(".groupmanagementtable #buttonscell p.arrow_button input[name='remove']").attr("value",removetext))}checkWidth(),$(window).resize(checkWidth),function(){var carouselindicator=$("#snap-site-carousel .carousel-indicators button");carouselindicator.click((function(e){var element=$(e.target);carouselindicator.attr("aria-current",!1),element.attr("aria-current",!0)}));var targetNode=document.getElementById("snap-carousel-container"),observer=new MutationObserver((()=>{$(".carousel-indicators button").attr("aria-current",!1),$(".carousel-indicators button.active").attr("aria-current",!0)}));targetNode&&observer.observe(targetNode,{attributes:!0,childList:!0,subtree:!0})}(),$("#snap-site-carousel").carousel({interval:6e3,pause:"false"}),$("#play-button").click((function(){$("#snap-site-carousel").carousel("cycle")})),$("#pause-button").click((function(){$("#snap-site-carousel").carousel("pause")})),function(){let blocksDrawerFocus,blocksDrawerAccessed=!1;function getFirstAndLastOfDrawer(drawer){let first=null,last=null;if(drawer){let drawerFocusables=Array.from(drawer.querySelectorAll('[tabindex]:not([tabindex="-1"]), a[href]:not([tabindex]), button:not([disabled]):not([tabindex]), input:not([disabled]):not([tabindex]), textarea:not([disabled]):not([tabindex]), select:not([disabled]):not([tabindex]), details:not([tabindex])')).filter((el=>el.checkVisibility()));first=drawerFocusables[0],last=drawerFocusables[drawerFocusables.length-1]}return[first,last]}document.addEventListener("keydown",(function(ev){let adminDrawerIcon=document.getElementById("admin-menu-trigger"),adminDrawer=adminDrawerIcon?document.querySelector('section.block_settings[data-block="settings"]'):null,blocksDrawerIcon=document.querySelector(".blocks-drawer-button"),blocksDrawer=blocksDrawerIcon?document.getElementById("theme_snap-drawers-blocks"):null,blocksDrawerClose=document.querySelector("#theme_snap-drawers-blocks > .drawerheader > button"),snapfeedsDrawerIcon=document.getElementById("snap_feeds_side_menu_trigger"),snapfeedsDrawer=snapfeedsDrawerIcon?document.querySelector("#snap_feeds_side_menu .snap-feeds"):null,snapfeedsSideMenu=document.getElementById("snap_feeds_side_menu"),messageDrawerIcon=document.querySelector("a[id^='message-drawer-toggle-']"),messageDrawerChild=document.querySelector('div[data-region="message-drawer"]'),messageDrawer=messageDrawerChild?messageDrawerChild.parentElement:null;messageDrawer=messageDrawerIcon?messageDrawer:null;let messageDrawerClose=document.querySelector('[id^="message-drawer-"] > div.closewidget > a'),drawerIcons=[adminDrawerIcon,blocksDrawerIcon,snapfeedsDrawerIcon,messageDrawerIcon].filter((el=>null!==el)),drawers=[adminDrawer,blocksDrawer,snapfeedsDrawer,messageDrawer].filter((el=>null!==el)),beforeDrawers=document.querySelector("#snap-custom-menu-header div > ul > li:nth-child(2) > a");beforeDrawers=beforeDrawers||document.querySelector("#snap-custom-menu-header > nav > div > ul > li > a");let afterDrawers=document.querySelector("#snap-sidebar-menu > button.snap-sidebar-menu-trigger"),adminDrawerFirst=null,adminDrawerLast=null;[adminDrawerFirst,adminDrawerLast]=getFirstAndLastOfDrawer(adminDrawer);let blocksDrawerFirst=null,blocksDrawerLast=null;[blocksDrawerFirst,blocksDrawerLast]=getFirstAndLastOfDrawer(blocksDrawer);let snapfeedsDrawerFirst=null,snapfeedsDrawerLast=null;[snapfeedsDrawerFirst,snapfeedsDrawerLast]=getFirstAndLastOfDrawer(snapfeedsDrawer);let messageDrawerFirst=null,messageDrawerLast=null;[messageDrawerFirst,messageDrawerLast]=getFirstAndLastOfDrawer(messageDrawer);let drawerFirsts=[adminDrawerFirst,blocksDrawerFirst,snapfeedsDrawerFirst,messageDrawerFirst].filter((el=>null!==el)),drawerLasts=[adminDrawerLast,blocksDrawerLast,snapfeedsDrawerLast,messageDrawerLast].filter((el=>null!==el));if("Tab"===ev.key&&drawerIcons.includes(ev.target)){ev.preventDefault();let idx=drawerIcons.indexOf(ev.target);drawers[idx].classList.contains("state-visible")&&adminDrawer&&drawers[idx]===adminDrawer||drawers[idx].classList.contains("show")&&blocksDrawer&&drawers[idx]===blocksDrawer||snapfeedsSideMenu&&snapfeedsSideMenu.classList.contains("state-visible")&&snapfeedsDrawer&&drawers[idx]===snapfeedsDrawer||!drawers[idx].classList.contains("hidden")&&messageDrawer&&drawers[idx]===messageDrawer?ev.shiftKey?drawerLasts[idx].focus():drawerFirsts[idx].focus():ev.shiftKey?0===idx?beforeDrawers.focus():drawerIcons[idx-1].focus():idx<drawers.length-1?drawerIcons[idx+1].focus():afterDrawers.focus()}else if("Tab"===ev.key&&!ev.shiftKey&&drawerLasts.includes(ev.target)){ev.preventDefault(),drawerIcons[drawerLasts.indexOf(ev.target)].focus()}else if("Tab"===ev.key&&ev.shiftKey&&drawerFirsts.includes(ev.target)){ev.preventDefault(),drawerIcons[drawerFirsts.indexOf(ev.target)].focus()}else if("Enter"===ev.key&&(drawerIcons.includes(ev.target)||messageDrawerClose===ev.target)){blocksDrawerAccessed=!1,ev.preventDefault();let idx=drawerIcons.indexOf(ev.target);drawerIcons[idx]===messageDrawerIcon?document.getElementById("page").classList.toggle("offcanvas"):drawerIcons[idx]===blocksDrawerIcon?(drawerIcons[idx].click(),blocksDrawerFocus=function(){blocksDrawerAccessed||(blocksDrawerAccessed=!0,blocksDrawerIcon.focus(),blocksDrawerClose.removeEventListener("focus",blocksDrawerFocus))},blocksDrawerClose.addEventListener("focus",blocksDrawerFocus)):messageDrawerClose!==ev.target?drawerIcons[idx].click():(document.getElementById("page").classList.toggle("offcanvas"),messageDrawerIcon.focus()),idx>=0&&drawerIcons[idx].focus()}}))}()})),Tabpanel.prototype.keys={left:37,up:38,right:39,down:40},Tabpanel.prototype.init=function(){var $tab;this.$panels.attr("aria-hidden","true"),this.$panels.removeClass("active in"),void 0===($tab=this.$tabs.filter(".active"))&&($tab=this.$tabs.first()).addClass("active"),this.$tpanel.find("#"+$tab.find("a").attr("aria-controls")).addClass("active in").attr("aria-hidden","false")},Tabpanel.prototype.switchTabs=function($curTab,$newTab){var $curTabLink=$curTab.find("a"),$newTabLink=$newTab.find("a");$curTab.removeClass("active"),$curTabLink.attr("tabindex","-1").attr("aria-selected","false"),$newTab.addClass("active"),$newTabLink.attr("aria-selected","true"),this.$tpanel.find("#"+$curTabLink.attr("aria-controls")).removeClass("active in").attr("aria-hidden","true"),this.$tpanel.find("#"+$newTabLink.attr("aria-controls")).addClass("active in").attr("aria-hidden","false"),$newTabLink.attr("tabindex","0"),$newTabLink.focus()},Tabpanel.prototype.bindHandlers=function(){var self=this;this.$tabs.keydown((function(e){return self.handleTabKeyDown($(this),e)})),this.$tabs.click((function(e){return self.handleTabClick($(this),e)}))},Tabpanel.prototype.handleTabKeyDown=function($tab,e){var $newTab,tabIndex;switch(e.keyCode){case this.keys.left:case this.keys.up:return $newTab=0===(tabIndex=this.$tabs.index($tab))?this.$tabs.last():this.$tabs.eq(tabIndex-1),this.switchTabs($tab,$newTab),e.preventDefault(),!1;case this.keys.right:case this.keys.down:return $newTab=(tabIndex=this.$tabs.index($tab))===this.$tabs.length-1?this.$tabs.first():this.$tabs.eq(tabIndex+1),this.switchTabs($tab,$newTab),e.preventDefault(),!1}},Tabpanel.prototype.handleTabClick=function($tab){var $oldTab=this.$tpanel.find(".tab.active");this.switchTabs($oldTab,$tab)}},enhanceform:function(elementid){const element=document.getElementById(elementid);element&&element.addEventListener(FormEvents.eventTypes.formFieldValidationFailed,(function(event){var _event$detail;event.preventDefault();const msg=(null===(_event$detail=event.detail)||void 0===_event$detail?void 0:_event$detail.message)||"",parent=element.closest(".form-group");if(!parent)return;const feedback=parent.querySelector(".form-control-feedback"),invalidInput=parent.querySelector("input.form-control.is-invalid");let activeElement=element;if("TEXTAREA"===element.tagName){const contentEditable=parent.querySelector("[contenteditable]");contentEditable&&(activeElement=contentEditable)}""!==msg?(parent.classList.add("has-danger"),parent.dataset.clientValidationError="true",activeElement.classList.add("is-invalid"),feedback&&(activeElement.setAttribute("aria-describedby",feedback.id),activeElement.setAttribute("aria-invalid","true"),invalidInput&&invalidInput.setAttribute("tabindex","0"),feedback.innerHTML=msg,document.querySelector('[data-error-focused="true"]')||(activeElement.setAttribute("data-error-focused","true"),setTimeout((function(){activeElement.focus(),activeElement.scrollIntoView({behavior:"smooth",block:"center"})}),0)))):"true"===parent.dataset.clientValidationError&&(parent.classList.remove("has-danger"),delete parent.dataset.clientValidationError,activeElement.classList.remove("is-invalid"),activeElement.removeAttribute("aria-describedby"),activeElement.setAttribute("aria-invalid","false"),feedback&&(feedback.style.display="none"))}))},setManualPopovers:function(){$("body").popover({selector:'[data-toggle="popover"]',trigger:"manual",container:"body",whitelist:Object.assign(DefaultWhitelist,{table:[],thead:[],tbody:[],tr:[],th:[],td:[]})}),$(".iconhelp.btn").on("focusin",(function(e){e.stopImmediatePropagation()})),$(".iconhelp.btn").on("click",(function(e){e.preventDefault(),e.stopImmediatePropagation();const $el=$(this);"true"===$el.attr("aria-expanded")?$el.popover("hide"):$el.popover("show")})),$(".iconhelp.btn").on("keydown",(function(e){const $el=$(this);if("Enter"===e.key||" "===e.key){e.preventDefault(),e.stopImmediatePropagation();"true"===$el.attr("aria-expanded")?$el.popover("hide"):$el.popover("show")}"Escape"===e.key&&$el.popover("hide")})),$(".iconhelp.btn").on("shown.bs.popover",(function(){const popover=$(this).data("bs.popover").tip;$(this).attr("aria-controls",popover.id),$(this).attr("aria-expanded",!0),$(popover).insertAfter($(this)),$(popover).popover("update")})),$(".iconhelp.btn").on("hidden.bs.popover",(function(){$(this).attr("aria-expanded",!1)}))}}}));

//# sourceMappingURL=accessibility.min.js.map