/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.MoreObjects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.DeadEvent;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Dispatcher;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$LoggingHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberExceptionContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberExceptionHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberRegistry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.MoreExecutors;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this("default");
    }

    public EventBus(String string) {
        this(string, MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), EventBus$LoggingHandler.INSTANCE);
    }

    EventBus(String string, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler subscriberExceptionHandler) {
        this.identifier = (String)Preconditions.checkNotNull(string);
        this.executor = (Executor)Preconditions.checkNotNull(executor);
        this.dispatcher = (Dispatcher)Preconditions.checkNotNull(dispatcher);
        this.exceptionHandler = (SubscriberExceptionHandler)Preconditions.checkNotNull(subscriberExceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable throwable, SubscriberExceptionContext subscriberExceptionContext) {
        Preconditions.checkNotNull(throwable);
        Preconditions.checkNotNull(subscriberExceptionContext);
        try {
            this.exceptionHandler.handleException(throwable, subscriberExceptionContext);
        }
        catch (Throwable throwable2) {
            logger.log(Level.SEVERE, String.format(Locale.ROOT, "Exception %s thrown while handling exception: %s", throwable2, throwable), throwable2);
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void post(Object object) {
        Iterator iterator = this.subscribers.getSubscribers(object);
        if (iterator.hasNext()) {
            this.dispatcher.dispatch(object, iterator);
        } else if (!(object instanceof DeadEvent)) {
            this.post(new DeadEvent(this, object));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.identifier).toString();
    }
}

