/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.BiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$BiEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$Inverse;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap$KeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$IteratorBasedAbstractMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.RetainedWith;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class HashBiMap
extends Maps$IteratorBasedAbstractMap
implements BiMap,
Serializable {
    private transient HashBiMap$BiEntry[] hashTableKToV;
    private transient HashBiMap$BiEntry[] hashTableVToK;
    @NullableDecl
    private transient HashBiMap$BiEntry firstInKeyInsertionOrder;
    @NullableDecl
    private transient HashBiMap$BiEntry lastInKeyInsertionOrder;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    @MonotonicNonNullDecl
    @RetainedWith
    private transient BiMap inverse;

    private void delete(HashBiMap$BiEntry hashBiMap$BiEntry) {
        int n = hashBiMap$BiEntry.keyHash & this.mask;
        HashBiMap$BiEntry hashBiMap$BiEntry2 = null;
        HashBiMap$BiEntry hashBiMap$BiEntry3 = this.hashTableKToV[n];
        while (true) {
            if (hashBiMap$BiEntry3 == hashBiMap$BiEntry) {
                if (hashBiMap$BiEntry2 == null) {
                    this.hashTableKToV[n] = hashBiMap$BiEntry.nextInKToVBucket;
                    break;
                }
                hashBiMap$BiEntry2.nextInKToVBucket = hashBiMap$BiEntry.nextInKToVBucket;
                break;
            }
            hashBiMap$BiEntry2 = hashBiMap$BiEntry3;
            hashBiMap$BiEntry3 = hashBiMap$BiEntry3.nextInKToVBucket;
        }
        int n2 = hashBiMap$BiEntry.valueHash & this.mask;
        hashBiMap$BiEntry2 = null;
        HashBiMap$BiEntry hashBiMap$BiEntry4 = this.hashTableVToK[n2];
        while (true) {
            if (hashBiMap$BiEntry4 == hashBiMap$BiEntry) {
                if (hashBiMap$BiEntry2 == null) {
                    this.hashTableVToK[n2] = hashBiMap$BiEntry.nextInVToKBucket;
                    break;
                }
                hashBiMap$BiEntry2.nextInVToKBucket = hashBiMap$BiEntry.nextInVToKBucket;
                break;
            }
            hashBiMap$BiEntry2 = hashBiMap$BiEntry4;
            hashBiMap$BiEntry4 = hashBiMap$BiEntry4.nextInVToKBucket;
        }
        if (hashBiMap$BiEntry.prevInKeyInsertionOrder == null) {
            this.firstInKeyInsertionOrder = hashBiMap$BiEntry.nextInKeyInsertionOrder;
        } else {
            hashBiMap$BiEntry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = hashBiMap$BiEntry.nextInKeyInsertionOrder;
        }
        if (hashBiMap$BiEntry.nextInKeyInsertionOrder == null) {
            this.lastInKeyInsertionOrder = hashBiMap$BiEntry.prevInKeyInsertionOrder;
        } else {
            hashBiMap$BiEntry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = hashBiMap$BiEntry.prevInKeyInsertionOrder;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(HashBiMap$BiEntry hashBiMap$BiEntry, @NullableDecl HashBiMap$BiEntry hashBiMap$BiEntry2) {
        int n = hashBiMap$BiEntry.keyHash & this.mask;
        hashBiMap$BiEntry.nextInKToVBucket = this.hashTableKToV[n];
        this.hashTableKToV[n] = hashBiMap$BiEntry;
        int n2 = hashBiMap$BiEntry.valueHash & this.mask;
        hashBiMap$BiEntry.nextInVToKBucket = this.hashTableVToK[n2];
        this.hashTableVToK[n2] = hashBiMap$BiEntry;
        if (hashBiMap$BiEntry2 == null) {
            hashBiMap$BiEntry.prevInKeyInsertionOrder = this.lastInKeyInsertionOrder;
            hashBiMap$BiEntry.nextInKeyInsertionOrder = null;
            if (this.lastInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = hashBiMap$BiEntry;
            } else {
                this.lastInKeyInsertionOrder.nextInKeyInsertionOrder = hashBiMap$BiEntry;
            }
            this.lastInKeyInsertionOrder = hashBiMap$BiEntry;
        } else {
            hashBiMap$BiEntry.prevInKeyInsertionOrder = hashBiMap$BiEntry2.prevInKeyInsertionOrder;
            if (hashBiMap$BiEntry.prevInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = hashBiMap$BiEntry;
            } else {
                hashBiMap$BiEntry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = hashBiMap$BiEntry;
            }
            hashBiMap$BiEntry.nextInKeyInsertionOrder = hashBiMap$BiEntry2.nextInKeyInsertionOrder;
            if (hashBiMap$BiEntry.nextInKeyInsertionOrder == null) {
                this.lastInKeyInsertionOrder = hashBiMap$BiEntry;
            } else {
                hashBiMap$BiEntry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = hashBiMap$BiEntry;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    private HashBiMap$BiEntry seekByKey(@NullableDecl Object object, int n) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.hashTableKToV[n & this.mask];
        while (hashBiMap$BiEntry != null) {
            if (n == hashBiMap$BiEntry.keyHash && Objects.equal(object, hashBiMap$BiEntry.key)) {
                return hashBiMap$BiEntry;
            }
            hashBiMap$BiEntry = hashBiMap$BiEntry.nextInKToVBucket;
        }
        return null;
    }

    private HashBiMap$BiEntry seekByValue(@NullableDecl Object object, int n) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.hashTableVToK[n & this.mask];
        while (hashBiMap$BiEntry != null) {
            if (n == hashBiMap$BiEntry.valueHash && Objects.equal(object, hashBiMap$BiEntry.value)) {
                return hashBiMap$BiEntry;
            }
            hashBiMap$BiEntry = hashBiMap$BiEntry.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        return this.seekByKey(object, Hashing.smearedHash(object)) != null;
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        return this.seekByValue(object, Hashing.smearedHash(object)) != null;
    }

    @NullableDecl
    public Object get(@NullableDecl Object object) {
        return Maps.valueOrNull(this.seekByKey(object, Hashing.smearedHash(object)));
    }

    @CanIgnoreReturnValue
    public Object put(@NullableDecl Object object, @NullableDecl Object object2) {
        return this.put(object, object2, false);
    }

    private Object put(@NullableDecl Object object, @NullableDecl Object object2, boolean bl) {
        int n = Hashing.smearedHash(object);
        int n2 = Hashing.smearedHash(object2);
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByKey(object, n);
        if (hashBiMap$BiEntry != null && n2 == hashBiMap$BiEntry.valueHash && Objects.equal(object2, hashBiMap$BiEntry.value)) {
            return object2;
        }
        HashBiMap$BiEntry hashBiMap$BiEntry2 = this.seekByValue(object2, n2);
        if (hashBiMap$BiEntry2 != null) {
            if (bl) {
                this.delete(hashBiMap$BiEntry2);
            } else {
                throw new IllegalArgumentException("value already present: " + object2);
            }
        }
        HashBiMap$BiEntry hashBiMap$BiEntry3 = new HashBiMap$BiEntry(object, n, object2, n2);
        if (hashBiMap$BiEntry != null) {
            this.delete(hashBiMap$BiEntry);
            this.insert(hashBiMap$BiEntry3, hashBiMap$BiEntry);
            hashBiMap$BiEntry.prevInKeyInsertionOrder = null;
            hashBiMap$BiEntry.nextInKeyInsertionOrder = null;
            return hashBiMap$BiEntry.value;
        }
        this.insert(hashBiMap$BiEntry3, null);
        this.rehashIfNecessary();
        return null;
    }

    @NullableDecl
    private Object putInverse(@NullableDecl Object object, @NullableDecl Object object2, boolean bl) {
        int n = Hashing.smearedHash(object);
        int n2 = Hashing.smearedHash(object2);
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByValue(object, n);
        HashBiMap$BiEntry hashBiMap$BiEntry2 = this.seekByKey(object2, n2);
        if (hashBiMap$BiEntry != null && n2 == hashBiMap$BiEntry.keyHash && Objects.equal(object2, hashBiMap$BiEntry.key)) {
            return object2;
        }
        if (hashBiMap$BiEntry2 != null && !bl) {
            throw new IllegalArgumentException("key already present: " + object2);
        }
        if (hashBiMap$BiEntry != null) {
            this.delete(hashBiMap$BiEntry);
        }
        if (hashBiMap$BiEntry2 != null) {
            this.delete(hashBiMap$BiEntry2);
        }
        HashBiMap$BiEntry hashBiMap$BiEntry3 = new HashBiMap$BiEntry(object2, n2, object, n);
        this.insert(hashBiMap$BiEntry3, hashBiMap$BiEntry2);
        if (hashBiMap$BiEntry2 != null) {
            hashBiMap$BiEntry2.prevInKeyInsertionOrder = null;
            hashBiMap$BiEntry2.nextInKeyInsertionOrder = null;
        }
        if (hashBiMap$BiEntry != null) {
            hashBiMap$BiEntry.prevInKeyInsertionOrder = null;
            hashBiMap$BiEntry.nextInKeyInsertionOrder = null;
        }
        this.rehashIfNecessary();
        return Maps.keyOrNull(hashBiMap$BiEntry);
    }

    private void rehashIfNecessary() {
        HashBiMap$BiEntry[] hashBiMap$BiEntryArray = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, hashBiMap$BiEntryArray.length, 1.0)) {
            int n = hashBiMap$BiEntryArray.length * 2;
            this.hashTableKToV = this.createTable(n);
            this.hashTableVToK = this.createTable(n);
            this.mask = n - 1;
            this.size = 0;
            HashBiMap$BiEntry hashBiMap$BiEntry = this.firstInKeyInsertionOrder;
            while (hashBiMap$BiEntry != null) {
                this.insert(hashBiMap$BiEntry, hashBiMap$BiEntry);
                hashBiMap$BiEntry = hashBiMap$BiEntry.nextInKeyInsertionOrder;
            }
            ++this.modCount;
        }
    }

    private HashBiMap$BiEntry[] createTable(int n) {
        return new HashBiMap$BiEntry[n];
    }

    @CanIgnoreReturnValue
    public Object remove(@NullableDecl Object object) {
        HashBiMap$BiEntry hashBiMap$BiEntry = this.seekByKey(object, Hashing.smearedHash(object));
        if (hashBiMap$BiEntry == null) {
            return null;
        }
        this.delete(hashBiMap$BiEntry);
        hashBiMap$BiEntry.prevInKeyInsertionOrder = null;
        hashBiMap$BiEntry.nextInKeyInsertionOrder = null;
        return hashBiMap$BiEntry.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    public Set keySet() {
        return new HashBiMap$KeySet(this);
    }

    @Override
    public Set values() {
        return this.inverse().keySet();
    }

    @Override
    Iterator entryIterator() {
        return new HashBiMap$1(this);
    }

    public void forEach(BiConsumer biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        HashBiMap$BiEntry hashBiMap$BiEntry = this.firstInKeyInsertionOrder;
        while (hashBiMap$BiEntry != null) {
            biConsumer.accept(hashBiMap$BiEntry.key, hashBiMap$BiEntry.value);
            hashBiMap$BiEntry = hashBiMap$BiEntry.nextInKeyInsertionOrder;
        }
    }

    public void replaceAll(BiFunction biFunction) {
        Preconditions.checkNotNull(biFunction);
        HashBiMap$BiEntry hashBiMap$BiEntry = this.firstInKeyInsertionOrder;
        this.clear();
        HashBiMap$BiEntry hashBiMap$BiEntry2 = hashBiMap$BiEntry;
        while (hashBiMap$BiEntry2 != null) {
            this.put(hashBiMap$BiEntry2.key, biFunction.apply(hashBiMap$BiEntry2.key, hashBiMap$BiEntry2.value));
            hashBiMap$BiEntry2 = hashBiMap$BiEntry2.nextInKeyInsertionOrder;
        }
    }

    public BiMap inverse() {
        BiMap biMap = this.inverse;
        return biMap == null ? (this.inverse = new HashBiMap$Inverse(this, null)) : biMap;
    }

    static /* synthetic */ HashBiMap$BiEntry access$000(HashBiMap hashBiMap) {
        return hashBiMap.firstInKeyInsertionOrder;
    }

    static /* synthetic */ int access$100(HashBiMap hashBiMap) {
        return hashBiMap.modCount;
    }

    static /* synthetic */ void access$200(HashBiMap hashBiMap, HashBiMap$BiEntry hashBiMap$BiEntry) {
        hashBiMap.delete(hashBiMap$BiEntry);
    }

    static /* synthetic */ HashBiMap$BiEntry access$300(HashBiMap hashBiMap, Object object, int n) {
        return hashBiMap.seekByKey(object, n);
    }

    static /* synthetic */ HashBiMap$BiEntry access$400(HashBiMap hashBiMap, Object object, int n) {
        return hashBiMap.seekByValue(object, n);
    }

    static /* synthetic */ void access$500(HashBiMap hashBiMap, HashBiMap$BiEntry hashBiMap$BiEntry, HashBiMap$BiEntry hashBiMap$BiEntry2) {
        hashBiMap.insert(hashBiMap$BiEntry, hashBiMap$BiEntry2);
    }

    static /* synthetic */ int access$700(HashBiMap hashBiMap) {
        return hashBiMap.size;
    }

    static /* synthetic */ Object access$800(HashBiMap hashBiMap, Object object, Object object2, boolean bl) {
        return hashBiMap.putInverse(object, object2, bl);
    }
}

