/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.AssertingRandom;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomSupplier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedUtils;
import java.util.Random;

public final class Randomness {
    private final long seed;
    private final Random random;
    private final RandomSupplier supplier;
    private final SeedDecorator[] decorators;

    public Randomness(Thread thread, RandomSupplier randomSupplier, long l, SeedDecorator ... seedDecoratorArray) {
        this.seed = l;
        this.decorators = seedDecoratorArray;
        this.supplier = randomSupplier;
        Random random = randomSupplier.get(Randomness.decorate(l, seedDecoratorArray));
        this.random = AssertingRandom.isVerifying() ? new AssertingRandom(thread, random) : random;
    }

    public Randomness(long l, RandomSupplier randomSupplier, SeedDecorator ... seedDecoratorArray) {
        this(Thread.currentThread(), randomSupplier, l, seedDecoratorArray);
    }

    Randomness clone(Thread thread) {
        return new Randomness(thread, this.supplier, this.seed, this.decorators);
    }

    public String toString() {
        return "[Randomness, seed=" + SeedUtils.formatSeedChain(this) + "]";
    }

    void destroy() {
        if (this.random instanceof AssertingRandom) {
            ((AssertingRandom)this.random).destroy();
        }
    }

    long getSeed() {
        return this.seed;
    }

    private static long decorate(long l, SeedDecorator[] seedDecoratorArray) {
        for (SeedDecorator seedDecorator : seedDecoratorArray) {
            l = seedDecorator.decorate(l);
        }
        return l;
    }
}

