/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;

abstract class NumericMedianFunction<T extends Comparable<T>>
extends DoubleValue.AbstractDoubleValue
implements ReductionFunction {
    protected SortedListCollector<T> collector;
    public static final String name = "median";
    private final String exprStr;

    public NumericMedianFunction(DoubleValueStream param, SortedListCollector<T> collector) {
        this.collector = collector;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    protected abstract double collectOrd(int var1);

    @Override
    public double getDouble() {
        int size = this.collector.size();
        if (size == 0) {
            return 0.0;
        }
        if (size % 2 == 0) {
            return (this.collectOrd(size / 2) + this.collectOrd(size / 2 - 1)) / 2.0;
        }
        return this.collectOrd(size / 2);
    }

    @Override
    public boolean exists() {
        return this.collector.size() > 0;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector)sync.apply(this.collector);
        this.collector.calcMedian();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

