/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.BooleanReplaceFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.DateReplaceFunction;
import org.apache.solr.analytics.function.mapping.DateStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.DoubleReplaceFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.FloatReplaceFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.IntReplaceFunction;
import org.apache.solr.analytics.function.mapping.IntStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.LongReplaceFunction;
import org.apache.solr.analytics.function.mapping.LongStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.StreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.StringReplaceFunction;
import org.apache.solr.analytics.function.mapping.StringStreamReplaceFunction;
import org.apache.solr.analytics.function.mapping.ValueReplaceFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class ReplaceFunction {
    public static final String name = "replace";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 3) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The replace function requires 3 paramaters, " + params.length + " found.");
        }
        if (!(params[1] instanceof AnalyticsValue) || !(params[2] instanceof AnalyticsValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The replace function requires the comparator and fill parameters to be single-valued.");
        }
        AnalyticsValueStream baseExpr = params[0];
        AnalyticsValue compExpr = (AnalyticsValue)params[1];
        AnalyticsValue fillExpr = (AnalyticsValue)params[2];
        if (baseExpr instanceof DateValue && compExpr instanceof DateValue && fillExpr instanceof DateValue) {
            return new DateReplaceFunction((DateValue)baseExpr, (DateValue)compExpr, (DateValue)fillExpr);
        }
        if (baseExpr instanceof DateValueStream && compExpr instanceof DateValue && fillExpr instanceof DateValue) {
            return new DateStreamReplaceFunction((DateValueStream)baseExpr, (DateValue)compExpr, (DateValue)fillExpr);
        }
        if (baseExpr instanceof BooleanValue && compExpr instanceof BooleanValue && fillExpr instanceof BooleanValue) {
            return new BooleanReplaceFunction((BooleanValue)baseExpr, (BooleanValue)compExpr, (BooleanValue)fillExpr);
        }
        if (baseExpr instanceof BooleanValueStream && compExpr instanceof BooleanValue && fillExpr instanceof BooleanValue) {
            return new BooleanStreamReplaceFunction((BooleanValueStream)baseExpr, (BooleanValue)compExpr, (BooleanValue)fillExpr);
        }
        if (baseExpr instanceof IntValue && compExpr instanceof IntValue && fillExpr instanceof IntValue) {
            return new IntReplaceFunction((IntValue)baseExpr, (IntValue)compExpr, (IntValue)fillExpr);
        }
        if (baseExpr instanceof IntValueStream && compExpr instanceof IntValue && fillExpr instanceof IntValue) {
            return new IntStreamReplaceFunction((IntValueStream)baseExpr, (IntValue)compExpr, (IntValue)fillExpr);
        }
        if (baseExpr instanceof LongValue && compExpr instanceof LongValue && fillExpr instanceof LongValue) {
            return new LongReplaceFunction((LongValue)baseExpr, (LongValue)compExpr, (LongValue)fillExpr);
        }
        if (baseExpr instanceof LongValueStream && compExpr instanceof LongValue && fillExpr instanceof LongValue) {
            return new LongStreamReplaceFunction((LongValueStream)baseExpr, (LongValue)compExpr, (LongValue)fillExpr);
        }
        if (baseExpr instanceof FloatValue && compExpr instanceof FloatValue && fillExpr instanceof FloatValue) {
            return new FloatReplaceFunction((FloatValue)baseExpr, (FloatValue)compExpr, (FloatValue)fillExpr);
        }
        if (baseExpr instanceof FloatValueStream && compExpr instanceof FloatValue && fillExpr instanceof FloatValue) {
            return new FloatStreamReplaceFunction((FloatValueStream)baseExpr, (FloatValue)compExpr, (FloatValue)fillExpr);
        }
        if (baseExpr instanceof DoubleValue && compExpr instanceof DoubleValue && fillExpr instanceof DoubleValue) {
            return new DoubleReplaceFunction((DoubleValue)baseExpr, (DoubleValue)compExpr, (DoubleValue)fillExpr);
        }
        if (baseExpr instanceof DoubleValueStream && compExpr instanceof DoubleValue && fillExpr instanceof DoubleValue) {
            return new DoubleStreamReplaceFunction((DoubleValueStream)baseExpr, (DoubleValue)compExpr, (DoubleValue)fillExpr);
        }
        if (baseExpr instanceof StringValue && compExpr instanceof StringValue && fillExpr instanceof StringValue) {
            return new StringReplaceFunction((StringValue)baseExpr, (StringValue)compExpr, (StringValue)fillExpr);
        }
        if (baseExpr instanceof StringValueStream && compExpr instanceof StringValue && fillExpr instanceof StringValue) {
            return new StringStreamReplaceFunction((StringValueStream)baseExpr, (StringValue)compExpr, (StringValue)fillExpr);
        }
        if (baseExpr instanceof AnalyticsValue) {
            return new ValueReplaceFunction((AnalyticsValue)baseExpr, compExpr, fillExpr);
        }
        return new StreamReplaceFunction(baseExpr, compExpr, fillExpr);
    };
}

