/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.HdfsDirectoryFactory;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsBackupRepository
implements BackupRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HDFS_UMASK_MODE_PARAM = "solr.hdfs.permissions.umask-mode";
    private static final String HDFS_COPY_BUFFER_SIZE_PARAM = "solr.hdfs.buffer.size";
    private HdfsDirectoryFactory factory;
    private Configuration hdfsConfig = null;
    private FileSystem fileSystem = null;
    private Path baseHdfsPath = null;
    private NamedList config = null;
    protected int copyBufferSize = 4096;

    @Override
    public void init(NamedList args) {
        this.config = args;
        log.warn("HDFS support in Solr has been deprecated as of 8.6. See SOLR-14021 for details.");
        if (args.get(HDFS_COPY_BUFFER_SIZE_PARAM) != null) {
            this.copyBufferSize = (Integer)args.get(HDFS_COPY_BUFFER_SIZE_PARAM);
            if (this.copyBufferSize <= 0) {
                throw new IllegalArgumentException("Value of solr.hdfs.buffer.size must be > 0");
            }
        }
        String hdfsSolrHome = (String)Objects.requireNonNull(args.get("solr.hdfs.home"), "Please specify solr.hdfs.home property.");
        for (Path path = new Path(hdfsSolrHome); path != null; path = path.getParent()) {
            this.baseHdfsPath = path;
        }
        this.factory = new HdfsDirectoryFactory();
        this.factory.init(args);
        this.hdfsConfig = this.factory.getConf(new Path(hdfsSolrHome));
        if (args.get(HDFS_UMASK_MODE_PARAM) != null) {
            String umaskVal = (String)args.get(HDFS_UMASK_MODE_PARAM);
            this.hdfsConfig.set("fs.permissions.umask-mode", umaskVal);
        }
        try {
            this.fileSystem = FileSystem.get((URI)this.baseHdfsPath.toUri(), (Configuration)this.hdfsConfig);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
        if (this.factory != null) {
            this.factory.close();
        }
    }

    @Override
    public <T> T getConfigProperty(String name) {
        return (T)this.config.get(name);
    }

    @Override
    public URI createURI(String location) {
        Objects.requireNonNull(location);
        URI result = null;
        try {
            result = new URI(location);
            if (!result.isAbsolute()) {
                result = this.resolve(this.baseHdfsPath.toUri(), location);
            }
        }
        catch (URISyntaxException ex) {
            result = this.resolve(this.baseHdfsPath.toUri(), location);
        }
        return result;
    }

    @Override
    public URI resolve(URI baseUri, String ... pathComponents) {
        Preconditions.checkArgument((boolean)baseUri.isAbsolute());
        Path result = new Path(baseUri);
        for (String path : pathComponents) {
            result = new Path(result, path);
        }
        return result.toUri();
    }

    @Override
    public boolean exists(URI path) throws IOException {
        return this.fileSystem.exists(new Path(path));
    }

    @Override
    public BackupRepository.PathType getPathType(URI path) throws IOException {
        return this.fileSystem.isDirectory(new Path(path)) ? BackupRepository.PathType.DIRECTORY : BackupRepository.PathType.FILE;
    }

    @Override
    public String[] listAll(URI path) throws IOException {
        FileStatus[] status = this.fileSystem.listStatus(new Path(path));
        String[] result = new String[status.length];
        for (int i = 0; i < status.length; ++i) {
            result[i] = status[i].getPath().getName();
        }
        return result;
    }

    @Override
    public IndexInput openInput(URI dirPath, String fileName, IOContext ctx) throws IOException {
        Path p = new Path(new Path(dirPath), fileName);
        return new HdfsDirectory.HdfsIndexInput(fileName, this.fileSystem, p, 4096);
    }

    @Override
    public OutputStream createOutput(URI path) throws IOException {
        return this.fileSystem.create(new Path(path));
    }

    @Override
    public void createDirectory(URI path) throws IOException {
        if (!this.fileSystem.mkdirs(new Path(path))) {
            throw new IOException("Unable to create a directory at following location " + path);
        }
    }

    @Override
    public void deleteDirectory(URI path) throws IOException {
        if (!this.fileSystem.delete(new Path(path), true)) {
            throw new IOException("Unable to delete a directory at following location " + path);
        }
    }

    @Override
    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        try (HdfsDirectory dir = new HdfsDirectory(new Path(destDir), (LockFactory)NoLockFactory.INSTANCE, this.hdfsConfig, this.copyBufferSize);){
            this.copyIndexFileFrom(sourceDir, sourceFileName, (Directory)dir, destFileName);
        }
    }

    @Override
    public void copyIndexFileTo(URI sourceRepo, String sourceFileName, Directory dest, String destFileName) throws IOException {
        try (HdfsDirectory dir = new HdfsDirectory(new Path(sourceRepo), (LockFactory)NoLockFactory.INSTANCE, this.hdfsConfig, this.copyBufferSize);){
            dest.copyFrom((Directory)dir, sourceFileName, destFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    @Override
    public void delete(URI path, Collection<String> files, boolean ignoreNoSuchFileException) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        for (String file : files) {
            Path filePath = new Path(new Path(path), file);
            boolean success = this.fileSystem.delete(filePath, false);
            if (ignoreNoSuchFileException || success) continue;
            throw new NoSuchFileException(filePath.toString());
        }
    }
}

