/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.distance;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.AbstractDistanceCalculator;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;

public abstract class GeodesicSphereDistCalc
extends AbstractDistanceCalculator {
    private static final double radiusDEG = DistanceUtils.toDegrees(1.0);

    @Override
    public Point pointOnBearing(Point from, double distDEG, double bearingDEG, SpatialContext ctx, Point reuse) {
        if (distDEG == 0.0) {
            if (reuse == null) {
                return from;
            }
            reuse.reset(from.getX(), from.getY());
            return reuse;
        }
        Point result = DistanceUtils.pointOnBearingRAD(DistanceUtils.toRadians(from.getY()), DistanceUtils.toRadians(from.getX()), DistanceUtils.toRadians(distDEG), DistanceUtils.toRadians(bearingDEG), ctx, reuse);
        result.reset(DistanceUtils.toDegrees(result.getX()), DistanceUtils.toDegrees(result.getY()));
        return result;
    }

    @Override
    public Rectangle calcBoxByDistFromPt(Point from, double distDEG, SpatialContext ctx, Rectangle reuse) {
        return DistanceUtils.calcBoxByDistFromPtDEG(from.getY(), from.getX(), distDEG, ctx, reuse);
    }

    @Override
    public double calcBoxByDistFromPt_yHorizAxisDEG(Point from, double distDEG, SpatialContext ctx) {
        return DistanceUtils.calcBoxByDistFromPt_latHorizAxisDEG(from.getY(), from.getX(), distDEG);
    }

    @Override
    public double area(Rectangle rect) {
        double lat1 = DistanceUtils.toRadians(rect.getMinY());
        double lat2 = DistanceUtils.toRadians(rect.getMaxY());
        return Math.PI / 180 * radiusDEG * radiusDEG * Math.abs(Math.sin(lat1) - Math.sin(lat2)) * rect.getWidth();
    }

    @Override
    public double area(Circle circle) {
        double lat = DistanceUtils.toRadians(90.0 - circle.getRadius());
        return Math.PI * 2 * radiusDEG * radiusDEG * (1.0 - Math.sin(lat));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public final double distance(Point from, double toX, double toY) {
        return DistanceUtils.toDegrees(this.distanceLatLonRAD(DistanceUtils.toRadians(from.getY()), DistanceUtils.toRadians(from.getX()), DistanceUtils.toRadians(toY), DistanceUtils.toRadians(toX)));
    }

    protected abstract double distanceLatLonRAD(double var1, double var3, double var5, double var7);

    public static class Vincenty
    extends GeodesicSphereDistCalc {
        @Override
        protected double distanceLatLonRAD(double lat1, double lon1, double lat2, double lon2) {
            return DistanceUtils.distVincentyRAD(lat1, lon1, lat2, lon2);
        }
    }

    public static class LawOfCosines
    extends GeodesicSphereDistCalc {
        @Override
        protected double distanceLatLonRAD(double lat1, double lon1, double lat2, double lon2) {
            return DistanceUtils.distLawOfCosinesRAD(lat1, lon1, lat2, lon2);
        }
    }

    public static class Haversine
    extends GeodesicSphereDistCalc {
        @Override
        protected double distanceLatLonRAD(double lat1, double lon1, double lat2, double lon2) {
            return DistanceUtils.distHaversineRAD(lat1, lon1, lat2, lon2);
        }
    }
}

