/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.idversion.IDVersionPostingsWriter;
import org.apache.lucene.codecs.idversion.IDVersionTermState;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public final class VersionBlockTreeTermsWriter
extends FieldsConsumer {
    static final PairOutputs<BytesRef, Long> FST_OUTPUTS = new PairOutputs((Outputs)ByteSequenceOutputs.getSingleton(), (Outputs)PositiveIntOutputs.getSingleton());
    static final PairOutputs.Pair<BytesRef, Long> NO_OUTPUT = FST_OUTPUTS.getNoOutput();
    public static final int DEFAULT_MIN_BLOCK_SIZE = 25;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 48;
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tiv";
    static final String TERMS_CODEC_NAME = "VersionBlockTreeTermsDict";
    public static final int VERSION_START = 1;
    public static final int VERSION_CURRENT = 1;
    static final String TERMS_INDEX_EXTENSION = "tipv";
    static final String TERMS_INDEX_CODEC_NAME = "VersionBlockTreeTermsIndex";
    private final IndexOutput out;
    private final IndexOutput indexOut;
    final int maxDoc;
    final int minItemsInBlock;
    final int maxItemsInBlock;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    private final List<FieldMetaData> fields;
    private final String segment;
    private final RAMOutputStream scratchBytes;
    private final IntsRefBuilder scratchIntsRef;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VersionBlockTreeTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock) throws IOException {
        IndexOutput indexOut;
        block3: {
            this.fields = new ArrayList<FieldMetaData>();
            this.scratchBytes = new RAMOutputStream();
            this.scratchIntsRef = new IntsRefBuilder();
            BlockTreeTermsWriter.validateSettings((int)minItemsInBlock, (int)maxItemsInBlock);
            this.segment = state.segmentInfo.name;
            this.maxDoc = state.segmentInfo.maxDoc();
            String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
            this.out = state.directory.createOutput(termsFileName, state.context);
            boolean success = false;
            indexOut = null;
            try {
                this.fieldInfos = state.fieldInfos;
                this.minItemsInBlock = minItemsInBlock;
                this.maxItemsInBlock = maxItemsInBlock;
                CodecUtil.writeIndexHeader((DataOutput)this.out, (String)TERMS_CODEC_NAME, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                String termsIndexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
                indexOut = state.directory.createOutput(termsIndexFileName, state.context);
                CodecUtil.writeIndexHeader((DataOutput)indexOut, (String)TERMS_INDEX_CODEC_NAME, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                this.postingsWriter = postingsWriter;
                postingsWriter.init(this.out, state);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, indexOut});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, indexOut});
        }
        this.indexOut = indexOut;
    }

    private void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    private void writeIndexTrailer(IndexOutput indexOut, long dirStart) throws IOException {
        indexOut.writeLong(dirStart);
    }

    public void write(Fields fields, NormsProducer norms) throws IOException {
        String lastField = null;
        for (String field : fields) {
            BytesRef term;
            assert (lastField == null || lastField.compareTo(field) < 0);
            lastField = field;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(this.fieldInfos.fieldInfo(field));
            while ((term = termsEnum.next()) != null) {
                termsWriter.write(term, termsEnum, norms);
            }
            termsWriter.finish();
        }
    }

    static long encodeOutput(long fp, boolean hasTerms, boolean isFloor) {
        assert (fp < 0x4000000000000000L);
        return fp << 2 | (long)(hasTerms ? 2 : 0) | (long)(isFloor ? 1 : 0);
    }

    static String brToString(BytesRef b) {
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    static String brToString(byte[] b) {
        return VersionBlockTreeTermsWriter.brToString(new BytesRef(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block8: {
            block7: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                boolean success = false;
                try {
                    long dirStart = this.out.getFilePointer();
                    long indexDirStart = this.indexOut.getFilePointer();
                    this.out.writeVInt(this.fields.size());
                    for (FieldMetaData field : this.fields) {
                        this.out.writeVInt(field.fieldInfo.number);
                        assert (field.numTerms > 0L);
                        this.out.writeVLong(field.numTerms);
                        this.out.writeVInt(((BytesRef)field.rootCode.output1).length);
                        this.out.writeBytes(((BytesRef)field.rootCode.output1).bytes, ((BytesRef)field.rootCode.output1).offset, ((BytesRef)field.rootCode.output1).length);
                        this.out.writeVLong(((Long)field.rootCode.output2).longValue());
                        this.indexOut.writeVLong(field.indexStartFP);
                        VersionBlockTreeTermsWriter.writeBytesRef(this.out, field.minTerm);
                        VersionBlockTreeTermsWriter.writeBytesRef(this.out, field.maxTerm);
                    }
                    this.writeTrailer(this.out, dirStart);
                    CodecUtil.writeFooter((IndexOutput)this.out);
                    this.writeIndexTrailer(this.indexOut, indexDirStart);
                    CodecUtil.writeFooter((IndexOutput)this.indexOut);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.indexOut, this.postingsWriter});
        }
    }

    private static void writeBytesRef(IndexOutput out, BytesRef bytes) throws IOException {
        out.writeVInt(bytes.length);
        out.writeBytes(bytes.bytes, bytes.offset, bytes.length);
    }

    class TermsWriter {
        private final FieldInfo fieldInfo;
        private long numTerms;
        final FixedBitSet docsSeen;
        long indexStartFP;
        private final BytesRefBuilder lastTerm = new BytesRefBuilder();
        private int[] prefixStarts = new int[8];
        private final List<PendingEntry> pending = new ArrayList<PendingEntry>();
        private final List<PendingBlock> newBlocks = new ArrayList<PendingBlock>();
        private PendingTerm firstPendingTerm;
        private PendingTerm lastPendingTerm;
        private final RAMOutputStream suffixWriter = new RAMOutputStream();
        private final RAMOutputStream metaWriter = new RAMOutputStream();

        void writeBlocks(int prefixLength, int count) throws IOException {
            assert (count > 0);
            assert (prefixLength > 0 || count == this.pending.size());
            int lastSuffixLeadLabel = -1;
            boolean hasTerms = false;
            boolean hasSubBlocks = false;
            int start = this.pending.size() - count;
            int end = this.pending.size();
            int nextBlockStart = start;
            int nextFloorLeadLabel = -1;
            for (int i = start; i < end; ++i) {
                int suffixLeadLabel;
                PendingEntry ent = this.pending.get(i);
                if (ent.isTerm) {
                    PendingTerm term = (PendingTerm)ent;
                    if (term.termBytes.length == prefixLength) {
                        assert (lastSuffixLeadLabel == -1);
                        suffixLeadLabel = -1;
                    } else {
                        suffixLeadLabel = term.termBytes[prefixLength] & 0xFF;
                    }
                } else {
                    PendingBlock block = (PendingBlock)ent;
                    assert (block.prefix.length > prefixLength);
                    suffixLeadLabel = block.prefix.bytes[block.prefix.offset + prefixLength] & 0xFF;
                }
                if (suffixLeadLabel != lastSuffixLeadLabel) {
                    int itemsInBlock = i - nextBlockStart;
                    if (itemsInBlock >= VersionBlockTreeTermsWriter.this.minItemsInBlock && end - nextBlockStart > VersionBlockTreeTermsWriter.this.maxItemsInBlock) {
                        boolean isFloor = itemsInBlock < count;
                        this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, i, hasTerms, hasSubBlocks));
                        hasTerms = false;
                        hasSubBlocks = false;
                        nextFloorLeadLabel = suffixLeadLabel;
                        nextBlockStart = i;
                    }
                    lastSuffixLeadLabel = suffixLeadLabel;
                }
                if (ent.isTerm) {
                    hasTerms = true;
                    continue;
                }
                hasSubBlocks = true;
            }
            if (nextBlockStart < end) {
                int itemsInBlock = end - nextBlockStart;
                boolean isFloor = itemsInBlock < count;
                this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, end, hasTerms, hasSubBlocks));
            }
            assert (!this.newBlocks.isEmpty());
            PendingBlock firstBlock = this.newBlocks.get(0);
            assert (firstBlock.isFloor || this.newBlocks.size() == 1);
            firstBlock.compileIndex(this.newBlocks, VersionBlockTreeTermsWriter.this.scratchBytes, VersionBlockTreeTermsWriter.this.scratchIntsRef);
            this.pending.subList(this.pending.size() - count, this.pending.size()).clear();
            this.pending.add(firstBlock);
            this.newBlocks.clear();
        }

        private PendingBlock writeBlock(int prefixLength, boolean isFloor, int floorLeadLabel, int start, int end, boolean hasTerms, boolean hasSubBlocks) throws IOException {
            ArrayList<FST<PairOutputs.Pair<BytesRef, Long>>> subIndices;
            assert (end > start);
            long startFP = VersionBlockTreeTermsWriter.this.out.getFilePointer();
            boolean hasFloorLeadLabel = isFloor && floorLeadLabel != -1;
            BytesRef prefix = new BytesRef(prefixLength + (hasFloorLeadLabel ? 1 : 0));
            System.arraycopy(this.lastTerm.bytes(), 0, prefix.bytes, 0, prefixLength);
            prefix.length = prefixLength;
            int numEntries = end - start;
            int code = numEntries << 1;
            if (end == this.pending.size()) {
                code |= 1;
            }
            VersionBlockTreeTermsWriter.this.out.writeVInt(code);
            boolean isLeafBlock = !hasSubBlocks;
            boolean absolute = true;
            long maxVersionInBlock = -1L;
            if (isLeafBlock) {
                subIndices = null;
                for (int i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    assert (ent.isTerm) : "i=" + i;
                    PendingTerm term = (PendingTerm)ent;
                    assert (StringHelper.startsWith((byte[])term.termBytes, (BytesRef)prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                    BlockTermState state = term.state;
                    maxVersionInBlock = Math.max(maxVersionInBlock, ((IDVersionTermState)state).idVersion);
                    int suffix = term.termBytes.length - prefixLength;
                    this.suffixWriter.writeVInt(suffix);
                    this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                    VersionBlockTreeTermsWriter.this.postingsWriter.encodeTerm((DataOutput)this.metaWriter, this.fieldInfo, state, absolute);
                    absolute = false;
                }
            } else {
                subIndices = new ArrayList<FST<PairOutputs.Pair<BytesRef, Long>>>();
                for (int i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    if (ent.isTerm) {
                        PendingTerm term = (PendingTerm)ent;
                        assert (StringHelper.startsWith((byte[])term.termBytes, (BytesRef)prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                        BlockTermState state = term.state;
                        maxVersionInBlock = Math.max(maxVersionInBlock, ((IDVersionTermState)state).idVersion);
                        int suffix = term.termBytes.length - prefixLength;
                        this.suffixWriter.writeVInt(suffix << 1);
                        this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                        assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                        VersionBlockTreeTermsWriter.this.postingsWriter.encodeTerm((DataOutput)this.metaWriter, this.fieldInfo, state, absolute);
                        absolute = false;
                        continue;
                    }
                    PendingBlock block = (PendingBlock)ent;
                    maxVersionInBlock = Math.max(maxVersionInBlock, block.maxVersion);
                    assert (StringHelper.startsWith((BytesRef)block.prefix, (BytesRef)prefix));
                    int suffix = block.prefix.length - prefixLength;
                    assert (suffix > 0);
                    this.suffixWriter.writeVInt(suffix << 1 | 1);
                    this.suffixWriter.writeBytes(block.prefix.bytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (block.prefix.bytes[prefixLength] & 0xFF) >= floorLeadLabel);
                    assert (block.fp < startFP);
                    this.suffixWriter.writeVLong(startFP - block.fp);
                    subIndices.add(block.index);
                }
                assert (subIndices.size() != 0);
            }
            VersionBlockTreeTermsWriter.this.out.writeVInt((int)(this.suffixWriter.getFilePointer() << 1) | (isLeafBlock ? 1 : 0));
            this.suffixWriter.writeTo((DataOutput)VersionBlockTreeTermsWriter.this.out);
            this.suffixWriter.reset();
            VersionBlockTreeTermsWriter.this.out.writeVInt((int)this.metaWriter.getFilePointer());
            this.metaWriter.writeTo((DataOutput)VersionBlockTreeTermsWriter.this.out);
            this.metaWriter.reset();
            if (hasFloorLeadLabel) {
                prefix.bytes[prefix.length++] = (byte)floorLeadLabel;
            }
            return new PendingBlock(prefix, maxVersionInBlock, startFP, hasTerms, isFloor, floorLeadLabel, subIndices);
        }

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.docsSeen = new FixedBitSet(VersionBlockTreeTermsWriter.this.maxDoc);
            VersionBlockTreeTermsWriter.this.postingsWriter.setField(fieldInfo);
        }

        public void write(BytesRef text, TermsEnum termsEnum, NormsProducer norms) throws IOException {
            BlockTermState state = VersionBlockTreeTermsWriter.this.postingsWriter.writeTerm(text, termsEnum, this.docsSeen, norms);
            if (state != null && ((IDVersionPostingsWriter)VersionBlockTreeTermsWriter.this.postingsWriter).lastDocID != -1) {
                assert (state.docFreq != 0);
                assert (this.fieldInfo.getIndexOptions() == IndexOptions.DOCS || state.totalTermFreq >= (long)state.docFreq) : "postingsWriter=" + VersionBlockTreeTermsWriter.this.postingsWriter;
                this.pushTerm(text);
                PendingTerm term = new PendingTerm(BytesRef.deepCopyOf((BytesRef)text), state);
                this.pending.add(term);
                ++this.numTerms;
                if (this.firstPendingTerm == null) {
                    this.firstPendingTerm = term;
                }
                this.lastPendingTerm = term;
            }
        }

        private void pushTerm(BytesRef text) throws IOException {
            int i;
            int pos;
            int limit = Math.min(this.lastTerm.length(), text.length);
            for (pos = 0; pos < limit && this.lastTerm.byteAt(pos) == text.bytes[text.offset + pos]; ++pos) {
            }
            for (i = this.lastTerm.length() - 1; i >= pos; --i) {
                int prefixTopSize = this.pending.size() - this.prefixStarts[i];
                if (prefixTopSize < VersionBlockTreeTermsWriter.this.minItemsInBlock) continue;
                this.writeBlocks(i + 1, prefixTopSize);
                int n = i;
                this.prefixStarts[n] = this.prefixStarts[n] - (prefixTopSize - 1);
            }
            if (this.prefixStarts.length < text.length) {
                this.prefixStarts = ArrayUtil.grow((int[])this.prefixStarts, (int)text.length);
            }
            for (i = pos; i < text.length; ++i) {
                this.prefixStarts[i] = this.pending.size();
            }
            this.lastTerm.copyBytes(text);
        }

        public void finish() throws IOException {
            if (this.numTerms > 0L) {
                this.writeBlocks(0, this.pending.size());
                assert (this.pending.size() == 1 && !this.pending.get((int)0).isTerm) : "pending.size()=" + this.pending.size() + " pending=" + this.pending;
                PendingBlock root = (PendingBlock)this.pending.get(0);
                assert (root.prefix.length == 0);
                assert (root.index.getEmptyOutput() != null);
                this.indexStartFP = VersionBlockTreeTermsWriter.this.indexOut.getFilePointer();
                root.index.save((DataOutput)VersionBlockTreeTermsWriter.this.indexOut, (DataOutput)VersionBlockTreeTermsWriter.this.indexOut);
                assert (this.firstPendingTerm != null);
                BytesRef minTerm = new BytesRef(this.firstPendingTerm.termBytes);
                assert (this.lastPendingTerm != null);
                BytesRef maxTerm = new BytesRef(this.lastPendingTerm.termBytes);
                VersionBlockTreeTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, (PairOutputs.Pair<BytesRef, Long>)((PairOutputs.Pair)((PendingBlock)this.pending.get((int)0)).index.getEmptyOutput()), this.numTerms, this.indexStartFP, minTerm, maxTerm));
            }
        }
    }

    private static final class PendingBlock
    extends PendingEntry {
        public final BytesRef prefix;
        public final long fp;
        public FST<PairOutputs.Pair<BytesRef, Long>> index;
        public List<FST<PairOutputs.Pair<BytesRef, Long>>> subIndices;
        public final boolean hasTerms;
        public final boolean isFloor;
        public final int floorLeadByte;
        private final long maxVersion;

        public PendingBlock(BytesRef prefix, long maxVersion, long fp, boolean hasTerms, boolean isFloor, int floorLeadByte, List<FST<PairOutputs.Pair<BytesRef, Long>>> subIndices) {
            super(false);
            this.prefix = prefix;
            this.maxVersion = maxVersion;
            this.fp = fp;
            this.hasTerms = hasTerms;
            this.isFloor = isFloor;
            this.floorLeadByte = floorLeadByte;
            this.subIndices = subIndices;
        }

        public String toString() {
            return "BLOCK: " + VersionBlockTreeTermsWriter.brToString(this.prefix);
        }

        public void compileIndex(List<PendingBlock> blocks, RAMOutputStream scratchBytes, IntsRefBuilder scratchIntsRef) throws IOException {
            assert (this.isFloor && blocks.size() > 1 || !this.isFloor && blocks.size() == 1) : "isFloor=" + this.isFloor + " blocks=" + blocks;
            assert (this == blocks.get(0));
            assert (scratchBytes.getFilePointer() == 0L);
            long maxVersionIndex = this.maxVersion;
            scratchBytes.writeVLong(VersionBlockTreeTermsWriter.encodeOutput(this.fp, this.hasTerms, this.isFloor));
            if (this.isFloor) {
                scratchBytes.writeVInt(blocks.size() - 1);
                for (int i = 1; i < blocks.size(); ++i) {
                    PendingBlock sub = blocks.get(i);
                    maxVersionIndex = Math.max(maxVersionIndex, sub.maxVersion);
                    scratchBytes.writeByte((byte)sub.floorLeadByte);
                    assert (sub.fp > this.fp);
                    scratchBytes.writeVLong(sub.fp - this.fp << 1 | (long)(sub.hasTerms ? 1 : 0));
                }
            }
            Builder indexBuilder = new Builder(FST.INPUT_TYPE.BYTE1, 0, 0, true, false, Integer.MAX_VALUE, FST_OUTPUTS, true, 15);
            byte[] bytes = new byte[(int)scratchBytes.getFilePointer()];
            assert (bytes.length > 0);
            scratchBytes.writeTo(bytes, 0);
            indexBuilder.add(Util.toIntsRef((BytesRef)this.prefix, (IntsRefBuilder)scratchIntsRef), (Object)FST_OUTPUTS.newPair((Object)new BytesRef(bytes, 0, bytes.length), (Object)(Long.MAX_VALUE - maxVersionIndex)));
            scratchBytes.reset();
            for (PendingBlock block : blocks) {
                if (block.subIndices == null) continue;
                for (FST<PairOutputs.Pair<BytesRef, Long>> subIndex : block.subIndices) {
                    this.append((Builder<PairOutputs.Pair<BytesRef, Long>>)indexBuilder, subIndex, scratchIntsRef);
                }
                block.subIndices = null;
            }
            this.index = indexBuilder.finish();
            assert (this.subIndices == null);
        }

        private void append(Builder<PairOutputs.Pair<BytesRef, Long>> builder, FST<PairOutputs.Pair<BytesRef, Long>> subIndex, IntsRefBuilder scratchIntsRef) throws IOException {
            BytesRefFSTEnum.InputOutput indexEnt;
            BytesRefFSTEnum subIndexEnum = new BytesRefFSTEnum(subIndex);
            while ((indexEnt = subIndexEnum.next()) != null) {
                builder.add(Util.toIntsRef((BytesRef)indexEnt.input, (IntsRefBuilder)scratchIntsRef), indexEnt.output);
            }
        }
    }

    private static final class PendingTerm
    extends PendingEntry {
        public final byte[] termBytes;
        public final BlockTermState state;

        public PendingTerm(BytesRef term, BlockTermState state) {
            super(true);
            this.termBytes = new byte[term.length];
            System.arraycopy(term.bytes, term.offset, this.termBytes, 0, term.length);
            this.state = state;
        }

        public String toString() {
            return VersionBlockTreeTermsWriter.brToString(this.termBytes);
        }
    }

    private static class PendingEntry {
        public final boolean isTerm;

        protected PendingEntry(boolean isTerm) {
            this.isTerm = isTerm;
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final PairOutputs.Pair<BytesRef, Long> rootCode;
        public final long numTerms;
        public final long indexStartFP;
        public final BytesRef minTerm;
        public final BytesRef maxTerm;

        public FieldMetaData(FieldInfo fieldInfo, PairOutputs.Pair<BytesRef, Long> rootCode, long numTerms, long indexStartFP, BytesRef minTerm, BytesRef maxTerm) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            assert (rootCode != null) : "field=" + fieldInfo.name + " numTerms=" + numTerms;
            this.rootCode = rootCode;
            this.indexStartFP = indexStartFP;
            this.numTerms = numTerms;
            this.minTerm = minTerm;
            this.maxTerm = maxTerm;
        }
    }
}

