/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.metadata;

import com.drew.imaging.quicktime.QuickTimeHandler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeContext;
import com.drew.metadata.mov.QuickTimeMetadataHandler;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.metadata.QuickTimeMetadataDirectory;
import java.io.IOException;

public class QuickTimeDirectoryHandler
extends QuickTimeMetadataHandler {
    private String currentData;

    public QuickTimeDirectoryHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    protected boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals("data");
    }

    @Override
    protected boolean shouldAcceptContainer(@NotNull Atom atom) {
        return QuickTimeMetadataDirectory._tagIntegerMap.containsKey(atom.type) || atom.type.equals("ilst");
    }

    @Override
    protected QuickTimeHandler processAtom(@NotNull Atom atom, @Nullable byte[] payload, QuickTimeContext context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals("data") && this.currentData != null) {
                this.processData(payload, reader);
            } else {
                this.currentData = new String(reader.getBytes(4));
            }
        } else {
            this.currentData = QuickTimeMetadataDirectory._tagIntegerMap.containsKey(atom.type) ? atom.type : null;
        }
        return this;
    }

    @Override
    protected void processData(@NotNull byte[] payload, @NotNull SequentialByteArrayReader reader) throws IOException {
        reader.skip(8L);
        String value = new String(reader.getBytes(payload.length - 8));
        this.directory.setString(QuickTimeMetadataDirectory._tagIntegerMap.get(this.currentData), value);
    }

    @Override
    protected void processKeys(@NotNull SequentialByteArrayReader reader) throws IOException {
    }
}

