/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Handler;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.runtime.ArrayEnumeratorCursor;
import org.apache.calcite.runtime.ObjectEnumeratorCursor;

public class CalciteResultSet
extends AvaticaResultSet {
    CalciteResultSet(AvaticaStatement statement, CalcitePrepare.CalciteSignature calciteSignature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, null, (Meta.Signature)calciteSignature, resultSetMetaData, timeZone, firstFrame);
    }

    protected CalciteResultSet execute() throws SQLException {
        CalciteConnectionImpl connection = this.getCalciteConnection();
        boolean autoTemp = connection.config().autoTemp();
        Handler.ResultSink resultSink = null;
        if (autoTemp) {
            resultSink = () -> {};
        }
        connection.getDriver().handler.onStatementExecute(this.statement, resultSink);
        super.execute();
        return this;
    }

    public ResultSet create(ColumnMetaData.AvaticaType elementType, Iterable<Object> iterable) throws SQLException {
        List columnMetaDataList = elementType instanceof ColumnMetaData.StructType ? ((ColumnMetaData.StructType)elementType).columns : ImmutableList.of((Object)ColumnMetaData.dummy((ColumnMetaData.AvaticaType)elementType, (boolean)false));
        CalcitePrepare.CalciteSignature signature = (CalcitePrepare.CalciteSignature)this.signature;
        CalcitePrepare.CalciteSignature newSignature = new CalcitePrepare.CalciteSignature(signature.sql, signature.parameters, signature.internalParameters, signature.rowType, columnMetaDataList, Meta.CursorFactory.ARRAY, signature.rootSchema, (List<RelCollation>)ImmutableList.of(), -1L, null, this.statement.getStatementType());
        AvaticaResultSetMetaData subResultSetMetaData = new AvaticaResultSetMetaData(this.statement, null, newSignature);
        CalciteResultSet resultSet = new CalciteResultSet(this.statement, signature, (ResultSetMetaData)subResultSetMetaData, this.localCalendar.getTimeZone(), new Meta.Frame(0L, true, iterable));
        Cursor cursor = resultSet.createCursor(elementType, iterable);
        return resultSet.execute2(cursor, columnMetaDataList);
    }

    private Cursor createCursor(ColumnMetaData.AvaticaType elementType, Iterable iterable) {
        Enumerator enumerator = Linq4j.iterableEnumerator((Iterable)iterable);
        return !(elementType instanceof ColumnMetaData.StructType) || ((ColumnMetaData.StructType)elementType).columns.size() == 1 ? new ObjectEnumeratorCursor((Enumerator<Object>)enumerator) : new ArrayEnumeratorCursor((Enumerator<Object[]>)enumerator);
    }

    <T> CalcitePrepare.CalciteSignature<T> getSignature() {
        return (CalcitePrepare.CalciteSignature)this.signature;
    }

    CalciteConnectionImpl getCalciteConnection() throws SQLException {
        return (CalciteConnectionImpl)this.statement.getConnection();
    }
}

