/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.update.processor.MD5Signature;

public class TextProfileSignature
extends MD5Signature {
    private float quantRate;
    private float minTokenLen;

    @Override
    public void init(SolrParams params) {
        this.quantRate = params.getFloat("quantRate", 0.01f);
        this.minTokenLen = params.getInt("minTokenLen", 2);
    }

    @Override
    public byte[] getSignature() {
        return super.getSignature();
    }

    @Override
    public void add(String content) {
        HashMap<String, Token> tokens = new HashMap<String, Token>();
        StringBuilder curToken = new StringBuilder();
        int maxFreq = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                curToken.append(Character.toLowerCase(c));
                continue;
            }
            if (curToken.length() <= 0) continue;
            if ((float)curToken.length() > this.minTokenLen) {
                String s = curToken.toString();
                Token tok = (Token)tokens.get(s);
                if (tok == null) {
                    tok = new Token(0, s);
                    tokens.put(s, tok);
                }
                ++tok.cnt;
                if (tok.cnt > maxFreq) {
                    maxFreq = tok.cnt;
                }
            }
            curToken.setLength(0);
        }
        if ((float)curToken.length() > this.minTokenLen) {
            String s = curToken.toString();
            Token tok = (Token)tokens.get(s);
            if (tok == null) {
                tok = new Token(0, s);
                tokens.put(s, tok);
            }
            ++tok.cnt;
            if (tok.cnt > maxFreq) {
                maxFreq = tok.cnt;
            }
        }
        Iterator<Object> it = tokens.values().iterator();
        ArrayList<Token> profile = new ArrayList<Token>();
        int quant = Math.round((float)maxFreq * this.quantRate);
        if (quant < 2) {
            quant = maxFreq > 1 ? 2 : 1;
        }
        while (it.hasNext()) {
            Token t = (Token)it.next();
            t.cnt = t.cnt / quant * quant;
            if (t.cnt < quant) continue;
            profile.add(t);
        }
        Collections.sort(profile, new TokenComparator());
        StringBuilder newText = new StringBuilder();
        for (Token t : profile) {
            if (newText.length() > 0) {
                newText.append("\n");
            }
            newText.append(t.toString());
        }
        super.add(newText.toString());
    }

    private static class TokenComparator
    implements Comparator<Token> {
        private TokenComparator() {
        }

        @Override
        public int compare(Token t1, Token t2) {
            return t2.cnt - t1.cnt;
        }
    }

    private static class Token {
        public int cnt;
        public String val;

        public Token(int cnt, String val) {
            this.cnt = cnt;
            this.val = val;
        }

        public String toString() {
            return this.val + " " + this.cnt;
        }
    }
}

