/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.DistributedQueueFactory;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.autoscaling.AutoScalingHandler;
import org.apache.solr.cloud.autoscaling.OverseerTriggerThread;
import org.apache.solr.cloud.autoscaling.sim.GenericDistributedQueueFactory;
import org.apache.solr.cloud.autoscaling.sim.LiveNodesSet;
import org.apache.solr.cloud.autoscaling.sim.SimClusterStateProvider;
import org.apache.solr.cloud.autoscaling.sim.SimDistribStateManager;
import org.apache.solr.cloud.autoscaling.sim.SimNodeStateProvider;
import org.apache.solr.cloud.autoscaling.sim.SimUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.MetricsHandler;
import org.apache.solr.handler.admin.MetricsHistoryHandler;
import org.apache.solr.metrics.AltBufferPoolMetricSet;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.OperatingSystemMetricSet;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.MockSearchableSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimCloudManager
implements SolrCloudManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Random random;
    private final SimDistribStateManager stateManager;
    private final SimClusterStateProvider clusterStateProvider;
    private final SimNodeStateProvider nodeStateProvider;
    private final AutoScalingHandler autoScalingHandler;
    private final LiveNodesSet liveNodesSet = new LiveNodesSet();
    private final DistributedQueueFactory queueFactory;
    private final ObjectCache objectCache = new ObjectCache();
    private final SolrMetricManager metricManager = new SolrMetricManager();
    private final String metricTag;
    private final List<SolrInputDocument> systemColl = Collections.synchronizedList(new ArrayList());
    private final Map<String, Map<String, AtomicInteger>> eventCounts = new ConcurrentHashMap<String, Map<String, AtomicInteger>>();
    private final MockSearchableSolrClient solrClient;
    private final Map<String, AtomicLong> opCounts = new ConcurrentSkipListMap<String, AtomicLong>();
    private final AtomicLong backgroundTaskFailureCounter = new AtomicLong(0L);
    private ExecutorService simCloudManagerPool;
    private Overseer.OverseerThread triggerThread;
    private ThreadGroup triggerThreadGroup;
    private SolrResourceLoader loader = new SolrResourceLoader();
    private MetricsHandler metricsHandler;
    private MetricsHistoryHandler metricsHistoryHandler;
    private TimeSource timeSource;
    private boolean useSystemCollection = true;
    private static int nodeIdPort;
    public static int DEFAULT_FREE_DISK;
    public static int DEFAULT_TOTAL_DISK;
    public static long DEFAULT_IDX_SIZE_BYTES;

    public SimCloudManager(TimeSource timeSource) throws Exception {
        this(timeSource, null);
    }

    SimCloudManager(TimeSource timeSource, SimDistribStateManager distribStateManager) throws Exception {
        if (distribStateManager == null) {
            this.stateManager = new SimDistribStateManager(SimDistribStateManager.createNewRootNode());
            this.stateManager.makePath("/clusterstate.json");
            this.stateManager.makePath("/clusterprops.json");
            this.stateManager.makePath("/autoscaling.json");
            this.stateManager.makePath("/live_nodes");
            this.stateManager.makePath("/roles.json");
            this.stateManager.makePath("/autoscaling/events");
            this.stateManager.makePath("/autoscaling/triggerState");
            this.stateManager.makePath("/autoscaling/nodeLost");
            this.stateManager.makePath("/autoscaling/nodeAdded");
            this.stateManager.makePath("/overseer_elect");
        } else {
            this.stateManager = distribStateManager;
        }
        this.metricTag = Integer.toHexString(this.hashCode());
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]);
        this.metricManager.registerAll(registryName, new AltBufferPoolMetricSet(), SolrMetricManager.ResolutionStrategy.REPLACE, "buffers");
        this.metricManager.registerAll(registryName, (MetricSet)new ClassLoadingGaugeSet(), SolrMetricManager.ResolutionStrategy.REPLACE, "classes");
        this.metricManager.registerAll(registryName, new OperatingSystemMetricSet(), SolrMetricManager.ResolutionStrategy.REPLACE, "os");
        this.metricManager.registerAll(registryName, (MetricSet)new GarbageCollectorMetricSet(), SolrMetricManager.ResolutionStrategy.REPLACE, "gc");
        this.metricManager.registerAll(registryName, (MetricSet)new MemoryUsageGaugeSet(), SolrMetricManager.ResolutionStrategy.REPLACE, "memory");
        this.metricManager.registerAll(registryName, (MetricSet)new ThreadStatesGaugeSet(), SolrMetricManager.ResolutionStrategy.REPLACE, "threads");
        MetricsMap sysprops = new MetricsMap((detailed, map) -> System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(String.valueOf(k), v))));
        this.metricManager.registerGauge(null, registryName, sysprops, this.metricTag, true, "properties", "system");
        registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]);
        this.metricManager.registerGauge(null, registryName, () -> new File("/").getUsableSpace(), this.metricTag, true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrClient = new MockSearchableSolrClient(){

            @Override
            public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
                if (collection != null) {
                    if (request instanceof AbstractUpdateRequest) {
                        ((AbstractUpdateRequest)request).setParam("collection", collection);
                    } else if (request instanceof QueryRequest) {
                        ModifiableSolrParams params;
                        if (request.getPath() != null && (request.getPath().startsWith("/admin/autoscaling") || request.getPath().startsWith("/cluster/autoscaling") || request.getPath().startsWith("/admin/metrics/history") || request.getPath().startsWith("/cluster/metrics/history"))) {
                            params = new ModifiableSolrParams(request.getParams());
                            params.set("collection", new String[]{collection});
                            request = new QueryRequest((SolrParams)params);
                        } else {
                            if (collection.equals(".system")) {
                                return super.request(request, collection);
                            }
                            params = new ModifiableSolrParams(request.getParams());
                            params.set("collection", new String[]{collection});
                            request = new QueryRequest((SolrParams)params);
                        }
                    } else {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "when collection != null only UpdateRequest and QueryRequest are supported: request=" + request + ", collection=" + collection);
                    }
                }
                try {
                    SolrResponse rsp = SimCloudManager.this.request(request);
                    return rsp.getResponse();
                }
                catch (UnsupportedOperationException e) {
                    throw new SolrServerException((Throwable)e);
                }
            }
        };
        this.timeSource = timeSource != null ? timeSource : TimeSource.NANO_TIME;
        this.clusterStateProvider = new SimClusterStateProvider(this.liveNodesSet, this);
        this.nodeStateProvider = new SimNodeStateProvider(this.liveNodesSet, this.stateManager, this.clusterStateProvider, null);
        this.queueFactory = new GenericDistributedQueueFactory(this.stateManager);
        this.simCloudManagerPool = ExecutorUtil.newMDCAwareFixedThreadPool((int)200, (ThreadFactory)new SolrNamedThreadFactory("simCloudManagerPool"));
        this.autoScalingHandler = new AutoScalingHandler(this, this.loader);
        this.triggerThreadGroup = new ThreadGroup("Simulated Overseer autoscaling triggers");
        OverseerTriggerThread trigger = new OverseerTriggerThread(this.loader, this, new CloudConfig.CloudConfigBuilder("nonexistent", 0, "sim").build());
        this.triggerThread = new Overseer.OverseerThread(this.triggerThreadGroup, (Closeable)((Object)trigger), "Simulated OverseerAutoScalingTriggerThread");
        this.triggerThread.start();
    }

    public static SimCloudManager createCluster(int numNodes, TimeSource timeSource) throws Exception {
        SimCloudManager cloudManager = new SimCloudManager(timeSource);
        for (int i = 1; i <= numNodes; ++i) {
            cloudManager.simAddNode();
        }
        return cloudManager;
    }

    public static SimCloudManager createCluster(ClusterState initialState, TimeSource timeSource) throws Exception {
        SimCloudManager cloudManager = new SimCloudManager(timeSource);
        cloudManager.getSimClusterStateProvider().simSetClusterState(initialState);
        for (String node : cloudManager.getClusterStateProvider().getLiveNodes()) {
            cloudManager.getSimNodeStateProvider().simSetNodeValues(node, SimCloudManager.createNodeValues(node));
        }
        return cloudManager;
    }

    public static SimCloudManager createCluster(SolrCloudManager other, AutoScalingConfig config, TimeSource timeSource) throws Exception {
        SimDistribStateManager distribStateManager = new SimDistribStateManager(SimDistribStateManager.createNewRootNode());
        distribStateManager.copyFrom(other.getDistribStateManager(), false);
        SimCloudManager cloudManager = new SimCloudManager(timeSource, distribStateManager);
        if (config != null) {
            cloudManager.getSimDistribStateManager().simSetAutoScalingConfig(config);
        } else {
            config = cloudManager.getDistribStateManager().getAutoScalingConfig();
        }
        HashSet<String> nodeTags = new HashSet<String>(SimUtils.COMMON_NODE_TAGS);
        nodeTags.addAll(config.getPolicy().getParamNames());
        HashSet<String> replicaTags = new HashSet<String>(SimUtils.COMMON_REPLICA_TAGS);
        replicaTags.addAll(config.getPolicy().getPerReplicaAttributes());
        cloudManager.getSimClusterStateProvider().copyFrom(other.getClusterStateProvider());
        for (String node : other.getClusterStateProvider().getLiveNodes()) {
            SimClusterStateProvider simClusterStateProvider = cloudManager.getSimClusterStateProvider();
            cloudManager.getSimNodeStateProvider().simSetNodeValues(node, other.getNodeStateProvider().getNodeValues(node, nodeTags));
            Map infos = other.getNodeStateProvider().getReplicaInfo(node, replicaTags);
            simClusterStateProvider.simSetReplicaValues(node, infos, true);
        }
        SimUtils.checkConsistency(cloudManager, config);
        return cloudManager;
    }

    public static Map<String, Object> createNodeValues(String nodeName) {
        String nodeId;
        int port;
        String host;
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (nodeName == null) {
            host = "127.0.0.1";
            port = nodeIdPort++;
            nodeId = host + ":" + port + "_solr";
            values.put("ip_1", "127");
            values.put("ip_2", "0");
            values.put("ip_3", "0");
            values.put("ip_4", "1");
        } else {
            String[] hostPortCtx = nodeName.split(":");
            if (hostPortCtx.length != 2) {
                throw new RuntimeException("Invalid nodeName " + nodeName);
            }
            host = hostPortCtx[0];
            String[] portCtx = hostPortCtx[1].split("_");
            if (portCtx.length != 2) {
                throw new RuntimeException("Invalid port_context in nodeName " + nodeName);
            }
            port = Integer.parseInt(portCtx[0]);
            nodeId = host + ":" + port + "_" + portCtx[1];
            String[] ip = host.split("\\.");
            if (ip.length == 4) {
                values.put("ip_1", ip[0]);
                values.put("ip_2", ip[1]);
                values.put("ip_3", ip[2]);
                values.put("ip_4", ip[3]);
            }
        }
        values.put("host", host);
        values.put("port", port);
        values.put("node", nodeId);
        values.put("cores", 0);
        values.put("freedisk", DEFAULT_FREE_DISK);
        values.put(Variable.Type.TOTALDISK.tagName, DEFAULT_TOTAL_DISK);
        values.put("sysLoadAvg", 1.0);
        values.put("heapUsage", 123450000);
        values.put("sysprop.java.version", System.getProperty("java.version"));
        values.put("sysprop.java.vendor", System.getProperty("java.vendor"));
        values.put("metrics:solr.node:ADMIN./admin/authorization.clientErrors:count", 0);
        values.put("metrics:solr.jvm:buffers.direct.Count", 0);
        return values;
    }

    public void disableMetricsHistory() {
        this.metricsHistoryHandler.close();
    }

    public String dumpClusterState(boolean withCollections) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("#######################################\n");
        sb.append("############ CLUSTER STATE ############\n");
        sb.append("#######################################\n");
        sb.append("## Live nodes:\t\t").append(this.getLiveNodesSet().size()).append("\n");
        int emptyNodes = 0;
        int maxReplicas = 0;
        int minReplicas = Integer.MAX_VALUE;
        TreeMap<String, Map> replicaStates = new TreeMap<String, Map>();
        int numReplicas = 0;
        for (String node : this.getLiveNodesSet().get()) {
            List<ReplicaInfo> replicas = this.getSimClusterStateProvider().simGetReplicaInfos(node);
            numReplicas += replicas.size();
            if (replicas.size() > maxReplicas) {
                maxReplicas = replicas.size();
            }
            if (minReplicas > replicas.size()) {
                minReplicas = replicas.size();
            }
            for (ReplicaInfo ri : replicas) {
                replicaStates.computeIfAbsent(ri.getCollection(), c -> new TreeMap()).computeIfAbsent(ri.getState(), s -> new AtomicInteger()).incrementAndGet();
            }
            if (!replicas.isEmpty()) continue;
            ++emptyNodes;
        }
        if (minReplicas == Integer.MAX_VALUE) {
            minReplicas = 0;
        }
        sb.append("## Empty nodes:\t").append(emptyNodes).append("\n");
        Set<String> deadNodes = this.getSimNodeStateProvider().simGetDeadNodes();
        sb.append("## Dead nodes:\t\t").append(deadNodes.size()).append("\n");
        deadNodes.forEach(n -> sb.append("##\t\t").append((String)n).append("\n"));
        sb.append("## Collections:\n");
        this.clusterStateProvider.simGetCollectionStats().forEach((coll, stats) -> {
            sb.append("##  * ").append((String)coll).append('\n');
            stats.forEach((k, v) -> sb.append("##    ").append((String)k).append("\t").append(v).append("\n"));
        });
        if (withCollections) {
            ClusterState state = this.clusterStateProvider.getClusterState();
            state.forEachCollection(coll -> sb.append(coll.toString()).append("\n"));
        }
        sb.append("## Max replicas per node:\t").append(maxReplicas).append("\n");
        sb.append("## Min replicas per node:\t").append(minReplicas).append("\n");
        sb.append("## Total replicas:\t\t").append(numReplicas).append("\n");
        replicaStates.forEach((c, map) -> {
            AtomicInteger repCnt = new AtomicInteger();
            map.forEach((s, cnt) -> repCnt.addAndGet(cnt.get()));
            sb.append("## * ").append((String)c).append("\t\t").append(repCnt.get()).append("\n");
            map.forEach((s, cnt) -> sb.append("##\t\t- ").append(String.format(Locale.ROOT, "%-12s  %4d", s, cnt.get())).append("\n"));
        });
        sb.append("######### Solr op counts ##########\n");
        this.simGetOpCounts().forEach((k, cnt) -> sb.append("##\t\t- ").append(String.format(Locale.ROOT, "%-14s  %4d", k, cnt.get())).append("\n"));
        sb.append("######### Autoscaling event counts ###########\n");
        Map<String, Map<String, AtomicInteger>> counts = this.simGetEventCounts();
        counts.forEach((trigger, map) -> {
            sb.append("## * Trigger: ").append((String)trigger).append("\n");
            map.forEach((s, cnt) -> sb.append("##\t\t- ").append(String.format(Locale.ROOT, "%-11s  %4d", s, cnt.get())).append("\n"));
        });
        return sb.toString();
    }

    public SolrResourceLoader getLoader() {
        return this.loader;
    }

    public Random getRandom() {
        return random;
    }

    public String simAddNode() throws Exception {
        Map<String, Object> values = SimCloudManager.createNodeValues(null);
        String nodeId = (String)values.get("node");
        this.nodeStateProvider.simSetNodeValues(nodeId, values);
        this.clusterStateProvider.simAddNode(nodeId);
        log.trace("-- added node {}", (Object)nodeId);
        if (this.metricsHistoryHandler == null && this.liveNodesSet.size() == 1) {
            this.metricsHandler = new MetricsHandler(this.metricManager);
            this.metricsHistoryHandler = new MetricsHistoryHandler(nodeId, this.metricsHandler, this.solrClient, this, new HashMap<String, Object>());
            this.metricsHistoryHandler.initializeMetrics(this.metricManager, SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]), this.metricTag, "/admin/metrics/history");
        }
        return nodeId;
    }

    public void simRemoveNode(String nodeId, boolean withValues) throws Exception {
        this.clusterStateProvider.simRemoveNode(nodeId);
        if (withValues) {
            this.nodeStateProvider.simRemoveNodeValues(nodeId);
        }
        if (this.liveNodesSet.isEmpty()) {
            if (this.metricsHistoryHandler != null) {
                IOUtils.closeQuietly((Closeable)this.metricsHistoryHandler);
                this.metricsHistoryHandler = null;
            }
            if (this.metricsHandler != null) {
                this.metricsHandler = null;
            }
        }
        log.trace("-- removed node {}", (Object)nodeId);
    }

    public void simRemoveRandomNodes(int number, boolean withValues, Random random) throws Exception {
        ArrayList<String> nodes = new ArrayList<String>(this.liveNodesSet.get());
        Collections.shuffle(nodes, random);
        int count = Math.min(number, nodes.size());
        for (int i = 0; i < count; ++i) {
            this.simRemoveNode((String)nodes.get(i), withValues);
        }
    }

    public void simSetUseSystemCollection(boolean useSystemCollection) {
        this.useSystemCollection = useSystemCollection;
    }

    public void simClearSystemCollection() {
        this.systemColl.clear();
    }

    public List<SolrInputDocument> simGetSystemCollection() {
        return this.systemColl;
    }

    public Map<String, Map<String, AtomicInteger>> simGetEventCounts() {
        TreeMap<String, Map<String, AtomicInteger>> counts = new TreeMap<String, Map<String, AtomicInteger>>(this.eventCounts);
        return counts;
    }

    public SolrClient simGetSolrClient() {
        return this.solrClient;
    }

    public void simRestartOverseer(String killNodeId) throws Exception {
        log.info("=== Restarting OverseerTriggerThread and clearing object cache...");
        this.triggerThread.interrupt();
        IOUtils.closeQuietly((Closeable)this.triggerThread);
        if (killNodeId != null) {
            log.info("  = killing node {}", (Object)killNodeId);
            this.simRemoveNode(killNodeId, false);
        }
        this.objectCache.clear();
        try {
            this.simCloudManagerPool.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.simCloudManagerPool = ExecutorUtil.newMDCAwareFixedThreadPool((int)200, (ThreadFactory)new SolrNamedThreadFactory("simCloudManagerPool"));
        OverseerTriggerThread trigger = new OverseerTriggerThread(this.loader, this, new CloudConfig.CloudConfigBuilder("nonexistent", 0, "sim").build());
        this.triggerThread = new Overseer.OverseerThread(this.triggerThreadGroup, (Closeable)((Object)trigger), "Simulated OverseerAutoScalingTriggerThread");
        this.triggerThread.start();
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.simCloudManagerPool.submit(new LoggingCallable<T>(this.backgroundTaskFailureCounter, callable));
    }

    public long getBackgroundTaskFailureCount() {
        return this.backgroundTaskFailureCounter.get();
    }

    public SimClusterStateProvider getSimClusterStateProvider() {
        return this.clusterStateProvider;
    }

    public SimNodeStateProvider getSimNodeStateProvider() {
        return this.nodeStateProvider;
    }

    public SimDistribStateManager getSimDistribStateManager() {
        return this.stateManager;
    }

    public LiveNodesSet getLiveNodesSet() {
        return this.liveNodesSet;
    }

    public Map<String, AtomicLong> simGetOpCounts() {
        return this.opCounts;
    }

    public void simResetOpCounts() {
        this.opCounts.clear();
    }

    public long simGetOpCount(String op) {
        AtomicLong count = this.opCounts.get(op);
        return count != null ? count.get() : 0L;
    }

    public SolrMetricManager getMetricManager() {
        return this.metricManager;
    }

    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public ClusterStateProvider getClusterStateProvider() {
        return this.clusterStateProvider;
    }

    public NodeStateProvider getNodeStateProvider() {
        return this.nodeStateProvider;
    }

    public DistribStateManager getDistribStateManager() {
        return this.stateManager;
    }

    public DistributedQueueFactory getDistributedQueueFactory() {
        return this.queueFactory;
    }

    public SolrResponse request(SolrRequest req) throws IOException {
        try {
            Future<SolrResponse> rsp = this.simCloudManagerPool.submit(() -> this.simHandleSolrRequest(req));
            return rsp.get(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void incrementCount(String op) {
        AtomicLong count = this.opCounts.computeIfAbsent(op, o -> new AtomicLong());
        count.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SolrResponse simHandleSolrRequest(SolrRequest req) throws IOException, InterruptedException {
        List docs;
        this.timeSource.sleep(5L);
        if (log.isTraceEnabled()) {
            log.trace("--- got SolrRequest: {} {} {}", new Object[]{req.getMethod(), req.getPath(), req.getParams() != null ? " " + req.getParams() : ""});
        }
        if (req.getPath() != null) {
            if (req.getPath().startsWith("/admin/autoscaling") || req.getPath().startsWith("/cluster/autoscaling") || req.getPath().startsWith("/admin/metrics") || req.getPath().startsWith("/cluster/metrics")) {
                RequestWriter.ContentWriter cw;
                this.metricManager.registry("solr.node").counter("ADMIN." + req.getPath() + ".requests").inc();
                boolean autoscaling = req.getPath().contains("autoscaling");
                boolean history = req.getPath().contains("history");
                if (autoscaling) {
                    this.incrementCount("autoscaling");
                } else if (history) {
                    this.incrementCount("metricsHistory");
                } else {
                    this.incrementCount("metrics");
                }
                ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
                params.set("path", new String[]{req.getPath()});
                LocalSolrQueryRequest queryRequest = new LocalSolrQueryRequest(null, (SolrParams)params);
                if (autoscaling && null != (cw = req.getContentWriter("application/json"))) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    cw.write((OutputStream)baos);
                    String payload = baos.toString("UTF-8");
                    log.trace("-- payload: {}", (Object)payload);
                    queryRequest.setContentStreams(Collections.singletonList(new ContentStreamBase.StringStream(payload)));
                }
                queryRequest.getContext().put("httpMethod", req.getMethod().toString());
                SolrQueryResponse queryResponse = new SolrQueryResponse();
                queryResponse.addResponseHeader((NamedList<Object>)new SimpleOrderedMap());
                if (autoscaling) {
                    this.autoScalingHandler.handleRequest(queryRequest, queryResponse);
                } else if (history) {
                    if (this.metricsHistoryHandler == null) {
                        queryRequest.close();
                        throw new UnsupportedOperationException("must add at least 1 node first");
                    }
                    this.metricsHistoryHandler.handleRequest(queryRequest, queryResponse);
                } else {
                    if (this.metricsHandler == null) {
                        queryRequest.close();
                        throw new UnsupportedOperationException("must add at least 1 node first");
                    }
                    this.metricsHandler.handleRequest(queryRequest, queryResponse);
                }
                if (queryResponse.getException() != null) {
                    if (!log.isDebugEnabled()) throw new IOException(queryResponse.getException());
                    log.debug("-- exception handling request", (Throwable)queryResponse.getException());
                    throw new IOException(queryResponse.getException());
                }
                SolrResponseBase rsp = new SolrResponseBase();
                rsp.setResponse(queryResponse.getValues());
                log.trace("-- response: {}", (Object)rsp);
                return rsp;
            }
            if (req instanceof QueryRequest) {
                this.incrementCount("query");
                return this.clusterStateProvider.simQuery((QueryRequest)req);
            }
        }
        if (req instanceof UpdateRequest) {
            this.incrementCount("update");
            UpdateRequest ureq = (UpdateRequest)req;
            String collection = ureq.getCollection();
            UpdateResponse rsp = this.clusterStateProvider.simUpdate(ureq);
            if (collection != null) {
                if (!collection.equals(".system")) return rsp;
            }
            if ((docs = ureq.getDocuments()) == null) return new UpdateResponse();
            if (this.useSystemCollection) {
                this.systemColl.addAll(docs);
            }
        } else {
            String path;
            SolrParams params = req.getParams();
            String a = params != null ? params.get("action") : null;
            SolrResponseBase rsp = new SolrResponseBase();
            rsp.setResponse(new NamedList());
            String string = path = params != null ? params.get("path") : null;
            if (!(req instanceof CollectionAdminRequest)) {
                if (req instanceof V2Request) {
                    params = SimUtils.v2AdminRequestToV1Params((V2Request)req);
                    a = params.get("action");
                } else {
                    if (path == null) throw new UnsupportedOperationException("Only some CollectionAdminRequest-s are supported: " + req.getClass().getName() + ": " + req.getPath() + " " + req.getParams());
                    if (!path.startsWith("/admin/")) {
                        if (!path.startsWith("/cluster/")) throw new UnsupportedOperationException("Only some CollectionAdminRequest-s are supported: " + req.getClass().getName() + ": " + req.getPath() + " " + req.getParams());
                    }
                }
            }
            this.metricManager.registry("solr.node").counter("ADMIN." + req.getPath() + ".requests").inc();
            if (a == null) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param in request: " + params);
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            if (log.isTraceEnabled()) {
                log.trace("Invoking Collection Action :{} with params {}", (Object)action.toLower(), (Object)params.toQueryString());
            }
            NamedList results = new NamedList();
            rsp.setResponse(results);
            this.incrementCount(action.name());
            switch (action) {
                case REQUESTSTATUS: {
                    String requestId = params.get("requestid");
                    SimpleOrderedMap status = new SimpleOrderedMap();
                    status.add("state", (Object)RequestStatusState.COMPLETED.getKey());
                    status.add("msg", (Object)("found [" + requestId + "] in completed tasks"));
                    results.add("status", (Object)status);
                    results.add("success", (Object)"");
                    rsp = new CollectionAdminRequest.RequestStatusResponse();
                    rsp.setResponse(results);
                    return rsp;
                }
                case DELETESTATUS: {
                    String requestId = params.get("requestid");
                    results.add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                    results.add("success", (Object)"");
                    return rsp;
                }
                case CREATE: {
                    try {
                        this.clusterStateProvider.simCreateCollection(new ZkNodeProps(params.toNamedList().asMap(10)), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                case DELETE: {
                    try {
                        this.clusterStateProvider.simDeleteCollection(params.get("name"), params.get("async"), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                case LIST: {
                    results.add("collections", this.clusterStateProvider.simListCollections());
                    return rsp;
                }
                case ADDREPLICA: {
                    try {
                        this.clusterStateProvider.simAddReplica(new ZkNodeProps(params.toNamedList().asMap(10)), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                case MOVEREPLICA: {
                    try {
                        this.clusterStateProvider.simMoveReplica(new ZkNodeProps(params.toNamedList().asMap(10)), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                case OVERSEERSTATUS: {
                    if (params.get("async") != null) {
                        results.add("requestid", (Object)params.get("async"));
                    }
                    if (!this.liveNodesSet.get().isEmpty()) {
                        results.add("leader", (Object)this.liveNodesSet.get().iterator().next());
                    }
                    results.add("overseer_queue_size", (Object)0);
                    results.add("overseer_work_queue_size", (Object)0);
                    results.add("overseer_collection_queue_size", (Object)0);
                    results.add("success", (Object)"");
                    return rsp;
                }
                case ADDROLE: {
                    this.nodeStateProvider.simSetNodeValue(params.get("node"), "nodeRole", params.get("role"));
                    return rsp;
                }
                case CREATESHARD: {
                    try {
                        this.clusterStateProvider.simCreateShard(new ZkNodeProps(params.toNamedList().asMap(10)), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                case SPLITSHARD: {
                    try {
                        this.clusterStateProvider.simSplitShard(new ZkNodeProps(params.toNamedList().asMap(10)), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                case DELETESHARD: {
                    try {
                        this.clusterStateProvider.simDeleteShard(new ZkNodeProps(params.toNamedList().asMap(10)), results);
                        return rsp;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
            }
            throw new UnsupportedOperationException("Unsupported collection admin action=" + action + " in request: " + params);
        }
        Iterator queryResponse = docs.iterator();
        while (queryResponse.hasNext()) {
            SolrInputDocument d = (SolrInputDocument)queryResponse.next();
            if (!"autoscaling_event".equals(d.getFieldValue("type"))) continue;
            this.eventCounts.computeIfAbsent((String)d.getFieldValue("event.source_s"), s -> new ConcurrentHashMap()).computeIfAbsent((String)d.getFieldValue("stage_s"), s -> new AtomicInteger()).incrementAndGet();
        }
        return new UpdateResponse();
    }

    public byte[] httpRequest(String url, SolrRequest.METHOD method, Map<String, String> headers, String payload, int timeout, boolean followRedirects) throws IOException {
        throw new UnsupportedOperationException("general HTTP requests are not supported yet");
    }

    public void close() throws IOException {
        this.simCloudManagerPool.shutdownNow();
        if (this.metricsHistoryHandler != null) {
            IOUtils.closeQuietly((Closeable)this.metricsHistoryHandler);
        }
        IOUtils.closeQuietly((Closeable)((Object)this.clusterStateProvider));
        IOUtils.closeQuietly((Closeable)((Object)this.nodeStateProvider));
        IOUtils.closeQuietly((Closeable)((Object)this.stateManager));
        this.triggerThread.interrupt();
        IOUtils.closeQuietly((Closeable)this.triggerThread);
        this.triggerThread.interrupt();
        try {
            this.triggerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        IOUtils.closeQuietly((Closeable)this.objectCache);
    }

    public OverseerTriggerThread getOverseerTriggerThread() {
        return (OverseerTriggerThread)((Object)this.triggerThread.getThread());
    }

    static {
        String seed = System.getProperty("tests.seed");
        random = seed == null ? new Random() : new Random(seed.hashCode());
        nodeIdPort = 10000;
        DEFAULT_FREE_DISK = 10240;
        DEFAULT_TOTAL_DISK = 10240;
        DEFAULT_IDX_SIZE_BYTES = 10240L;
    }

    private static final class LoggingCallable<T>
    implements Callable<T> {
        final AtomicLong failCounter;
        final Callable<T> inner;

        public LoggingCallable(AtomicLong failCounter, Callable<T> inner) {
            assert (null != failCounter);
            assert (null != inner);
            this.failCounter = failCounter;
            this.inner = inner;
        }

        @Override
        public T call() throws Exception {
            try {
                return this.inner.call();
            }
            catch (InterruptedException ignored) {
                log.warn("Callable interupted", (Throwable)ignored);
                throw ignored;
            }
            catch (Throwable t) {
                if (Thread.currentThread().isInterrupted()) {
                    log.warn("Callable interrupted w/o noticing", t);
                    throw t;
                }
                Throwable cause = t;
                while ((cause = cause.getCause()) != null) {
                    if (!(cause instanceof InterruptedException)) continue;
                    log.warn("Callable threw wrapped InterruptedException", t);
                    throw t;
                }
                this.failCounter.incrementAndGet();
                log.error("Callable failed", t);
                throw t;
            }
        }
    }
}

