/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.CloseableResourceInfo;
import com.carrotsearch.randomizedtesting.GroupEvaluator;
import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.ObjectProcedure;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.Threads;
import com.carrotsearch.randomizedtesting.annotations.Nightly;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;

public final class RandomizedContext {
    private static final Object _globalLock = new Object();
    private final Object _contextLock = new Object();
    static final IdentityHashMap<ThreadGroup, RandomizedContext> contexts = new IdentityHashMap();
    final WeakHashMap<Thread, PerThreadResources> perThreadResources = new WeakHashMap();
    private final ThreadGroup threadGroup;
    private final Class<?> suiteClass;
    private final RandomizedRunner runner;
    private volatile boolean disposed;
    private EnumMap<LifecycleScope, List<CloseableResourceInfo>> disposableResources = new EnumMap(LifecycleScope.class);
    private Method currentMethod;

    private RandomizedContext(ThreadGroup tg, Class<?> suiteClass, RandomizedRunner runner) {
        this.threadGroup = tg;
        this.suiteClass = suiteClass;
        this.runner = runner;
    }

    public Class<?> getTargetClass() {
        this.checkDisposed();
        return this.suiteClass;
    }

    long getRunnerSeed() {
        return this.runner.runnerRandomness.getSeed();
    }

    public String getRunnerSeedAsString() {
        this.checkDisposed();
        return SeedUtils.formatSeed(this.getRunnerSeed());
    }

    public Randomness getRandomness() {
        return this.getPerThread().randomnesses.peekFirst();
    }

    Randomness[] getRandomnesses() {
        ArrayDeque<Randomness> randomnesses = this.getPerThread().randomnesses;
        Randomness[] array = randomnesses.toArray(new Randomness[randomnesses.size()]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            Randomness r = array[i];
            array[i] = array[j];
            array[j] = r;
        }
        return array;
    }

    public Random getRandom() {
        return this.getRandomness().getRandom();
    }

    public boolean isNightly() {
        this.checkDisposed();
        return this.getGroupEvaluator().isGroupEnabled(Nightly.class);
    }

    public static RandomizedContext current() {
        return RandomizedContext.context(Thread.currentThread());
    }

    public RandomizedRunner getRunner() {
        return this.runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Closeable> T closeAtEnd(T resource, LifecycleScope scope) {
        Object object = this._contextLock;
        synchronized (object) {
            List<CloseableResourceInfo> resources = this.disposableResources.get((Object)scope);
            if (resources == null) {
                resources = new ArrayList<CloseableResourceInfo>();
                this.disposableResources.put(scope, resources);
            }
            resources.add(new CloseableResourceInfo(resource, scope, Thread.currentThread(), Thread.currentThread().getStackTrace()));
            return resource;
        }
    }

    public GroupEvaluator getGroupEvaluator() {
        return this.runner.groupEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithPrivateRandomness(Randomness randomness, Callable<T> callable) throws Exception {
        this.push(randomness);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.popAndDestroy();
        }
    }

    public <T> T runWithPrivateRandomness(long seed, Callable<T> callable) throws Exception {
        Randomness randomness = this.getRandomness();
        Randomness prv = new Randomness(seed, randomness.getRandomSupplier(), randomness.getDecorators());
        return this.runWithPrivateRandomness(prv, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResources(ObjectProcedure<CloseableResourceInfo> consumer, LifecycleScope scope) {
        List<CloseableResourceInfo> resources;
        Iterator<CloseableResourceInfo> iterator = this._contextLock;
        synchronized (iterator) {
            resources = this.disposableResources.remove((Object)scope);
        }
        if (resources != null) {
            for (CloseableResourceInfo info : resources) {
                consumer.apply(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RandomizedContext context(Thread thread) {
        ThreadGroup currentGroup = thread.getThreadGroup();
        if (currentGroup == null) {
            throw new IllegalStateException("No context for a terminated thread: " + Threads.threadName(thread));
        }
        Object object = _globalLock;
        synchronized (object) {
            RandomizedContext context;
            while ((context = contexts.get(currentGroup)) == null && currentGroup.getParent() != null) {
                currentGroup = currentGroup.getParent();
            }
            if (context == null) {
                throw new IllegalStateException("No context information for thread: " + Threads.threadName(thread) + ". Is this thread running under a " + RandomizedRunner.class + " runner context? Add @RunWith(" + RandomizedRunner.class + ".class) to your test class. Make sure your code accesses random contexts within @BeforeClass and @AfterClass boundary (for example, static test class initializers are not permitted to access random contexts).");
            }
            Object object2 = context._contextLock;
            synchronized (object2) {
                if (!context.perThreadResources.containsKey(thread)) {
                    PerThreadResources perThreadResources = new PerThreadResources();
                    perThreadResources.randomnesses.push(context.runner.runnerRandomness.clone(thread));
                    context.perThreadResources.put(thread, perThreadResources);
                }
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RandomizedContext create(ThreadGroup tg, Class<?> suiteClass, RandomizedRunner runner) {
        assert (Thread.currentThread().getThreadGroup() == tg);
        Object object = _globalLock;
        synchronized (object) {
            RandomizedContext ctx = new RandomizedContext(tg, suiteClass, runner);
            contexts.put(tg, ctx);
            ctx.perThreadResources.put(Thread.currentThread(), new PerThreadResources());
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = _globalLock;
        synchronized (object) {
            this.checkDisposed();
            this.disposed = true;
            contexts.remove(this.threadGroup);
            Object object2 = this._contextLock;
            synchronized (object2) {
                for (PerThreadResources ref : this.perThreadResources.values()) {
                    if (ref == null) continue;
                    for (Randomness randomness : ref.randomnesses) {
                        randomness.destroy();
                    }
                }
            }
        }
    }

    void push(Randomness rnd) {
        this.getPerThread().randomnesses.push(rnd);
    }

    void popAndDestroy() {
        this.getPerThread().randomnesses.pop().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerThreadResources getPerThread() {
        this.checkDisposed();
        Object object = this._contextLock;
        synchronized (object) {
            return this.perThreadResources.get(Thread.currentThread());
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Context disposed: " + this.toString() + " for thread: " + Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cloneFor(Thread t) {
        if (t.getState() != Thread.State.NEW) {
            throw new IllegalStateException("The thread to share context with is not in NEW state: " + t);
        }
        ThreadGroup tGroup = t.getThreadGroup();
        if (tGroup == null) {
            throw new IllegalStateException("No thread group for thread: " + t);
        }
        Thread me = Thread.currentThread();
        if (me.getThreadGroup() != tGroup) {
            throw new IllegalArgumentException("Both threads must share the thread group.");
        }
        Object object = _globalLock;
        synchronized (object) {
            RandomizedContext context = contexts.get(tGroup);
            if (context == null) {
                throw new IllegalStateException("No context information for thread: " + t);
            }
            Object object2 = context._contextLock;
            synchronized (object2) {
                if (context.perThreadResources.containsKey(t)) {
                    throw new IllegalStateException("Context already initialized for thread: " + t);
                }
                if (!context.perThreadResources.containsKey(me)) {
                    throw new IllegalStateException("Context not initialized for thread: " + me);
                }
                PerThreadResources perThreadResources = new PerThreadResources();
                for (Randomness r : context.perThreadResources.get((Object)me).randomnesses) {
                    perThreadResources.randomnesses.addLast(r.clone(t));
                }
                context.perThreadResources.put(t, perThreadResources);
            }
        }
    }

    void setTargetMethod(Method method) {
        this.currentMethod = method;
    }

    public Method getTargetMethod() {
        this.checkDisposed();
        return this.currentMethod;
    }

    private static final class PerThreadResources {
        final ArrayDeque<Randomness> randomnesses = new ArrayDeque();

        private PerThreadResources() {
        }
    }
}

