define("core_filters/events",["exports","core/event_dispatcher","core/normalise"],(function(_exports,_event_dispatcher,_normalise){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.notifyFilterContentUpdated=_exports.notifyFilterContentRenderingComplete=_exports.eventTypes=void 0;
/**
   * Javascript events for the `core_filters` subsystem.
   *
   * @module     core_filters/events
   * @copyright  2021 Andrew Nicols <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @since      4.0
   *
   * @example <caption>Example of listening to a filter event.</caption>
   * import {eventTypes as filterEventTypes} from 'core_filters/events';
   *
   * document.addEventListener(filterEventTypes.filterContentUpdated, e => {
   *     window.console.log(e.detail.nodes); // A list of the HTMLElements whose content was updated
   * });
   */
const eventTypes={filterContentUpdated:"core_filters/contentUpdated",filterContentRenderingComplete:"core_filters/contentRenderingComplete"};_exports.eventTypes=eventTypes;_exports.notifyFilterContentUpdated=nodes=>(nodes=(0,_normalise.getList)(nodes),(0,_event_dispatcher.dispatchEvent)(eventTypes.filterContentUpdated,{nodes:nodes}));_exports.notifyFilterContentRenderingComplete=nodes=>(0,_event_dispatcher.dispatchEvent)(eventTypes.filterContentRenderingComplete,{nodes:nodes})}));

//# sourceMappingURL=events.min.js.map