/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.CachingCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.AllGroupHeadsCollector;
import org.apache.lucene.search.grouping.AllGroupsCollector;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TermGroupSelector;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.TopGroupsCollector;
import org.apache.lucene.search.grouping.ValueSourceGroupSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.Filter;
import org.apache.solr.search.MaxScoreCollector;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.QueryResult;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.grouping.collector.FilterCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grouping {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrIndexSearcher searcher;
    private final QueryResult qr;
    private final QueryCommand cmd;
    private final List<Command> commands = new ArrayList<Command>();
    private final boolean main;
    private final boolean cacheSecondPassSearch;
    private final int maxDocsPercentageToCache;
    private Sort groupSort;
    private Sort withinGroupSort;
    private int limitDefault;
    private int docsPerGroupDefault;
    private int groupOffsetDefault;
    private Format defaultFormat;
    private TotalCount defaultTotalCount;
    private int maxDoc;
    private boolean needScores;
    private boolean getDocSet;
    private boolean getGroupedDocSet;
    private boolean getDocList;
    private Query query;
    private DocSet filter;
    private Filter luceneFilter;
    private NamedList<Object> grouped = new SimpleOrderedMap();
    private Set<Integer> idSet = new LinkedHashSet<Integer>();
    private int maxMatches;
    private float maxScore = Float.NaN;
    private boolean signalCacheWarning = false;
    private TimeLimitingCollector timeLimitingCollector;
    public DocList mainResult;

    public Grouping(SolrIndexSearcher searcher, QueryResult qr, QueryCommand cmd, boolean cacheSecondPassSearch, int maxDocsPercentageToCache, boolean main) {
        this.searcher = searcher;
        this.qr = qr;
        this.cmd = cmd;
        this.cacheSecondPassSearch = cacheSecondPassSearch;
        this.maxDocsPercentageToCache = maxDocsPercentageToCache;
        this.main = main;
    }

    public void add(Command groupingCommand) {
        this.commands.add(groupingCommand);
    }

    public void addFieldCommand(String field, SolrQueryRequest request) throws SyntaxError {
        SchemaField schemaField = this.searcher.getSchema().getField(field);
        FieldType fieldType = schemaField.getType();
        ValueSource valueSource = fieldType.getValueSource(schemaField, null);
        if (!(valueSource instanceof StrFieldSource)) {
            this.addFunctionCommand(field, request);
            return;
        }
        CommandField gc = new CommandField();
        gc.withinGroupSort = this.withinGroupSort;
        gc.groupBy = field;
        gc.key = field;
        gc.numGroups = this.limitDefault;
        gc.docsPerGroup = this.docsPerGroupDefault;
        gc.groupOffset = this.groupOffsetDefault;
        gc.offset = this.cmd.getOffset();
        gc.groupSort = this.groupSort;
        gc.format = this.defaultFormat;
        gc.totalCount = this.defaultTotalCount;
        if (this.main) {
            gc.main = true;
            gc.format = Format.simple;
        }
        if (gc.format == Format.simple) {
            gc.groupOffset = 0;
        }
        this.commands.add(gc);
    }

    public void addFunctionCommand(String groupByStr, SolrQueryRequest request) throws SyntaxError {
        Command gc;
        QParser parser = QParser.getParser(groupByStr, "func", request);
        Query q = parser.getQuery();
        if (q instanceof FunctionQuery) {
            ValueSource valueSource = ((FunctionQuery)q).getValueSource();
            if (valueSource instanceof StrFieldSource) {
                String field = ((StrFieldSource)valueSource).getField();
                CommandField commandField = new CommandField();
                commandField.groupBy = field;
                gc = commandField;
            } else {
                CommandFunc commandFunc = new CommandFunc();
                commandFunc.groupBy = valueSource;
                gc = commandFunc;
            }
        } else {
            CommandFunc commandFunc = new CommandFunc();
            commandFunc.groupBy = new QueryValueSource(q, 0.0f);
            gc = commandFunc;
        }
        gc.withinGroupSort = this.withinGroupSort;
        gc.key = groupByStr;
        gc.numGroups = this.limitDefault;
        gc.docsPerGroup = this.docsPerGroupDefault;
        gc.groupOffset = this.groupOffsetDefault;
        gc.offset = this.cmd.getOffset();
        gc.groupSort = this.groupSort;
        gc.format = this.defaultFormat;
        gc.totalCount = this.defaultTotalCount;
        if (this.main) {
            gc.main = true;
            gc.format = Format.simple;
        }
        if (gc.format == Format.simple) {
            gc.groupOffset = 0;
        }
        this.commands.add(gc);
    }

    public void addQueryCommand(String groupByStr, SolrQueryRequest request) throws SyntaxError {
        QParser parser = QParser.getParser(groupByStr, request);
        Query gq = parser.getQuery();
        CommandQuery gc = new CommandQuery();
        gc.query = gq;
        gc.withinGroupSort = this.withinGroupSort;
        gc.key = groupByStr;
        gc.numGroups = this.limitDefault;
        gc.docsPerGroup = this.docsPerGroupDefault;
        gc.groupOffset = this.groupOffsetDefault;
        gc.offset = this.cmd.getOffset();
        gc.numGroups = this.limitDefault;
        gc.format = this.defaultFormat;
        if (this.main) {
            gc.main = true;
            gc.format = Format.simple;
        }
        if (gc.format == Format.simple) {
            gc.docsPerGroup = gc.numGroups;
            gc.groupOffset = gc.offset;
        }
        this.commands.add(gc);
    }

    public Grouping setGroupSort(Sort groupSort) {
        this.groupSort = groupSort;
        return this;
    }

    public Grouping setWithinGroupSort(Sort withinGroupSort) {
        this.withinGroupSort = withinGroupSort;
        return this;
    }

    public Grouping setLimitDefault(int limitDefault) {
        this.limitDefault = limitDefault;
        return this;
    }

    public Grouping setDocsPerGroupDefault(int docsPerGroupDefault) {
        this.docsPerGroupDefault = docsPerGroupDefault;
        return this;
    }

    public Grouping setGroupOffsetDefault(int groupOffsetDefault) {
        this.groupOffsetDefault = groupOffsetDefault;
        return this;
    }

    public Grouping setDefaultFormat(Format defaultFormat) {
        this.defaultFormat = defaultFormat;
        return this;
    }

    public Grouping setDefaultTotalCount(TotalCount defaultTotalCount) {
        this.defaultTotalCount = defaultTotalCount;
        return this;
    }

    public Grouping setGetGroupedDocSet(boolean getGroupedDocSet) {
        this.getGroupedDocSet = getGroupedDocSet;
        return this;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void execute() throws IOException {
        int maxDocsToCache;
        if (this.commands.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify at least one field, function or query to group by.");
        }
        DocListAndSet out = new DocListAndSet();
        this.qr.setDocListAndSet(out);
        SolrIndexSearcher.ProcessedFilter pf = this.searcher.getProcessedFilter(this.cmd.getFilter(), this.cmd.getFilterList());
        Filter luceneFilter = pf.filter;
        this.maxDoc = this.searcher.maxDoc();
        this.needScores = (this.cmd.getFlags() & 1) != 0;
        boolean cacheScores = false;
        if (!this.needScores && !this.commands.isEmpty()) {
            Sort withinGroupSort = this.commands.get((int)0).withinGroupSort;
            cacheScores = withinGroupSort == null || withinGroupSort.needsScores();
        } else if (this.needScores) {
            cacheScores = this.needScores;
        }
        this.getDocSet = (this.cmd.getFlags() & 0x40000000) != 0;
        this.getDocList = (this.cmd.getFlags() & 2) != 0;
        this.query = QueryUtils.makeQueryable(this.cmd.getQuery());
        for (Command cmd : this.commands) {
            cmd.prepare();
        }
        AllGroupHeadsCollector<?> allGroupHeadsCollector = null;
        ArrayList<Object> collectors = new ArrayList<Object>(this.commands.size());
        for (Command cmd : this.commands) {
            Collector collector = cmd.createFirstPassCollector();
            if (collector != null) {
                collectors.add(collector);
            }
            if (!this.getGroupedDocSet || allGroupHeadsCollector != null) continue;
            allGroupHeadsCollector = cmd.createAllGroupCollector();
            collectors.add(allGroupHeadsCollector);
        }
        DocSetCollector setCollector = null;
        if (this.getDocSet && allGroupHeadsCollector == null) {
            setCollector = new DocSetCollector(this.maxDoc);
            collectors.add((Object)setCollector);
        }
        Object allCollectors = MultiCollector.wrap(collectors);
        CachingCollector cachedCollector = null;
        if (this.cacheSecondPassSearch && allCollectors != null && (maxDocsToCache = (int)Math.round((double)this.maxDoc * ((double)this.maxDocsPercentageToCache / 100.0))) > 0) {
            cachedCollector = CachingCollector.create((Collector)allCollectors, (boolean)cacheScores, (int)maxDocsToCache);
            allCollectors = cachedCollector;
        }
        if (pf.postFilter != null) {
            pf.postFilter.setLastDelegate((Collector)allCollectors);
            allCollectors = pf.postFilter;
        }
        if (allCollectors != null) {
            this.searchWithTimeLimiter(luceneFilter, (Collector)allCollectors);
            if (allCollectors instanceof DelegatingCollector) {
                ((DelegatingCollector)((Object)allCollectors)).finish();
            }
        }
        if (this.getGroupedDocSet && allGroupHeadsCollector != null) {
            this.qr.setDocSet(new BitDocSet(allGroupHeadsCollector.retrieveGroupHeads(this.maxDoc)));
        } else if (this.getDocSet) {
            this.qr.setDocSet(setCollector.getDocSet());
        }
        collectors.clear();
        for (Command cmd : this.commands) {
            Collector collector = cmd.createSecondPassCollector();
            if (collector == null) continue;
            collectors.add(collector);
        }
        if (!collectors.isEmpty()) {
            Object secondPhaseCollectors = MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()]));
            if (collectors.size() > 0) {
                if (cachedCollector != null) {
                    if (cachedCollector.isCached()) {
                        cachedCollector.replay(secondPhaseCollectors);
                    } else {
                        this.signalCacheWarning = true;
                        log.warn(String.format(Locale.ROOT, "The grouping cache is active, but not used because it exceeded the max cache limit of %d percent", this.maxDocsPercentageToCache));
                        log.warn("Please increase cache size or disable group caching.");
                        this.searchWithTimeLimiter(luceneFilter, (Collector)secondPhaseCollectors);
                    }
                } else {
                    if (pf.postFilter != null) {
                        pf.postFilter.setLastDelegate((Collector)secondPhaseCollectors);
                        secondPhaseCollectors = pf.postFilter;
                    }
                    this.searchWithTimeLimiter(luceneFilter, (Collector)secondPhaseCollectors);
                }
                if (secondPhaseCollectors instanceof DelegatingCollector) {
                    ((DelegatingCollector)((Object)secondPhaseCollectors)).finish();
                }
            }
        }
        for (Command cmd : this.commands) {
            cmd.finish();
        }
        this.qr.groupedResults = this.grouped;
        if (this.getDocList) {
            int sz = this.idSet.size();
            int[] ids = new int[sz];
            int idx = 0;
            for (int val : this.idSet) {
                ids[idx++] = val;
            }
            this.qr.setDocList(new DocSlice(0, sz, ids, null, this.maxMatches, this.maxScore, TotalHits.Relation.EQUAL_TO));
        }
    }

    private void searchWithTimeLimiter(Filter luceneFilter, Collector collector) throws IOException {
        if (this.cmd.getTimeAllowed() > 0L) {
            if (this.timeLimitingCollector == null) {
                this.timeLimitingCollector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), this.cmd.getTimeAllowed());
            } else {
                this.timeLimitingCollector.setCollector(collector);
            }
            collector = this.timeLimitingCollector;
        }
        try {
            this.searcher.search(QueryUtils.combineQueryAndFilter(this.query, luceneFilter), collector);
        }
        catch (ExitableDirectoryReader.ExitingReaderException | TimeLimitingCollector.TimeExceededException x) {
            log.warn("Query: {}; ", (Object)this.query, (Object)x);
            this.qr.setPartialResults(true);
        }
    }

    public static int getMax(int offset, int len, int max) {
        int v;
        int n = v = len < 0 ? max : offset + len;
        if (v < 0 || v > max) {
            v = max;
        }
        return v;
    }

    public boolean isSignalCacheWarning() {
        return this.signalCacheWarning;
    }

    private float maxAvoidNaN(float valA, float valB) {
        if (Float.isNaN(valA) || valB > valA) {
            return valB;
        }
        return valA;
    }

    public class CommandFunc
    extends Command<MutableValue> {
        public ValueSource groupBy;
        Map context;
        FirstPassGroupingCollector<MutableValue> firstPass;
        TopGroupsCollector<MutableValue> secondPass;
        TotalHitCountCollector fallBackCollector;
        AllGroupsCollector<MutableValue> allGroupsCollector;
        Collection<SearchGroup<MutableValue>> topGroups;

        private ValueSourceGroupSelector newSelector() {
            return new ValueSourceGroupSelector(this.groupBy, this.context);
        }

        @Override
        protected void prepare() throws IOException {
            this.context = ValueSource.newContext((IndexSearcher)Grouping.this.searcher);
            this.groupBy.createWeight(this.context, (IndexSearcher)Grouping.this.searcher);
            this.actualGroupsToFind = Grouping.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
        }

        @Override
        protected Collector createFirstPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            this.groupSort = this.groupSort == null ? Sort.RELEVANCE : this.groupSort;
            this.firstPass = new FirstPassGroupingCollector((GroupSelector)this.newSelector(), Grouping.this.searcher.weightSort(this.groupSort), this.actualGroupsToFind);
            return this.firstPass;
        }

        @Override
        protected Collector createSecondPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.allGroupsCollector = new AllGroupsCollector((GroupSelector)this.newSelector());
                return this.totalCount == TotalCount.grouped ? this.allGroupsCollector : null;
            }
            Collection collection = this.topGroups = this.format == Format.grouped ? this.firstPass.getTopGroups(this.offset) : this.firstPass.getTopGroups(0);
            if (this.topGroups == null) {
                if (this.totalCount == TotalCount.grouped) {
                    this.allGroupsCollector = new AllGroupsCollector((GroupSelector)this.newSelector());
                    this.fallBackCollector = new TotalHitCountCollector();
                    return MultiCollector.wrap((Collector[])new Collector[]{this.allGroupsCollector, this.fallBackCollector});
                }
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            int groupdDocsToCollect = Grouping.getMax(this.groupOffset, this.docsPerGroup, Grouping.this.maxDoc);
            groupdDocsToCollect = Math.max(groupdDocsToCollect, 1);
            Sort withinGroupSort = this.withinGroupSort != null ? this.withinGroupSort : Sort.RELEVANCE;
            this.secondPass = new TopGroupsCollector((GroupSelector)this.newSelector(), this.topGroups, this.groupSort, withinGroupSort, groupdDocsToCollect, Grouping.this.needScores);
            if (this.totalCount == TotalCount.grouped) {
                this.allGroupsCollector = new AllGroupsCollector((GroupSelector)this.newSelector());
                return MultiCollector.wrap((Collector[])new Collector[]{this.secondPass, this.allGroupsCollector});
            }
            return this.secondPass;
        }

        @Override
        public AllGroupHeadsCollector<?> createAllGroupCollector() throws IOException {
            Sort sortWithinGroup = this.withinGroupSort != null ? this.withinGroupSort : Sort.RELEVANCE;
            return AllGroupHeadsCollector.newCollector((GroupSelector)this.newSelector(), (Sort)sortWithinGroup);
        }

        @Override
        protected void finish() throws IOException {
            if (this.secondPass != null) {
                this.result = this.secondPass.getTopGroups(0);
                this.populateScoresIfNecessary();
            }
            if (this.main) {
                Grouping.this.mainResult = this.createSimpleResponse();
                return;
            }
            NamedList groupResult = this.commonResponse();
            if (this.format == Format.simple) {
                groupResult.add("doclist", (Object)this.createSimpleResponse());
                return;
            }
            ArrayList<SimpleOrderedMap> groupList = new ArrayList<SimpleOrderedMap>();
            groupResult.add("groups", groupList);
            if (this.result == null) {
                return;
            }
            if (this.numGroups == 0) {
                return;
            }
            for (GroupDocs group : this.result.groups) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                groupList.add(nl);
                nl.add("groupValue", ((MutableValue)group.groupValue).toObject());
                this.addDocList((NamedList)nl, group);
            }
        }

        @Override
        public int getMatches() {
            if (this.result == null && this.fallBackCollector == null) {
                return 0;
            }
            return this.result != null ? this.result.totalHitCount : this.fallBackCollector.getTotalHits();
        }

        @Override
        protected Integer getNumberOfGroups() {
            return this.allGroupsCollector == null ? null : Integer.valueOf(this.allGroupsCollector.getGroupCount());
        }
    }

    public class CommandQuery
    extends Command {
        public Query query;
        TopDocsCollector topCollector;
        MaxScoreCollector maxScoreCollector;
        FilterCollector collector;

        @Override
        protected void prepare() throws IOException {
            this.actualGroupsToFind = Grouping.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
        }

        @Override
        protected Collector createFirstPassCollector() throws IOException {
            TopScoreDocCollector subCollector;
            DocSet groupFilt = Grouping.this.searcher.getDocSet(this.query);
            int groupDocsToCollect = Grouping.getMax(this.groupOffset, this.docsPerGroup, Grouping.this.maxDoc);
            if (this.withinGroupSort == null || this.withinGroupSort.equals((Object)Sort.RELEVANCE)) {
                this.topCollector = TopScoreDocCollector.create((int)groupDocsToCollect, (int)Integer.MAX_VALUE);
                subCollector = this.topCollector;
            } else {
                this.topCollector = TopFieldCollector.create((Sort)Grouping.this.searcher.weightSort(this.withinGroupSort), (int)groupDocsToCollect, (int)Integer.MAX_VALUE);
                if (Grouping.this.needScores) {
                    this.maxScoreCollector = new MaxScoreCollector();
                    subCollector = MultiCollector.wrap((Collector[])new Collector[]{this.topCollector, this.maxScoreCollector});
                } else {
                    subCollector = this.topCollector;
                }
            }
            this.collector = new FilterCollector(groupFilt, (Collector)subCollector);
            return this.collector;
        }

        @Override
        protected void finish() throws IOException {
            float maxScore;
            TopDocs topDocs = this.topCollector.topDocs();
            if (this.withinGroupSort == null || this.withinGroupSort.equals((Object)Sort.RELEVANCE)) {
                maxScore = topDocs.scoreDocs.length == 0 ? Float.NaN : topDocs.scoreDocs[0].score;
            } else if (Grouping.this.needScores) {
                TopFieldCollector.populateScores((ScoreDoc[])topDocs.scoreDocs, (IndexSearcher)Grouping.this.searcher, (Query)Grouping.this.query);
                maxScore = this.maxScoreCollector.getMaxScore();
            } else {
                maxScore = Float.NaN;
            }
            GroupDocs groupDocs = new GroupDocs(Float.NaN, maxScore, topDocs.totalHits, topDocs.scoreDocs, (Object)this.query.toString(), null);
            if (this.main) {
                Grouping.this.mainResult = this.getDocList(groupDocs);
            } else {
                NamedList rsp = this.commonResponse();
                this.addDocList(rsp, groupDocs);
            }
        }

        @Override
        public int getMatches() {
            return this.collector.getMatches();
        }
    }

    public class CommandField
    extends Command<BytesRef> {
        public String groupBy;
        FirstPassGroupingCollector<BytesRef> firstPass;
        TopGroupsCollector<BytesRef> secondPass;
        AllGroupsCollector<BytesRef> allGroupsCollector;
        TotalHitCountCollector fallBackCollector;
        Collection<SearchGroup<BytesRef>> topGroups;

        @Override
        protected void prepare() throws IOException {
            this.actualGroupsToFind = Grouping.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
        }

        @Override
        protected Collector createFirstPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            this.groupSort = this.groupSort == null ? Sort.RELEVANCE : this.groupSort;
            this.firstPass = new FirstPassGroupingCollector((GroupSelector)new TermGroupSelector(this.groupBy), this.groupSort, this.actualGroupsToFind);
            return this.firstPass;
        }

        @Override
        protected Collector createSecondPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.allGroupsCollector = new AllGroupsCollector((GroupSelector)new TermGroupSelector(this.groupBy));
                return this.totalCount == TotalCount.grouped ? this.allGroupsCollector : null;
            }
            Collection collection = this.topGroups = this.format == Format.grouped ? this.firstPass.getTopGroups(this.offset) : this.firstPass.getTopGroups(0);
            if (this.topGroups == null) {
                if (this.totalCount == TotalCount.grouped) {
                    this.allGroupsCollector = new AllGroupsCollector((GroupSelector)new TermGroupSelector(this.groupBy));
                    this.fallBackCollector = new TotalHitCountCollector();
                    return MultiCollector.wrap((Collector[])new Collector[]{this.allGroupsCollector, this.fallBackCollector});
                }
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            int groupedDocsToCollect = Grouping.getMax(this.groupOffset, this.docsPerGroup, Grouping.this.maxDoc);
            groupedDocsToCollect = Math.max(groupedDocsToCollect, 1);
            Sort withinGroupSort = this.withinGroupSort != null ? this.withinGroupSort : Sort.RELEVANCE;
            this.secondPass = new TopGroupsCollector((GroupSelector)new TermGroupSelector(this.groupBy), this.topGroups, this.groupSort, withinGroupSort, groupedDocsToCollect, Grouping.this.needScores);
            if (this.totalCount == TotalCount.grouped) {
                this.allGroupsCollector = new AllGroupsCollector((GroupSelector)new TermGroupSelector(this.groupBy));
                return MultiCollector.wrap((Collector[])new Collector[]{this.secondPass, this.allGroupsCollector});
            }
            return this.secondPass;
        }

        @Override
        public AllGroupHeadsCollector<?> createAllGroupCollector() throws IOException {
            Sort sortWithinGroup = this.withinGroupSort != null ? this.withinGroupSort : Sort.RELEVANCE;
            return AllGroupHeadsCollector.newCollector((GroupSelector)new TermGroupSelector(this.groupBy), (Sort)sortWithinGroup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void finish() throws IOException {
            if (this.secondPass != null) {
                this.result = this.secondPass.getTopGroups(0);
                this.populateScoresIfNecessary();
            }
            if (this.main) {
                Grouping.this.mainResult = this.createSimpleResponse();
                return;
            }
            NamedList groupResult = this.commonResponse();
            if (this.format == Format.simple) {
                groupResult.add("doclist", (Object)this.createSimpleResponse());
                return;
            }
            ArrayList<SimpleOrderedMap> groupList = new ArrayList<SimpleOrderedMap>();
            groupResult.add("groups", groupList);
            if (this.result == null) {
                return;
            }
            if (this.numGroups == 0) {
                return;
            }
            for (GroupDocs group : this.result.groups) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                groupList.add(nl);
                if (group.groupValue != null) {
                    SchemaField schemaField = Grouping.this.searcher.getSchema().getField(this.groupBy);
                    FieldType fieldType = schemaField.getType();
                    List<IndexableField> fields = schemaField.createFields(((BytesRef)group.groupValue).utf8ToString());
                    if (!CollectionUtils.isNotEmpty(fields)) throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Couldn't create schema field for grouping, group value: " + ((BytesRef)group.groupValue).utf8ToString() + ", field: " + schemaField);
                    nl.add("groupValue", fieldType.toObject(fields.get(0)));
                } else {
                    nl.add("groupValue", null);
                }
                this.addDocList((NamedList)nl, group);
            }
        }

        @Override
        public int getMatches() {
            if (this.result == null && this.fallBackCollector == null) {
                return 0;
            }
            return this.result != null ? this.result.totalHitCount : this.fallBackCollector.getTotalHits();
        }

        @Override
        protected Integer getNumberOfGroups() {
            return this.allGroupsCollector == null ? null : Integer.valueOf(this.allGroupsCollector.getGroupCount());
        }
    }

    public abstract class Command<T> {
        public String key;
        public Sort withinGroupSort;
        public Sort groupSort;
        public int docsPerGroup;
        public int groupOffset;
        public int numGroups;
        int actualGroupsToFind;
        public int offset;
        public Format format;
        public boolean main;
        public TotalCount totalCount = TotalCount.ungrouped;
        TopGroups<T> result;

        protected abstract void prepare() throws IOException;

        protected abstract Collector createFirstPassCollector() throws IOException;

        protected Collector createSecondPassCollector() throws IOException {
            return null;
        }

        public AllGroupHeadsCollector<?> createAllGroupCollector() throws IOException {
            return null;
        }

        protected abstract void finish() throws IOException;

        public abstract int getMatches();

        protected Integer getNumberOfGroups() {
            return null;
        }

        protected void populateScoresIfNecessary() throws IOException {
            if (Grouping.this.needScores) {
                for (GroupDocs groups : this.result.groups) {
                    TopFieldCollector.populateScores((ScoreDoc[])groups.scoreDocs, (IndexSearcher)Grouping.this.searcher, (Query)Grouping.this.query);
                }
            }
        }

        protected NamedList commonResponse() {
            SimpleOrderedMap groupResult = new SimpleOrderedMap();
            Grouping.this.grouped.add(this.key, (Object)groupResult);
            int matches = this.getMatches();
            groupResult.add("matches", (Object)matches);
            if (this.totalCount == TotalCount.grouped) {
                Integer totalNrOfGroups = this.getNumberOfGroups();
                groupResult.add("ngroups", (Object)(totalNrOfGroups == null ? Integer.valueOf(0) : totalNrOfGroups));
            }
            Grouping.this.maxMatches = Math.max(Grouping.this.maxMatches, matches);
            return groupResult;
        }

        protected DocList getDocList(GroupDocs groups) {
            assert (groups.totalHits.relation == TotalHits.Relation.EQUAL_TO);
            int max = Math.toIntExact(groups.totalHits.value);
            int off = this.groupOffset;
            int len = this.docsPerGroup;
            if (this.format == Format.simple) {
                off = this.offset;
                len = this.numGroups;
            }
            int docsToCollect = Grouping.getMax(off, len, max);
            int docsCollected = Math.min(docsToCollect, groups.scoreDocs.length);
            int[] ids = new int[docsCollected];
            float[] scores = Grouping.this.needScores ? new float[docsCollected] : null;
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = groups.scoreDocs[i].doc;
                if (scores == null) continue;
                scores[i] = groups.scoreDocs[i].score;
            }
            float score = groups.maxScore;
            Grouping.this.maxScore = Grouping.this.maxAvoidNaN(score, Grouping.this.maxScore);
            DocSlice docs = new DocSlice(off, Math.max(0, ids.length - off), ids, scores, groups.totalHits.value, score, TotalHits.Relation.EQUAL_TO);
            if (Grouping.this.getDocList) {
                DocIterator iter = docs.iterator();
                while (iter.hasNext()) {
                    Grouping.this.idSet.add(iter.nextDoc());
                }
            }
            return docs;
        }

        protected void addDocList(NamedList rsp, GroupDocs groups) {
            rsp.add("doclist", (Object)this.getDocList(groups));
        }

        protected DocList createSimpleResponse() {
            GroupDocs[] groups = this.result != null ? this.result.groups : new GroupDocs[]{};
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ArrayList<Float> scores = new ArrayList<Float>();
            int docsToGather = Grouping.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
            int docsGathered = 0;
            float maxScore = Float.NaN;
            block0: for (GroupDocs group : groups) {
                maxScore = Grouping.this.maxAvoidNaN(maxScore, group.maxScore);
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    if (docsGathered >= docsToGather) break block0;
                    ids.add(scoreDoc.doc);
                    scores.add(Float.valueOf(scoreDoc.score));
                    ++docsGathered;
                }
            }
            int len = docsGathered > this.offset ? docsGathered - this.offset : 0;
            int[] docs = ArrayUtils.toPrimitive((Integer[])ids.toArray(new Integer[ids.size()]));
            float[] docScores = ArrayUtils.toPrimitive((Float[])scores.toArray(new Float[scores.size()]));
            DocSlice docSlice = new DocSlice(this.offset, len, docs, docScores, this.getMatches(), maxScore, TotalHits.Relation.EQUAL_TO);
            if (Grouping.this.getDocList) {
                for (int i = this.offset; i < docs.length; ++i) {
                    Grouping.this.idSet.add(docs[i]);
                }
            }
            return docSlice;
        }
    }

    public static enum TotalCount {
        grouped,
        ungrouped;

    }

    public static enum Format {
        grouped,
        simple;

    }
}

