/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.DistribPackageStore;
import org.apache.solr.filestore.PackageStore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.CryptoKeys;
import org.apache.solr.util.SimplePostTool;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageStoreAPI {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PACKAGESTORE_DIRECTORY = "filestore";
    public static final String TRUSTED_DIR = "_trusted_";
    public static final String KEYS_DIR = "/_trusted_/keys";
    private final CoreContainer coreContainer;
    PackageStore packageStore;
    public final FSRead readAPI = new FSRead();
    public final FSWrite writeAPI = new FSWrite();
    static final String INVALIDCHARS = " /\\#&*\n\t%@~`=+^$><?{}[]|:;!";

    public PackageStoreAPI(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.packageStore = new DistribPackageStore(coreContainer);
    }

    public PackageStore getPackageStore() {
        return this.packageStore;
    }

    public ArrayList<String> shuffledNodes() {
        Set liveNodes = this.coreContainer.getZkController().getZkStateReader().getClusterState().getLiveNodes();
        ArrayList<String> l = new ArrayList<String>(liveNodes);
        l.remove(this.coreContainer.getZkController().getNodeName());
        Collections.shuffle(l, BlobRepository.RANDOM);
        return l;
    }

    public void validateFiles(List<String> files, boolean validateSignatures, Consumer<String> errs) {
        for (String path : files) {
            try {
                PackageStore.FileType type = this.packageStore.getType(path, true);
                if (type != PackageStore.FileType.FILE) {
                    errs.accept("No such file: " + path);
                    continue;
                }
                this.packageStore.get(path, entry -> {
                    if (entry.getMetaData().signatures == null || entry.getMetaData().signatures.isEmpty()) {
                        errs.accept(path + " has no signature");
                        return;
                    }
                    if (validateSignatures) {
                        try {
                            this.packageStore.refresh(KEYS_DIR);
                            this.validate(entry.meta.signatures, (PackageStore.FileEntry)entry, false);
                        }
                        catch (Exception e) {
                            log.error("Error validating package artifact", (Throwable)e);
                            errs.accept(e.getMessage());
                        }
                    }
                }, false);
            }
            catch (Exception e) {
                log.error("Error reading file ", (Throwable)e);
                errs.accept("Error reading file " + path + " " + e.getMessage());
            }
        }
    }

    public static MetaData _createJsonMetaData(ByteBuffer buf, List<String> signatures) throws IOException {
        String sha512 = DigestUtils.sha512Hex((InputStream)new ByteBufferInputStream(buf));
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put("sha512", sha512);
        if (signatures != null) {
            vals.put("sig", signatures);
        }
        return new MetaData(vals);
    }

    public static void validateName(String path, boolean failForTrusted) {
        if (path == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "empty path");
        }
        List parts = StrUtils.splitSmart((String)path, (char)'/', (boolean)true);
        for (String part : parts) {
            if (part.charAt(0) == '.') {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cannot start with period");
            }
            for (int i = 0; i < part.length(); ++i) {
                for (int j = 0; j < INVALIDCHARS.length(); ++j) {
                    if (part.charAt(i) != INVALIDCHARS.charAt(j)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported char in file name: " + part);
                }
            }
        }
        if (failForTrusted && TRUSTED_DIR.equals(parts.get(0))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "trying to write into /_trusted_/ directory");
        }
    }

    public void validate(List<String> sigs, PackageStore.FileEntry entry, boolean isFirstAttempt) throws SolrException, IOException {
        Map<String, byte[]> keys;
        if (!isFirstAttempt) {
            this.packageStore.refresh(KEYS_DIR);
        }
        if ((keys = this.packageStore.getKeys()) == null || keys.isEmpty()) {
            if (isFirstAttempt) {
                this.validate(sigs, entry, false);
                return;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Packagestore does not have any public keys");
        }
        CryptoKeys cryptoKeys = null;
        try {
            cryptoKeys = new CryptoKeys(keys);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing public keys in ZooKeeper");
        }
        for (String sig : sigs) {
            Supplier<String> errMsg = () -> "Signature does not match any public key : " + sig + "sha256 " + entry.getMetaData().sha512;
            if (entry.getBuffer() != null) {
                if (cryptoKeys.verify(sig, entry.getBuffer()) != null) continue;
                if (isFirstAttempt) {
                    this.validate(sigs, entry, false);
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, errMsg.get());
            }
            InputStream inputStream = entry.getInputStream();
            if (cryptoKeys.verify(sig, inputStream) != null) continue;
            if (isFirstAttempt) {
                this.validate(sigs, entry, false);
                return;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, errMsg.get());
        }
    }

    public static class MetaData
    implements MapWriter {
        public static final String SHA512 = "sha512";
        String sha512;
        List<String> signatures;
        Map<String, Object> otherAttribs;

        public MetaData(Map m) {
            m = Utils.getDeepCopy((Map)m, (int)3);
            this.sha512 = (String)m.remove(SHA512);
            this.signatures = (List)m.remove("sig");
            this.otherAttribs = m;
        }

        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.putIfNotNull((CharSequence)SHA512, (Object)this.sha512);
            ew.putIfNotNull((CharSequence)"sig", this.signatures);
            if (!this.otherAttribs.isEmpty()) {
                this.otherAttribs.forEach(ew.getBiConsumer());
            }
        }
    }

    public class FSRead {
        @EndPoint(path={"/node/files/*"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.FILESTORE_READ_PERM)
        public void read(SolrQueryRequest req, SolrQueryResponse rsp) {
            PackageStore.FileType typ;
            String path;
            String pathCopy = path = req.getPathTemplateValues().get("*");
            if (req.getParams().getBool("sync", false)) {
                try {
                    PackageStoreAPI.this.packageStore.syncToAllNodes(path);
                    return;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error getting file ", (Throwable)e);
                }
            }
            String getFrom = req.getParams().get("getFrom");
            if (getFrom != null) {
                PackageStoreAPI.this.coreContainer.getUpdateShardHandler().getUpdateExecutor().submit(() -> {
                    log.debug("Downloading file {}", (Object)pathCopy);
                    try {
                        PackageStoreAPI.this.packageStore.fetch(pathCopy, getFrom);
                    }
                    catch (Exception e) {
                        log.error("Failed to download file: {}", (Object)pathCopy, (Object)e);
                    }
                    log.info("downloaded file: {}", (Object)pathCopy);
                });
                return;
            }
            if (path == null) {
                path = "";
            }
            if ((typ = PackageStoreAPI.this.packageStore.getType(path, false)) == PackageStore.FileType.NOFILE) {
                rsp.add("files", Collections.singletonMap(path, null));
                return;
            }
            if (typ == PackageStore.FileType.DIRECTORY) {
                rsp.add("files", Collections.singletonMap(path, PackageStoreAPI.this.packageStore.list(path, null)));
                return;
            }
            if (req.getParams().getBool("meta", false)) {
                if (typ == PackageStore.FileType.FILE) {
                    int idx = path.lastIndexOf(47);
                    String fileName = path.substring(idx + 1);
                    String parentPath = path.substring(0, path.lastIndexOf(47));
                    List<PackageStore.FileDetails> l = PackageStoreAPI.this.packageStore.list(parentPath, s -> s.equals(fileName));
                    rsp.add("files", Collections.singletonMap(path, l.isEmpty() ? null : l.get(0)));
                    return;
                }
            } else {
                this.writeRawFile(req, rsp, path);
            }
        }

        private void writeRawFile(SolrQueryRequest req, SolrQueryResponse rsp, String path) {
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.add("wt", new String[]{"filestream"});
            req.setParams(SolrParams.wrapDefaults((SolrParams)solrParams, (SolrParams)req.getParams()));
            rsp.add("filestream", os -> PackageStoreAPI.this.packageStore.get(path, it -> {
                try {
                    IOUtils.copy((InputStream)it.getInputStream(), (OutputStream)os);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading file" + path);
                }
            }, false));
        }
    }

    public class FSWrite {
        static final String TMP_ZK_NODE = "/packageStoreWriteInProgress";

        @EndPoint(path={"/cluster/files/*"}, method={SolrRequest.METHOD.DELETE}, permission=PermissionNameProvider.Name.FILESTORE_WRITE_PERM)
        public void delete(SolrQueryRequest req, SolrQueryResponse rsp) {
            if (!PackageStoreAPI.this.coreContainer.getPackageLoader().getPackageAPI().isEnabled()) {
                throw new RuntimeException("Package loading is not enabled , Start your nodes with -Denable.packages=true");
            }
            try {
                PackageStoreAPI.this.coreContainer.getZkController().getZkClient().create(TMP_ZK_NODE, "true".getBytes(StandardCharsets.UTF_8), CreateMode.EPHEMERAL, true);
                String path = req.getPathTemplateValues().get("*");
                PackageStoreAPI.validateName(path, true);
                if (PackageStoreAPI.this.coreContainer.getPackageLoader().getPackageAPI().isJarInuse(path)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "jar in use, can't delete");
                }
                PackageStore.FileType type = PackageStoreAPI.this.packageStore.getType(path, true);
                if (type == PackageStore.FileType.NOFILE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path does not exist: " + path);
                }
                PackageStoreAPI.this.packageStore.delete(path);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Unknown error", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            finally {
                try {
                    PackageStoreAPI.this.coreContainer.getZkController().getZkClient().delete(TMP_ZK_NODE, -1, true);
                }
                catch (Exception e) {
                    log.error("Unexpected error  ", (Throwable)e);
                }
            }
        }

        @EndPoint(path={"/node/files/*"}, method={SolrRequest.METHOD.DELETE}, permission=PermissionNameProvider.Name.FILESTORE_WRITE_PERM)
        public void deleteLocal(SolrQueryRequest req, SolrQueryResponse rsp) {
            String path = req.getPathTemplateValues().get("*");
            PackageStoreAPI.validateName(path, true);
            PackageStoreAPI.this.packageStore.deleteLocal(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EndPoint(path={"/cluster/files/*"}, method={SolrRequest.METHOD.PUT}, permission=PermissionNameProvider.Name.FILESTORE_WRITE_PERM)
        public void upload(SolrQueryRequest req, SolrQueryResponse rsp) {
            if (!PackageStoreAPI.this.coreContainer.getPackageLoader().getPackageAPI().isEnabled()) {
                throw new RuntimeException("Package loading is not enabled , Start your nodes with -Denable.packages=true");
            }
            try {
                PackageStoreAPI.this.coreContainer.getZkController().getZkClient().create(TMP_ZK_NODE, "true".getBytes(StandardCharsets.UTF_8), CreateMode.EPHEMERAL, true);
                Iterable<ContentStream> streams = req.getContentStreams();
                if (streams == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no payload");
                }
                String path = req.getPathTemplateValues().get("*");
                if (path == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No path");
                }
                PackageStoreAPI.validateName(path, true);
                ContentStream stream = streams.iterator().next();
                try {
                    ByteBuffer buf = SimplePostTool.inputStreamToByteArray(stream.getStream());
                    List<String> signatures = this.readSignatures(req, buf);
                    MetaData meta = PackageStoreAPI._createJsonMetaData(buf, signatures);
                    PackageStore.FileType type = PackageStoreAPI.this.packageStore.getType(path, true);
                    if (type != PackageStore.FileType.NOFILE) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path already exists " + path);
                    }
                    PackageStoreAPI.this.packageStore.put(new PackageStore.FileEntry(buf, meta, path));
                    rsp.add("file", path);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                log.error("Unexpected error", (Throwable)e);
            }
            catch (KeeperException.NodeExistsException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A write is already in process , try later");
            }
            catch (KeeperException e) {
                log.error("Unexpected error", (Throwable)e);
            }
            finally {
                try {
                    PackageStoreAPI.this.coreContainer.getZkController().getZkClient().delete(TMP_ZK_NODE, -1, true);
                }
                catch (Exception e) {
                    log.error("Unexpected error  ", (Throwable)e);
                }
            }
        }

        private List<String> readSignatures(SolrQueryRequest req, ByteBuffer buf) throws SolrException, IOException {
            String[] signatures = req.getParams().getParams("sig");
            if (signatures == null || signatures.length == 0) {
                return null;
            }
            List<String> sigs = Arrays.asList(signatures);
            PackageStoreAPI.this.packageStore.refresh(PackageStoreAPI.KEYS_DIR);
            this.validate(sigs, buf);
            return sigs;
        }

        private void validate(List<String> sigs, ByteBuffer buf) throws SolrException, IOException {
            Map<String, byte[]> keys = PackageStoreAPI.this.packageStore.getKeys();
            if (keys == null || keys.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "package store does not have any keys");
            }
            CryptoKeys cryptoKeys = null;
            try {
                cryptoKeys = new CryptoKeys(keys);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing public keys in Package store");
            }
            for (String sig : sigs) {
                if (cryptoKeys.verify(sig, buf) != null) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Signature does not match any public key : " + sig + " len: " + buf.limit() + " content sha512: " + DigestUtils.sha512Hex((InputStream)new ByteBufferInputStream(buf)));
            }
        }
    }
}

