/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrRequestParsers;

public class EmbeddedSolrServer
extends SolrClient {
    protected final CoreContainer coreContainer;
    protected final String coreName;
    private final SolrRequestParsers _parser;
    private final RequestWriterSupplier supplier;
    private boolean containerIsLocal = false;

    public EmbeddedSolrServer(Path solrHome, String defaultCoreName) {
        this(EmbeddedSolrServer.load(new CoreContainer(solrHome, new Properties())), defaultCoreName);
        this.containerIsLocal = true;
    }

    public EmbeddedSolrServer(NodeConfig nodeConfig, String defaultCoreName) {
        this(EmbeddedSolrServer.load(new CoreContainer(nodeConfig)), defaultCoreName);
        this.containerIsLocal = true;
    }

    private static CoreContainer load(CoreContainer cc) {
        cc.load();
        return cc;
    }

    public EmbeddedSolrServer(SolrCore core) {
        this(core.getCoreContainer(), core.getName());
    }

    public EmbeddedSolrServer(CoreContainer coreContainer, String coreName) {
        this(coreContainer, coreName, RequestWriterSupplier.JavaBin);
    }

    public EmbeddedSolrServer(CoreContainer coreContainer, String coreName, RequestWriterSupplier supplier) {
        if (coreContainer == null) {
            throw new NullPointerException("CoreContainer instance required");
        }
        this.coreContainer = coreContainer;
        this.coreName = coreName;
        this._parser = new SolrRequestParsers(null);
        this.supplier = supplier;
    }

    /*
     * Exception decompiling
     */
    public NamedList<Object> request(SolrRequest request, String coreName) throws SolrServerException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<ContentStream> getContentStreams(SolrRequest request) throws IOException {
        String cType;
        ContentStreamUpdateRequest csur;
        Collection cs;
        if (request.getMethod() == SolrRequest.METHOD.GET) {
            return null;
        }
        if (request instanceof ContentStreamUpdateRequest && (cs = (csur = (ContentStreamUpdateRequest)request).getContentStreams()) != null) {
            return new HashSet<ContentStream>(cs);
        }
        RequestWriter.ContentWriter contentWriter = request.getContentWriter(null);
        BinaryRequestWriter.BAOS baos = new BinaryRequestWriter.BAOS();
        if (contentWriter != null) {
            contentWriter.write((OutputStream)baos);
            cType = contentWriter.getContentType();
        } else {
            RequestWriter rw = this.supplier.newRequestWriter();
            cType = rw.getUpdateContentType();
            rw.write(request, (OutputStream)baos);
        }
        final byte[] buf = baos.toByteArray();
        if (buf.length > 0) {
            return Collections.singleton(new ContentStreamBase(){

                public InputStream getStream() throws IOException {
                    return new ByteArrayInputStream(buf);
                }

                public String getContentType() {
                    return cType;
                }
            });
        }
        return null;
    }

    private JavaBinCodec createJavaBinCodec(final StreamingResponseCallback callback, BinaryResponseWriter.Resolver resolver) {
        return new JavaBinCodec(resolver){

            public void writeSolrDocument(SolrDocument doc) {
                callback.streamSolrDocument(doc);
            }

            public void writeSolrDocumentList(SolrDocumentList docs) throws IOException {
                if (docs.size() > 0) {
                    SolrDocumentList tmp = new SolrDocumentList();
                    tmp.setMaxScore(docs.getMaxScore());
                    tmp.setNumFound(docs.getNumFound());
                    tmp.setStart(docs.getStart());
                    docs = tmp;
                }
                callback.streamDocListInfo(docs.getNumFound(), docs.getStart(), docs.getMaxScore());
                super.writeSolrDocumentList(docs);
            }
        };
    }

    private static void checkForExceptions(SolrQueryResponse rsp) throws Exception {
        if (rsp.getException() != null) {
            if (rsp.getException() instanceof SolrException) {
                throw rsp.getException();
            }
            throw new SolrServerException((Throwable)rsp.getException());
        }
    }

    public void close() throws IOException {
        if (this.containerIsLocal) {
            this.coreContainer.shutdown();
        }
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public static enum RequestWriterSupplier {
        JavaBin(() -> new BinaryRequestWriter()),
        XML(() -> new RequestWriter());

        private Supplier<RequestWriter> supplier;

        private RequestWriterSupplier(Supplier<RequestWriter> supplier) {
            this.supplier = supplier;
        }

        public RequestWriter newRequestWriter() {
            return this.supplier.get();
        }
    }
}

