/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ConstructorException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Parameter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ParameterFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ParameterMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Signature;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.SignatureBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.UnionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

class SignatureScanner {
    private final SignatureBuilder builder;
    private final ParameterFactory factory;
    private final ParameterMap registry;
    private final Constructor constructor;
    private final Class type;

    public SignatureScanner(Constructor constructor, ParameterMap parameterMap, Support support) {
        this.builder = new SignatureBuilder(constructor);
        this.factory = new ParameterFactory(support);
        this.type = constructor.getDeclaringClass();
        this.constructor = constructor;
        this.registry = parameterMap;
        this.scan(this.type);
    }

    public boolean isValid() {
        return this.builder.isValid();
    }

    public List getSignatures() {
        return this.builder.build();
    }

    private void scan(Class clazz) {
        Class<?>[] classArray = this.constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            this.scan(classArray[i], i);
        }
    }

    private void scan(Class clazz, int n) {
        Annotation[][] annotationArray = this.constructor.getParameterAnnotations();
        for (int i = 0; i < annotationArray[n].length; ++i) {
            List list = this.process(annotationArray[n][i], n);
            for (Parameter parameter : list) {
                this.builder.insert(parameter, n);
            }
        }
    }

    private List process(Annotation annotation, int n) {
        if (annotation instanceof Attribute) {
            return this.create(annotation, n);
        }
        if (annotation instanceof Element) {
            return this.create(annotation, n);
        }
        if (annotation instanceof ElementList) {
            return this.create(annotation, n);
        }
        if (annotation instanceof ElementArray) {
            return this.create(annotation, n);
        }
        if (annotation instanceof ElementMap) {
            return this.create(annotation, n);
        }
        if (annotation instanceof ElementListUnion) {
            return this.union(annotation, n);
        }
        if (annotation instanceof ElementMapUnion) {
            return this.union(annotation, n);
        }
        if (annotation instanceof ElementUnion) {
            return this.union(annotation, n);
        }
        if (annotation instanceof Text) {
            return this.create(annotation, n);
        }
        return Collections.emptyList();
    }

    private List union(Annotation annotation, int n) {
        Annotation[] annotationArray;
        Signature signature = new Signature(this.constructor);
        for (Annotation annotation2 : annotationArray = this.extract(annotation)) {
            Parameter parameter = this.factory.getInstance(this.constructor, annotation, annotation2, n);
            String string = parameter.getPath();
            if (signature.contains(string)) {
                throw new UnionException("Annotation name '%s' used more than once in %s for %s", string, annotation, this.type);
            }
            signature.set(string, parameter);
            this.register(parameter);
        }
        return signature.getAll();
    }

    private List create(Annotation annotation, int n) {
        Parameter parameter = this.factory.getInstance(this.constructor, annotation, n);
        if (parameter != null) {
            this.register(parameter);
        }
        return Collections.singletonList(parameter);
    }

    private Annotation[] extract(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != 1) {
            throw new UnionException("Annotation '%s' is not a valid union for %s", annotation, this.type);
        }
        Method method = methodArray[0];
        Object object = method.invoke((Object)annotation, new Object[0]);
        return (Annotation[])object;
    }

    private void register(Parameter parameter) {
        String string = parameter.getPath();
        Object object = parameter.getKey();
        if (this.registry.containsKey(object)) {
            this.validate(parameter, object);
        }
        if (this.registry.containsKey(string)) {
            this.validate(parameter, string);
        }
        this.registry.put(string, parameter);
        this.registry.put(object, parameter);
    }

    private void validate(Parameter parameter, Object object) {
        Parameter parameter2 = (Parameter)this.registry.get(object);
        if (parameter.isText() != parameter2.isText()) {
            Annotation annotation = parameter.getAnnotation();
            Annotation annotation2 = parameter2.getAnnotation();
            String string = parameter.getPath();
            if (!((Object)annotation).equals(annotation2)) {
                throw new ConstructorException("Annotations do not match for '%s' in %s", string, this.type);
            }
            Class clazz = parameter2.getType();
            if (clazz != parameter.getType()) {
                throw new ConstructorException("Parameter types do not match for '%s' in %s", string, this.type);
            }
        }
    }
}

