/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.WriterOutputStream;
import com.carrotsearch.ant.tasks.junit4.events.BootstrapEvent;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.IStreamEvent;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ForkedJvmInfo {
    public final int id;
    public final int slaves;
    private BootstrapEvent bootstrapEvent;
    long start;
    long end;
    ArrayList testSuites;
    String slaveCommandLine;
    Throwable executionError;

    public ForkedJvmInfo(int n, int n2) {
        this.id = n;
        this.slaves = n2;
    }

    public Charset getCharset() {
        if (this.bootstrapEvent != null) {
            return Charset.forName(this.bootstrapEvent.getDefaultCharsetName());
        }
        return Charset.defaultCharset();
    }

    public Map getSystemProperties() {
        if (this.bootstrapEvent == null) {
            throw new RuntimeException("Bootstrap event not yet received.");
        }
        return this.bootstrapEvent.getSystemProperties();
    }

    public String getPidString() {
        BootstrapEvent bootstrapEvent = this.bootstrapEvent;
        if (bootstrapEvent == null) {
            return "(?)";
        }
        return bootstrapEvent.getPidString();
    }

    public String getCommandLine() {
        return this.slaveCommandLine;
    }

    public String getJvmName() {
        return (String)this.getSystemProperties().get("java.vm.name") + ", " + (String)this.getSystemProperties().get("java.vm.version");
    }

    long getExecutionTime() {
        return this.end - this.start;
    }

    void setBootstrapEvent(BootstrapEvent bootstrapEvent) {
        this.bootstrapEvent = bootstrapEvent;
    }

    public void decodeStreams(List list, Writer writer, Writer writer2) {
        int n = 160;
        WriterOutputStream writerOutputStream = new WriterOutputStream(writer, this.getCharset(), n, true);
        WriterOutputStream writerOutputStream2 = new WriterOutputStream(writer2, this.getCharset(), n, true);
        for (IEvent iEvent : list) {
            switch (iEvent.getType()) {
                case APPEND_STDOUT: {
                    if (writer == null) break;
                    ((IStreamEvent)((Object)iEvent)).copyTo(writerOutputStream);
                    break;
                }
                case APPEND_STDERR: {
                    if (writer2 == null) break;
                    ((IStreamEvent)((Object)iEvent)).copyTo(writerOutputStream2);
                    break;
                }
            }
        }
        writerOutputStream.flush();
        writerOutputStream2.flush();
    }

    public void serialize(JsonWriter jsonWriter) {
        jsonWriter.beginObject();
        jsonWriter.name("id").value(this.id);
        jsonWriter.name("jvmName").value(this.getJvmName());
        jsonWriter.name("charset").value(this.getCharset().displayName(Locale.ROOT));
        jsonWriter.name("commandLine").value(this.getCommandLine());
        jsonWriter.name("systemProperties").beginObject();
        for (Map.Entry entry : this.getSystemProperties().entrySet()) {
            jsonWriter.name((String)entry.getKey()).value((String)entry.getValue());
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }
}

