/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.InputStreamSource;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;

public class PDFXrefStreamParser
extends BaseParser {
    private final COSStream stream;
    private final XrefTrailerResolver xrefTrailerResolver;

    public PDFXrefStreamParser(COSStream stream, COSDocument document, XrefTrailerResolver resolver) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
        this.stream = stream;
        this.document = document;
        this.xrefTrailerResolver = resolver;
    }

    public void parse() throws IOException {
        COSArray wArray = this.stream.getCOSArray(COSName.W);
        if (wArray == null) {
            throw new IOException("/W array is missing in Xref stream");
        }
        COSArray indexArray = this.stream.getCOSArray(COSName.INDEX);
        if (indexArray == null) {
            indexArray = new COSArray();
            indexArray.add(COSInteger.ZERO);
            indexArray.add(COSInteger.get(this.stream.getInt(COSName.SIZE, 0)));
        }
        ArrayList<Long> objNums = new ArrayList<Long>();
        Iterator<COSBase> indexIter = indexArray.iterator();
        while (indexIter.hasNext()) {
            COSBase base = indexIter.next();
            if (!(base instanceof COSInteger)) {
                throw new IOException("Xref stream must have integer in /Index array");
            }
            long objID = ((COSInteger)base).longValue();
            if (!indexIter.hasNext()) break;
            base = indexIter.next();
            if (!(base instanceof COSInteger)) {
                throw new IOException("Xref stream must have integer in /Index array");
            }
            int size = ((COSInteger)base).intValue();
            for (int i = 0; i < size; ++i) {
                objNums.add(objID + (long)i);
            }
        }
        Iterator objIter = objNums.iterator();
        int w0 = wArray.getInt(0, 0);
        int w1 = wArray.getInt(1, 0);
        int w2 = wArray.getInt(2, 0);
        int lineSize = w0 + w1 + w2;
        while (!this.seqSource.isEOF() && objIter.hasNext()) {
            int type;
            byte[] currLine = new byte[lineSize];
            this.seqSource.read(currLine);
            if (w0 == 0) {
                type = 1;
            } else {
                type = 0;
                for (int i = 0; i < w0; ++i) {
                    type += (currLine[i] & 0xFF) << (w0 - i - 1) * 8;
                }
            }
            Long objID = (Long)objIter.next();
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    int offset = 0;
                    for (int i = 0; i < w1; ++i) {
                        offset += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                    }
                    int genNum = 0;
                    for (int i = 0; i < w2; ++i) {
                        genNum += (currLine[i + w0 + w1] & 0xFF) << (w2 - i - 1) * 8;
                    }
                    COSObjectKey objKey = new COSObjectKey(objID, genNum);
                    this.xrefTrailerResolver.setXRef(objKey, offset);
                    break;
                }
                case 2: {
                    int objstmObjNr = 0;
                    for (int i = 0; i < w1; ++i) {
                        objstmObjNr += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                    }
                    COSObjectKey objKey = new COSObjectKey(objID, 0);
                    this.xrefTrailerResolver.setXRef(objKey, -objstmObjNr);
                    break;
                }
            }
        }
    }
}

