/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldStreamDataSource
extends DataSource<InputStream> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected VariableResolver vr;
    protected String dataField;
    private EntityProcessorWrapper wrapper;

    @Override
    public void init(Context context, Properties initProps) {
        this.dataField = context.getEntityAttribute("dataField");
        this.wrapper = (EntityProcessorWrapper)context.getEntityProcessor();
    }

    @Override
    public InputStream getData(String query) {
        Object o = this.wrapper.getVariableResolver().resolve(this.dataField);
        if (o == null) {
            throw new DataImportHandlerException(500, "No field available for name : " + this.dataField);
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            try {
                return blob.getBinaryStream();
            }
            catch (SQLException sqle) {
                log.info("Unable to get data from BLOB");
                return null;
            }
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return new ByteArrayInputStream(bytes);
        }
        throw new RuntimeException("unsupported type : " + o.getClass());
    }

    @Override
    public void close() {
    }
}

