/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class BooleanStreamReplaceFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final BooleanValueStream baseExpr;
    private final BooleanValue compExpr;
    private final BooleanValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public BooleanStreamReplaceFunction(BooleanValueStream baseExpr, BooleanValue compExpr, BooleanValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        boolean compValue = this.compExpr.getBoolean();
        if (this.compExpr.exists()) {
            boolean fillValue = this.fillExpr.getBoolean();
            boolean fillExists = this.fillExpr.exists();
            this.baseExpr.streamBooleans(value -> {
                if (value == compValue) {
                    if (fillExists) {
                        cons.accept(fillValue);
                    }
                } else {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamBooleans(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

