/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;

class SolrProject
extends Project
implements SolrRel {
    SolrProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (this.getConvention() == SolrRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new SolrProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        SolrRules.RexToSolrTranslator translator = new SolrRules.RexToSolrTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), SolrRules.solrFieldNames(this.getInput().getRowType()));
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String expr = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            implementor.addFieldMapping(name, expr, false);
        }
    }
}

