/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Path;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Root;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.EmptyExpression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathParser;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Reflector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Format;
import java.lang.annotation.Annotation;

class Introspector {
    private final Annotation marker;
    private final Contact contact;
    private final Format format;
    private final Label label;

    public Introspector(Contact contact, Label label, Format format) {
        this.marker = contact.getAnnotation();
        this.contact = contact;
        this.format = format;
        this.label = label;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Type getDependent() {
        return this.label.getDependent();
    }

    public String getEntry() {
        Type type = this.getDependent();
        Class<?> clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return this.getName(clazz);
    }

    private String getName(Class clazz) {
        String string = this.getRoot(clazz);
        if (string != null) {
            return string;
        }
        string = clazz.getSimpleName();
        return Reflector.getName(string);
    }

    private String getRoot(Class clazz) {
        Class clazz2 = clazz;
        while (clazz != null) {
            String string = this.getRoot(clazz2, clazz);
            if (string != null) {
                return string;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private String getRoot(Class clazz, Class clazz2) {
        String string = clazz2.getSimpleName();
        Root root = clazz2.getAnnotation(Root.class);
        if (root != null) {
            String string2 = root.name();
            if (!this.isEmpty(string2)) {
                return string2;
            }
            return Reflector.getName(string);
        }
        return null;
    }

    public String getName() {
        String string = this.label.getEntry();
        if (!this.label.isInline()) {
            string = this.getDefault();
        }
        return string;
    }

    private String getDefault() {
        String string = this.label.getOverride();
        if (!this.isEmpty(string)) {
            return string;
        }
        return this.contact.getName();
    }

    public Expression getExpression() {
        String string = this.getPath();
        if (string != null) {
            return new PathParser(string, this.contact, this.format);
        }
        return new EmptyExpression(this.format);
    }

    public String getPath() {
        Path path = (Path)this.contact.getAnnotation(Path.class);
        if (path == null) {
            return null;
        }
        return path.value();
    }

    public boolean isEmpty(String string) {
        if (string != null) {
            return string.length() == 0;
        }
        return true;
    }

    public String toString() {
        return String.format("%s on %s", this.marker, this.contact);
    }
}

