/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ByteVector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Edge;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Frame;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.MethodVisitor;

public class Label {
    static final Label EMPTY_LIST = new Label();
    short flags;
    private short lineNumber;
    private int[] otherLineNumbers;
    int bytecodeOffset;
    private int[] forwardReferences;
    short inputStackSize;
    short outputStackSize;
    short outputStackMax;
    short subroutineId;
    Frame frame;
    Label nextBasicBlock;
    Edge outgoingEdges;
    Label nextListElement;

    final Label getCanonicalInstance() {
        return this.frame == null ? this : this.frame.owner;
    }

    final void addLineNumber(int n) {
        if (this.lineNumber == 0) {
            this.lineNumber = (short)n;
        } else {
            int n2;
            if (this.otherLineNumbers == null) {
                this.otherLineNumbers = new int[4];
            }
            if ((n2 = (this.otherLineNumbers[0] = this.otherLineNumbers[0] + 1)) >= this.otherLineNumbers.length) {
                int[] nArray = new int[this.otherLineNumbers.length + 4];
                System.arraycopy(this.otherLineNumbers, 0, nArray, 0, this.otherLineNumbers.length);
                this.otherLineNumbers = nArray;
            }
            this.otherLineNumbers[n2] = n;
        }
    }

    final void accept(MethodVisitor methodVisitor, boolean bl) {
        methodVisitor.visitLabel(this);
        if (bl && this.lineNumber != 0) {
            methodVisitor.visitLineNumber(this.lineNumber & 0xFFFF, this);
            if (this.otherLineNumbers != null) {
                for (int i = 1; i <= this.otherLineNumbers[0]; ++i) {
                    methodVisitor.visitLineNumber(this.otherLineNumbers[i], this);
                }
            }
        }
    }

    final void put(ByteVector byteVector, int n, boolean bl) {
        if ((this.flags & 4) == 0) {
            if (bl) {
                this.addForwardReference(n, 0x20000000, byteVector.length);
                byteVector.putInt(-1);
            } else {
                this.addForwardReference(n, 0x10000000, byteVector.length);
                byteVector.putShort(-1);
            }
        } else if (bl) {
            byteVector.putInt(this.bytecodeOffset - n);
        } else {
            byteVector.putShort(this.bytecodeOffset - n);
        }
    }

    private void addForwardReference(int n, int n2, int n3) {
        int n4;
        if (this.forwardReferences == null) {
            this.forwardReferences = new int[6];
        }
        if ((n4 = this.forwardReferences[0]) + 2 >= this.forwardReferences.length) {
            int[] nArray = new int[this.forwardReferences.length + 6];
            System.arraycopy(this.forwardReferences, 0, nArray, 0, this.forwardReferences.length);
            this.forwardReferences = nArray;
        }
        this.forwardReferences[++n4] = n;
        this.forwardReferences[++n4] = n2 | n3;
        this.forwardReferences[0] = n4;
    }

    final boolean resolve(byte[] byArray, int n) {
        this.flags = (short)(this.flags | 4);
        this.bytecodeOffset = n;
        if (this.forwardReferences == null) {
            return false;
        }
        boolean bl = false;
        for (int i = this.forwardReferences[0]; i > 0; i -= 2) {
            int n2 = this.forwardReferences[i - 1];
            int n3 = this.forwardReferences[i];
            int n4 = n - n2;
            int n5 = n3 & 0xFFFFFFF;
            if ((n3 & 0xF0000000) == 0x10000000) {
                if (n4 < Short.MIN_VALUE || n4 > Short.MAX_VALUE) {
                    int n6 = byArray[n2] & 0xFF;
                    byArray[n2] = n6 < 198 ? (byte)(n6 + 49) : (byte)(n6 + 20);
                    bl = true;
                }
                byArray[n5++] = (byte)(n4 >>> 8);
                byArray[n5] = (byte)n4;
                continue;
            }
            byArray[n5++] = (byte)(n4 >>> 24);
            byArray[n5++] = (byte)(n4 >>> 16);
            byArray[n5++] = (byte)(n4 >>> 8);
            byArray[n5] = (byte)n4;
        }
        return bl;
    }

    final void markSubroutine(short s) {
        Label label = this;
        label.nextListElement = EMPTY_LIST;
        while (label != EMPTY_LIST) {
            Label label2 = label;
            label = label.nextListElement;
            label2.nextListElement = null;
            if (label2.subroutineId != 0) continue;
            label2.subroutineId = s;
            label = label2.pushSuccessors(label);
        }
    }

    final void addSubroutineRetSuccessors(Label label) {
        Label label2;
        Label label3 = EMPTY_LIST;
        Label label4 = this;
        label4.nextListElement = EMPTY_LIST;
        while (label4 != EMPTY_LIST) {
            label2 = label4;
            label4 = label2.nextListElement;
            label2.nextListElement = label3;
            label3 = label2;
            if ((label2.flags & 0x40) != 0 && label2.subroutineId != label.subroutineId) {
                label2.outgoingEdges = new Edge(label2.outputStackSize, label.outgoingEdges.successor, label2.outgoingEdges);
            }
            label4 = label2.pushSuccessors(label4);
        }
        while (label3 != EMPTY_LIST) {
            label2 = label3.nextListElement;
            label3.nextListElement = null;
            label3 = label2;
        }
    }

    private Label pushSuccessors(Label label) {
        Label label2 = label;
        Edge edge = this.outgoingEdges;
        while (edge != null) {
            boolean bl;
            boolean bl2 = bl = (this.flags & 0x10) != 0 && edge == this.outgoingEdges.nextEdge;
            if (!bl && edge.successor.nextListElement == null) {
                edge.successor.nextListElement = label2;
                label2 = edge.successor;
            }
            edge = edge.nextEdge;
        }
        return label2;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

