/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.ISequenceEncoder;

public class TrimInfixAndSuffixEncoder
implements ISequenceEncoder {
    private static final int REMOVE_EVERYTHING = 255;
    private ByteBuffer scratch = ByteBuffer.allocate(0);

    @Override
    public ByteBuffer encode(ByteBuffer reuse, ByteBuffer source, ByteBuffer target) {
        assert (source.hasArray() && source.position() == 0 && source.arrayOffset() == 0);
        assert (target.hasArray() && target.position() == 0 && target.arrayOffset() == 0);
        int maxInfixIndex = 0;
        int maxSubsequenceLength = BufferUtils.sharedPrefixLength(source, target);
        int maxInfixLength = 0;
        for (int i : new int[]{0, maxSubsequenceLength}) {
            for (int j = 1; j <= source.remaining() - i; ++j) {
                int len2 = source.remaining() - (i + j);
                this.scratch = BufferUtils.clearAndEnsureCapacity(this.scratch, i + len2);
                this.scratch.put(source.array(), 0, i);
                this.scratch.put(source.array(), i + j, len2);
                this.scratch.flip();
                int sharedPrefix = BufferUtils.sharedPrefixLength(this.scratch, target);
                if (sharedPrefix <= 0 || sharedPrefix <= maxSubsequenceLength || i >= 255 || j >= 255) continue;
                maxSubsequenceLength = sharedPrefix;
                maxInfixIndex = i;
                maxInfixLength = j;
            }
        }
        int truncateSuffixBytes = source.remaining() - (maxInfixLength + maxSubsequenceLength);
        if (truncateSuffixBytes == 0 && maxInfixIndex + maxInfixLength == source.remaining()) {
            truncateSuffixBytes = maxInfixLength;
            maxInfixLength = 0;
            maxInfixIndex = 0;
        }
        if (maxInfixIndex >= 255 || maxInfixLength >= 255 || truncateSuffixBytes >= 255) {
            maxSubsequenceLength = 0;
            maxInfixIndex = 0;
            truncateSuffixBytes = 255;
            maxInfixLength = 255;
        }
        int len1 = target.remaining() - maxSubsequenceLength;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, 3 + len1);
        reuse.put((byte)(maxInfixIndex + 65 & 0xFF));
        reuse.put((byte)(maxInfixLength + 65 & 0xFF));
        reuse.put((byte)(truncateSuffixBytes + 65 & 0xFF));
        reuse.put(target.array(), maxSubsequenceLength, len1);
        reuse.flip();
        return reuse;
    }

    @Override
    public int prefixBytes() {
        return 3;
    }

    @Override
    public ByteBuffer decode(ByteBuffer reuse, ByteBuffer source, ByteBuffer encoded) {
        assert (encoded.remaining() >= 3);
        int p = encoded.position();
        int infixIndex = encoded.get(p) - 65 & 0xFF;
        int infixLength = encoded.get(p + 1) - 65 & 0xFF;
        int truncateSuffixBytes = encoded.get(p + 2) - 65 & 0xFF;
        if (infixLength == 255 || truncateSuffixBytes == 255) {
            infixIndex = 0;
            infixLength = source.remaining();
            truncateSuffixBytes = 0;
        }
        int len1 = source.remaining() - (infixIndex + infixLength + truncateSuffixBytes);
        int len2 = encoded.remaining() - 3;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, infixIndex + len1 + len2);
        assert (encoded.hasArray() && encoded.position() == 0 && encoded.arrayOffset() == 0);
        assert (source.hasArray() && source.position() == 0 && source.arrayOffset() == 0);
        reuse.put(source.array(), 0, infixIndex);
        reuse.put(source.array(), infixIndex + infixLength, len1);
        reuse.put(encoded.array(), 3, len2);
        reuse.flip();
        return reuse;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

