/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableSingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;

public class MutableWindow
extends MutableSingleRel {
    public final List<Window.Group> groups;
    public final List<RexLiteral> constants;

    private MutableWindow(RelDataType rowType, MutableRel input, List<Window.Group> groups, List<RexLiteral> constants) {
        super(MutableRelType.WINDOW, rowType, input);
        this.groups = groups;
        this.constants = constants;
    }

    public static MutableWindow of(RelDataType rowType, MutableRel input, List<Window.Group> groups, List<RexLiteral> constants) {
        return new MutableWindow(rowType, input, groups, constants);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MutableWindow && this.groups.equals(((MutableWindow)obj).groups) && this.constants.equals(((MutableWindow)obj).constants) && this.input.equals(((MutableWindow)obj).input);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.groups, this.constants);
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Window(groups: ").append(this.groups).append(", constants: ").append(this.constants).append(")");
    }

    @Override
    public MutableRel clone() {
        return MutableWindow.of(this.rowType, this.input.clone(), this.groups, this.constants);
    }
}

