<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2024 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'เกี่ยวกับรายวิชานี้';
$string['activity'] = 'กิจกรรม';
$string['action:changeassetvisibility'] = 'เปลี่ยนการเปิดเผยเนื้อหา';
$string['action:duplicateasset'] = 'เนื้อหาที่ซ้ำกัน';
$string['action:changesectionvisibility'] = 'เปลี่ยนการเปิดเผยส่วน';
$string['action:highlightsectionvisibility'] = 'เน้นการมองเห็นส่วน';
$string['action:sectiontoc'] = 'รับตารางเนื้อหาแบบแบ่งส่วน';
$string['addanewsection'] = 'สร้างหัวข้อใหม่';
$string['addresourceoractivity'] = 'สร้างกิจกรรมการเรียนรู้';
$string['admin'] = 'ผู้ดูแลระบบ';
$string['advancedbrandingheading'] = 'การสร้างแบรนด์ขั้นสูง';
$string['ago'] = 'มาแล้ว';
$string['answered'] = 'ตอบ';
$string['appendices'] = 'เครื่องมือ';
$string['arialabelnewsarticle'] = 'บทความข่าว';
$string['assigndraft'] = 'ร่างต้องมีการยืนยันของคุณ';
$string['assignreopened'] = 'เปิด';
$string['at'] = 'ที่';
$string['attempted'] = 'ลองแล้ว';
$string['basics'] = 'ข้อมูลพื้นฐานเกี่ยวกับ';
$string['brandingheading'] = 'การสร้างแบรนด์';
$string['browse'] = 'เรียกดู';
$string['browseallcourses'] = 'เรียกดูรายวิชาทั้งหมด';
$string['cachedef_activity_deadlines'] = 'ที่เก็บแคชสำหรับกำหนดกิจกรรมของผู้ใช้งาน';
$string['cachedef_generalstaticappcache'] = 'สแน็ปอินแคชระดับแอปพลิเคชันทั่วไป';
$string['cachedef_course_completion_progress'] = 'ใช้เพื่อแคชข้อมูลความสมบูรณ์ต่อรายวิชา / ผู้ใช้งาน';
$string['cachedef_course_completion_progress_ts'] = 'สิ่งนี้ถูกใช้เพื่อให้เราสามารถทำให้แคชในระดับเซสชันใช้ไม่ได้หากการตั้งค่ารายวิชาเสร็จสิ้นสำหรับรายวิชาหรือการเปลี่ยนโมดูล';
$string['cachedef_webservicedefinitions'] = 'การแคชสำหรับคำจำกัดความบริการเว็บที่สร้างขึ้นโดยอัตโนมัติ';
$string['card'] = 'บัตร';
$string['categoryedit'] = 'แก้ไขประเภท';
$string['category_color'] = 'ประเภทสี';
$string['category_color_description'] = 'รายวิชาประเภทสี รายวิชาเด็กใช้การกำหนดค่าระดับสูงขึ้นไปที่ใกล้ที่สุด';
$string['category_color_palette'] = 'จานสี';
$string['category_color_palette_description'] = 'ดูค่าเลขฐานสิบหกที่สอดคล้องกันสำหรับสีที่กำหนด โดยจะไม่กระทบการกำหนดค่าใดๆ ซึ่งเป็นเพียงตัวอย่างเพื่อช่วยให้ผู้ใช้งานสร้างค่าการกำหนดค่า';
$string['changecoverimage'] = 'เปลี่ยนภาพหน้าปก';
$string['changefullname'] = 'เปลี่ยนชื่อเว็บไซต์';
$string['chapters'] = 'บท';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'ปิด';
$string['conditional'] = 'แบบมีเงื่อนไข';
$string['contents'] = 'เนื้อหา';
$string['contributed'] = 'มีส่วนร่วม';
$string['courses'] = 'รายวิชา';
$string['coursecontacts'] = 'รายการรายวิชา';
$string['coursedisplay'] = 'การแสดงรายวิชา';
$string['coursefootertoggle'] = 'ส่วนท้ายของรายวิชา';
$string['coursefootertoggledesc'] = 'ส่วนท้ายของรายวิชาจะแสดงข้อมูลที่เป็นประโยชน์ต่อผู้ใช้งานในหน้ารายวิชารวมถึงผู้ติดต่อรายวิชารายละเอียดรายวิชาและกิจกรรมล่าสุดในรายวิชา';
$string['courseformatnotification'] = 'รูปแบบของรายวิชาปัจจุบันที่คุณใช้ไม่ได้รับการสนับสนุนอย่างเต็มรูปแบบโดยธีม Snap เพื่อประสบการณ์ที่ดีที่สุดของ Open LMS ขอแนะนำให้ใช้รูปแบบหัวข้อหรือรายสัปดาห์กับธีม Snap สามารถเปลี่ยนแปลงรูปแบบของรายวิชาได้ใน<a href="{$a}">การตั้งค่ารายวิชา</a>';
$string['coursefixydefaulttext'] = 'คุณยังไม่ได้ลงทะเบียนรายวิชาในรายวิชาใดๆ<br>รายวิชาที่คุณลงทะเบียนไว้จะแสดงที่นี่';
$string['coursegrade'] = 'รายวิชาเกรด:';
$string['coursepartialrender'] = 'เปิดใช้งานการโหลดแบบ Lazy สำหรับส่วนรายวิชา';
$string['coursepartialrenderdesc'] = 'หากเปิดใช้งาน ส่วนรายวิชาจะโหลดได้ตามต้องการ เมื่อเลือกโดยผู้ใช้งาน วิธีการนี้จะช่วยให้รายวิชาที่มีเนื้อหาจำนวนมากโหลดได้เร็วขึ้น';
$string['coursenavigation'] = 'การนำทางของรายวิชา';
$string['coursesummaryfilesunsuitable'] = 'โปรดล้างไฟล์ข้อมูลสรุปรายวิชาของคุณก่อนที่จะพยายามเปลี่ยนภาพหน้าปก';
$string['courseactionslabel'] = 'การดำเนินการ';
$string['courseactivitieslabel'] = 'กิจกรรมของส่วน';
$string['coursetools'] = 'กระดานรายงานความเคลื่อนไหวของรายวิชา';
$string['coverdisplay'] = 'ดิสเพลย์หน้าปก';
$string['covercarousel'] = 'ภาพสไลด์หน้าปก';
$string['covercarousellabel'] = 'ภาพสไลด์';
$string['covercarouselon'] = 'ใช้ภาพสไลด์หน้าปก';
$string['covercarouseldescription'] = '<p>การแสดงสไลด์แบบหมุนเวียนเป็นชุดของแบนเนอร์หมุนหรือสไลด์โชว์ที่ปรากฏในหน้าแรกของเว็บไซต์ของคุณแทนที่ภาพหน้าปก</p>
<p>เพิ่มภาพได้สูงสุด 3 ภาพ ชื่อเรื่องสำหรับแต่ละสไลด์ และคำบรรยายเสริม รูปภาพขนาด 1200 x 600 พิกเซลจะทำงานได้ดีที่สุด</p>';
$string['covercarouselsronly'] = 'นี่คือการแสดงสไลด์แบบหมุนเวียนซึ่งจะเปลี่ยนสไลด์โดยอัตโนมัติ กดปุ่มใดๆ เพื่อปิดใช้งานการหมุน ใช้ปุ่มถัดไปและปุ่มก่อนหน้าเพื่อนำทางหรือข้ามไปยังสไลด์ที่ต้องการโดยใช้จุดแทนสไลด์';
$string['covercarouselplaybutton'] = 'ดำเนินการหมุนสไลด์โดยอัตโนมัติต่อสำหรับการแสดงสไลด์แบบหมุนเวียน';
$string['covercarouselpausebutton'] = 'หยุดการหมุนสไลด์โดยอัตโนมัติชั่วคราวสำหรับการแสดงสไลด์แบบหมุนเวียน';
$string['coverimage'] = 'รูปภาพหน้าปก';
$string['covervideo'] = 'ปกวิดีโอ';
$string['comingsoon'] = 'เร็วๆ นี้!';
$string['createsection'] = 'สร้างส่วน';
$string['current'] = 'ปัจจุบัน';
$string['customcss'] = 'CSS ที่กำหนดเอง';
$string['customcssdesc'] = 'โปรดทราบว่าพลังอันยิ่งใหญ่มาพร้อมความรับผิดชอบที่ยิ่งใหญ่เช่นกัน ปัญหาใดๆ ที่เกิดจากการเพิ่ม CSS ที่นี่เป็นความรับผิดชอบของคุณในการแก้ไข การสนับสนุน Open LMS จะไม่แก้ไขปัญหาหรือให้ความช่วยเหลือเกี่ยวกับเนื้อหาที่สัมพันธ์กับ CSS';
$string['customtopbar'] = 'แถบนำทาง';
$string['customisenavbar'] = 'เปลี่ยนสีแถบนำทาง';
$string['customisenavbutton'] = 'เปลี่ยนสีปุ่มรายวิชาของฉัน';
$string['customisecustommenu'] = 'เปลี่ยนสีข้อความเมนูแบบกำหนดเอง';
$string['custommenutext'] = 'สีข้อความเมนูแบบกำหนดเอง';
$string['deadlines'] = 'กำหนดเวลา';
$string['deadlinestoggle'] = 'กำหนดเวลา';
$string['deadlinestoggledesc'] = 'แสดงกำหนดเวลากิจกรรมที่จะเกิดขึ้นกับผู้ใช้งานจากรายวิชาที่ลงทะเบียน';
$string['defaultsummary'] = 'ใช้พื้นที่นี้เพื่ออธิบายว่าหัวข้อนี้เกี่ยวกับอะไร - ด้วยข้อความรูปภาพเสียงและวิดีโอ';
$string['defaultintrosummary'] = 'ขอต้อนรับสู่รายวิชาใหม่ {$a} ของคุณ<br>เริ่มต้นด้วยการอธิบายว่ารายวิชาของคุณเกี่ยวข้องกับอะไรโดยการใช้ข้อความ รูปภาพ เสียง และวิดีโอ';
$string['defaultsectiontitle'] = 'ส่วนที่ไม่ได้ตั้งชื่อ';
$string['debugerrors'] = 'แก้ไขข้อผิดพลาด';
$string['deleteassetconfirm'] = 'ลบ {$a}';
$string['deletingasset'] = 'ลบ {$a}';
$string['deletingassetname'] = 'ลบ {$a->type} " {$a->name} "';
$string['deletesectionconfirm'] = 'ลบส่วน';
$string['deletingsection'] = 'กำลังลบส่วน " {$a} "';
$string['draft'] = 'ไม่เผยแพร่ให้ผู้เรียน';
$string['dropzonelabel'] = 'วางไฟล์เพื่อแนบ หรือ<span class="fake-link">เรียกดู</span>';
$string['due'] = 'ครบกำหนด {$a}';
$string['edit'] = 'แก้ไข " {$a} "';
$string['editcoursecontent'] = 'แก้ไขบล็อก';
$string['editcoursesettings'] = 'การตั้งค่ารายวิชา';
$string['editcoursetopic'] = 'แก้ไขส่วน';
$string['editcustomfooter'] = 'แก้ไขท้ายกระดาษ';
$string['editcustommenu'] = 'แก้ไขเมนูที่กำหนดเอง';
$string['error'] = 'ข้อผิดพลาด';
$string['errorgettingfeed'] = 'เกิดข้อผิดพลาดขณะรับรายการฟีต';
$string['error:categorycolorinvalidjson'] = 'รูปแบบ JSON ไม่ถูกต้องสำหรับประเภทรายวิชา';
$string['error:categorycolorinvalidvalue'] = 'บันทึก id หรือค่าสีสำหรับประเภท " {$a} "ไม่ถูกต้อง';
$string['error:categorynotfound'] = 'บันทึกประเภทพร้อมรหัส " {$a} "ไม่พบ';
$string['error:coverimageexceedsmaxbytes'] = 'รูปภาพหน้าปกเกินขนาดไฟล์สูงสุดที่อนุญาตในระดับเว็บไซต์ ( {$a} )';
$string['error:coverimageresolutionlow'] = 'เพื่อคุณภาพที่ดีที่สุดเราขอแนะนำภาพขนาดใหญ่ที่มีความกว้างอย่างน้อย 1024px';
$string['error:duplicatedcategoryids'] = 'รูปแบบ JSON ไม่ถูกต้องมีบาง ID ซ้ำกัน';
$string['error:failedtochangeassetvisibility'] = 'ไม่สามารถซ่อน / แสดงเนื้อหา';
$string['error:failedtochangesectionvisibility'] = 'ไม่สามารถซ่อน / แสดงหัวข้อ';
$string['error:failedtohighlightsection'] = 'ไม่สามารถไฮไลต์ส่วนได้';
$string['error:failedtoduplicateasset'] = 'การทำสำเนาล้มเหลว';
$string['error:failedtodeleteasset'] = 'ไม่สามารถลบเนื้อหา';
$string['error:failedtotoc'] = 'ไม่สามารถรับ TOC ได้';
$string['extension'] = 'ส่วนขยาย {$a}';
$string['extra_section_menu'] = 'เมนูส่วนพิเศษ';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'URL ของหน้า Facebook ของคุณ';
$string['favicon'] = 'favicon';
$string['favicondesc'] = 'Favicons ปรากฏในแถบที่อยู่ของเว็บเบราว์เซอร์ในบุ๊กมาร์กและทางลัดมือถือของผู้ใช้งาน';
$string['favorite'] = 'ที่ชื่นชอบ {$a}';
$string['favorited'] = 'รายการโปรด {$a}';
$string['featurespots'] = 'คุณสมบัติเด่น';
$string['featurespotsedit'] = 'แก้ไขจุดที่น่าสนใจ';
$string['featurespotshelp'] = '<p>เพิ่มจุดสนใจได้สูงสุด 6 จุดบนหน้าแรกของไซต์ของคุณเพื่อไฮไลต์สิทธิประโยชน์หลักๆ ต่อทั้งผู้ใช้งานปัจจุบันและผู้ที่มีแนวโน้มเป็นผู้ใช้งานในอนาคต</p>
<p>คุณสามารถเพิ่มรูปภาพ ชื่อ และคำอธิบายเนื้อหาลงในแต่ละฟีเจอร์ <strong>หากต้องการดูฟีเจอร์ในหน้าแรก คุณต้องป้อนชื่อ</strong> ไม่บังคับส่วนรูปภาพและคำอธิบายเนื้อหา</p>
<p>ขนาดรูปภาพที่แนะนำคือสี่เหลี่ยมและไม่เกิน 200px คูณ 200px</p>';
$string['featurespotsheading'] = 'ส่วนหัวคุณสมบัติจุด';
$string['featureonetitle'] = 'คุณสมบัติ 1 ชื่อ';
$string['featuretwotitle'] = 'คุณสมบัติ 2 ชื่อ';
$string['featurethreetitle'] = 'คุณสมบัติ 3 ชื่อ';
$string['featurefourtitle'] = 'คุณสมบัติ 4 ชื่อ';
$string['featurefivetitle'] = 'คุณสมบัติ 5 ชื่อ';
$string['featuresixtitle'] = 'คุณสมบัติ 6 ชื่อ';
$string['featureonetitlelink'] = 'คุณสมบัติ 1 ลิงก์ชื่อ';
$string['featuretwotitlelink'] = 'คุณสมบัติ 2 ลิงก์ชื่อ';
$string['featurethreetitlelink'] = 'คุณสมบัติ 3 ลิงก์ชื่อ';
$string['featurefourtitlelink'] = 'คุณสมบัติ 4 ลิงก์ชื่อ';
$string['featurefivetitlelink'] = 'คุณสมบัติ 5 ลิงก์ชื่อ';
$string['featuresixtitlelink'] = 'คุณสมบัติ 6 ลิงก์ชื่อ';
$string['featuretitlelinkdesc'] = 'พิมพ์ URL ที่ต้องการเชื่อมโยงจุดคุณลักษณะนี้ คุณสามารถเพิ่มลิงก์ภายนอกหรือลิงก์ภายในเข้าไปยังเว็บไซต์ของคุณ สำหรับการเพิ่มลิงก์ภายใน โปรดคัดลอกจากการรวม URL ของเว็บไซต์ / เช่น ต้องการเชื่อมโยงลิงก์ไปยังรายวิชาหนึ่ง จะเป็น "course/view.php?id=160" เมื่อต้องการเพิ่มลิงก์ภายนอกให้เริ่มต้นลิงก์ด้วย https://';
$string['featureonetitlecb'] = 'คุณสมบัติ 1 เปิดหน้าต่างใหม่';
$string['featuretwotitlecb'] = 'คุณสมบัติ 2 เปิดหน้าต่างใหม่';
$string['featurethreetitlecb'] = 'คุณสมบัติ 3 เปิดหน้าต่างใหม่';
$string['featurefourtitlecb'] = 'คุณสมบัติ 4 เปิดหน้าต่างใหม่';
$string['featurefivetitlecb'] = 'คุณสมบัติ 5 เปิดหน้าต่างใหม่';
$string['featuresixtitlecb'] = 'คุณสมบัติ 6 เปิดหน้าต่างใหม่';
$string['featuretitlecbdesc'] = 'หากเปิดการใช้งานแล้ว ลิงก์ที่เพิ่มไปยังจุดคุณสมบัติจะถูกเปิดในหน้าต่างใหม่';
$string['featureonetext'] = 'คุณสมบัติ 1 เนื้อหา';
$string['featuretwotext'] = 'คุณสมบัติ 2 เนื้อหา';
$string['featurethreetext'] = 'คุณสมบัติ 3 เนื้อหา';
$string['featurefourtext'] = 'คุณสมบัติ 4 เนื้อหา';
$string['featurefivetext'] = 'คุณสมบัติ 5 เนื้อหา';
$string['featuresixtext'] = 'คุณสมบัติ 6 เนื้อหา';
$string['featureoneimage'] = 'คุณสมบัติ 1 ภาพ';
$string['featuretwoimage'] = 'คุณสมบัติ 2 ภาพ';
$string['featurethreeimage'] = 'คุณสมบัติ 3 ภาพ';
$string['featurefourimage'] = 'คุณสมบัติ 4 ภาพ';
$string['featurefiveimage'] = 'คุณสมบัติ 5 ภาพ';
$string['featuresiximage'] = 'คุณสมบัติ 6 ภาพ';
$string['featuredcategoriesandcourses'] = 'ประเภทและรายวิชาที่โดดเด่น';
$string['featuredcourses'] = 'รายวิชาแนะนำ';
$string['featuredcourseshelp'] = 'ไฮไลท์รายวิชาเด่นได้มากถึง 8 รายการในหน้าแรกของเว็บไซต์ของคุณ พิมพ์ ID รายวิชาเพื่อนำเสนอรายวิชา';
$string['featuredcoursesheading'] = 'หัวข้อรายวิชาเด่น';
$string['featuredcourseone'] = 'รายวิชาพิเศษ 1';
$string['featuredcoursetwo'] = 'รายวิชาพิเศษ 2';
$string['featuredcoursethree'] = 'รายวิชาพิเศษ 3';
$string['featuredcoursefour'] = 'รายวิชาพิเศษ 4';
$string['featuredcoursefive'] = 'รายวิชาพิเศษ 5';
$string['featuredcoursesix'] = 'รายวิชาพิเศษ 6';
$string['featuredcourseseven'] = 'รายวิชาพิเศษ 7';
$string['featuredcourseeight'] = 'รายวิชาพิเศษ 8';
$string['featuredcoursesedit'] = 'แก้ไขรายวิชาที่โดดเด่น';
$string['featuredcoursesbrowseall'] = 'เรียกดูรายวิชาทั้งหมด';
$string['featuredcoursesbrowsealldesc'] = 'เพิ่มลิงค์เรียกดูรายวิชาทั้งหมด';
$string['featuredcategories'] = 'ประเภทที่โดดเด่น';
$string['featuredcategorieshelp'] = 'ไฮไลต์ประเภทที่โดดเด่นได้มากถึง 8 รายการในหน้าแรกของเว็บไซต์ของคุณ พิมพ์ ID ประเภทเพื่อตั้งค่าเป็นประเภทที่โดดเด่น';
$string['featuredcategoriesheading'] = 'หัวข้อประเภทที่โดดเด่น';
$string['featuredcategoryone'] = 'ประเภทที่โดดเด่น 1';
$string['featuredcategorytwo'] = 'ประเภทที่โดดเด่น 2';
$string['featuredcategorythree'] = 'ประเภทที่โดดเด่น 3';
$string['featuredcategoryfour'] = 'ประเภทที่โดดเด่น 4';
$string['featuredcategoryfive'] = 'ประเภทที่โดดเด่น 5';
$string['featuredcategoriesix'] = 'ประเภทที่โดดเด่น 6';
$string['featuredcategorieseven'] = 'ประเภทที่โดดเด่น 7';
$string['featuredcategoryeight'] = 'ประเภทที่โดดเด่น 8';
$string['featuredcategoriesedit'] = 'แก้ไขประเภทที่โดดเด่น';
$string['featuredcategoriesbrowseall'] = 'เรียกดูประเภททั้งหมด';
$string['featuredcategoriesbrowsealldesc'] = 'เพิ่มลิงค์เรียกดูประเภททั้งหมด';
$string['feature_spot_background_color'] = 'สีพื้นหลัง';
$string['feature_spot_title_color'] = 'สีข้อความชื่อ';
$string['feature_spot_description_color'] = 'สีข้อความคำอธิบาย';
$string['feature_spot_title_color_lower'] = 'สีข้อความชื่อ';
$string['feature_spot_description_color_lower'] = 'สีข้อความคำอธิบาย';
$string['feedbackavailable'] = 'ผลตอบรับที่มีอยู่';
$string['feedbacktoggle'] = 'ผลตอบรับและการให้เกรด';
$string['feedbacktoggledesc'] = 'แสดงผลตอบรับล่าสุดของผู้เรียนและผู้สอนเกี่ยวกับผลงานล่าสุดที่ต้องให้คะแนน';
$string['footnote'] = 'ส่วนท้ายของเว็บไซต์';
$string['footnotedesc'] = 'คุณสามารถเพิ่มข้อมูลไซต์ของคุณเป็น HTML และรวมลิงก์ รูปภาพ หรือรายการกิจกรรม';
$string['forcepwdwarningpersonalmenu'] = 'คุณต้อง<a href="{$a}">เปลี่ยนรหัสผ่านของคุณ</a>ก่อนใช้เมนูส่วนบุคคล';
$string['forumauthor'] = 'ผู้เขียน';
$string['forumlastpost'] = 'โพสต์ล่าสุด';
$string['forumpicturegroup'] = 'กลุ่ม';
$string['forumreplies'] = 'ตอบกลับ';
$string['forumtopic'] = 'หัวข้อ';
$string['forumposts'] = 'โพสต์ลงในกระดานเสวนา';
$string['forumpoststoggle'] = 'โพสต์ลงในกระดานเสวนา';
$string['forumpoststoggledesc'] = 'แสดงผู้ใช้งานโพสต์กระดานเสวนาล่าสุด 10 รายการจากรายวิชา';
$string['fullname'] = 'ชื่อเว็บไซต์';
$string['fullnamedesc'] = 'ชื่อเว็บไซต์ของคุณ';
$string['gotoactivity'] = 'ไปที่กิจกรรม {$a}';
$string['graderadviseuserreport'] = '"รายงานปราบดินให้ราบ" ใช้งานไม่ได้กับอุปกรณ์มือถือ แนะนำ "รายงานผู้ใช้งาน" แทน';
$string['grading'] = 'การให้เกรด';
$string['help'] = 'ความช่วยเหลือ';
$string['helpguide'] = 'คู่มือช่วยเหลือ';
$string['headingfont'] = 'หัวเรื่องตัวอักษร';
$string['headingfont_desc'] = 'ฟอนต์ sans-serif นี้จะถูกใช้ในหัวเรื่อง (องค์ประกอบ h1 - h6) ทั่วทั้งไซต์ของคุณ หากคุณรวมเว็บฟอนต์ที่กำหนดเอง โปรดคำนึงว่าให้เพิ่มฟอนต์นั้นลงใน HTML เพิ่มเติมของ Moodle หากคุณต้องการปรับแต่งฟอนต์ขององค์ประกอบอื่น โปรดใช้ประโยขน์จากตัวเลือก CSS แบบกำหนดเอง สำหรับตัวอย่างเกี่ยวกับวิธีการดำเนินการดังกล่าว โปรดดูที่<a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">เอกสาร</a>นี้';
$string['helpwithlogin'] = 'ช่วยในการเข้าสู่ระบบ';
$string['helpwithloginandguest'] = 'ช่วยเหลือเกี่ยวกับการเข้าสู่ระบบ / การเข้าถึงในฐานะบุคคลทั่วไป';
$string['loginrequiredmessage'] = '* ระบุว่าเป็นฟิลด์บังคับ';
$string['hiddencoursestoggle'] = 'รายวิชาที่ซ่อนอยู่';
$string['highlightedsection'] = 'ไฮไลต์';
$string['home'] = 'หน้าแรก';
$string['image'] = 'ภาพ';
$string['images'] = 'ภาพ';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'URL ของบัญชี Instagram ของคุณ';
$string['introduction'] = 'บทนำ';
$string['jsontext'] = 'ข้อความ JSON';
$string['jsontextdescription'] = 'พื้นที่ข้อความตรวจสอบความถูกต้องของ JSON ที่กำหนด งนั้นอนุญาตเฉพาะประเภทที่มีอยู่เท่านั้น เฉพาะค่าตัวเลขในฐานะที่เป็น id (เรคคอร์ดหมวดหมู่) ที่ถูกต้องและยอมรับเฉพาะค่าเลขฐานสิบหกเป็นสี นี่คือตัวอย่าง:<br>{"1":"#FAAFFF",<br>"45":"#AFF",<br>"65":"#FFF228",<br>"12":"#CC0084",<br>"56":"#CC0087",<br>"89":"#CCF084"}';
$string['knowledgebase'] = 'ฐานความรู้ LMS แบบเปิด';
$string['list'] = 'รายการ';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'URL ของ LinkedIn ขององค์กรของคุณ';
$string['leftnav'] = 'สารบัญ';
$string['leftnavdesc'] = 'เลือกตำแหน่งที่จะแสดงสารบัญ รายการให้พื้นที่เพิ่มเติมสำหรับเนื้อหาและใช้งานได้ดีสำหรับรายวิชาที่มีหัวข้อมากมาย';
$string['loading'] = 'กำลังโหลด...';
$string['loggedinasguest'] = 'คุณเข้าสู่ระบบในฐานะแขก';
$string['loggedoutmsg'] = 'คุณออกจากระบบในขณะนี้ หากคุณต้องการใช้เว็บไซต์นี้ต่อโปรดเข้าสู่ระบบอีกครั้ง';
$string['loggedoutmsgtitle'] = 'คุณออกจากระบบแล้ว';
$string['loggedoutfailmsg'] = 'คุณต้องเข้าสู่ระบบ {$a}';
$string['loginform'] = 'เข้าสู่ระบบ';
$string['logo'] = 'เครื่องหมาย';
$string['logodesc'] = 'โลโก้ของคุณจะปรากฏในส่วนหัวทั่วทั้งเว็บไซต์..';
$string['menu'] = 'รายวิชาของฉัน';
$string['messageread'] = 'ข้อความที่อ่าน';
$string['messages'] = 'ข้อความ';
$string['messagestoggle'] = 'ข้อความ';
$string['messagestoggledesc'] = 'แสดงให้ผู้ใช้เห็นข้อความล่าสุดที่ได้รับในช่วง 12 สัปดาห์ล่าสุด หากต้องการเปิดใช้งานตัวเลือกนี้ ให้ตรวจสอบว่าเปิดใช้งานฟีเจอร์การส่งข้อความในหน้าฟีเจอร์ขั้นสูงอยู่';
$string['more'] = 'มากกว่า';
$string['morenews'] = 'ข่าวเพิ่มเติม';
$string['moreoptionslabel'] = 'ตัวเลือกเพิ่มเติม';
$string['movingstartedhelp'] = 'นำทางไปยังตำแหน่งที่คุณต้องการวางส่วน "{$a}"';
$string['movingdropsectionhelp'] = 'ส่วนสถานที่ " {$a->moving} "ก่อนส่วน" {$a->before} "';
$string['moving'] = 'ย้าย " {$a} "';
$string['movingcount'] = 'การย้าย {$a} วัตถุ';
$string['movefailed'] = 'การย้ายล้มเหลวสำหรับ " {$a} "';
$string['move'] = 'ย้าย "{$a}"';
$string['movehere'] = 'ย้ายมาที่นี่';
$string['movesection'] = 'ย้ายส่วน';
$string['navbarbg'] = 'สีพื้นหลัง';
$string['navbarlink'] = 'สีข้อความ';
$string['navbarbuttoncolor'] = 'สีพื้นหลัง';
$string['navbarbuttonlink'] = 'สีข้อความ';
$string['nextsection'] = 'ส่วนถัดไป';
$string['nodeadlines'] = 'คุณไม่มีกำหนดส่งงาน';
$string['noforumposts'] = 'คุณไม่มีกระทู้ที่เกี่ยวข้อง';
$string['nograded'] = 'คุณไม่มีผลตอบรับล่าสุด';
$string['nograding'] = 'คุณไม่มีการส่งเกรด';
$string['nomessages'] = 'คุณไม่มีข้อความ';
$string['notanswered'] = 'ไม่ตอบ';
$string['notattempted'] = 'ไม่ได้พยายาม';
$string['notcontributed'] = 'ไม่มีส่วนร่วม';
$string['notpublished'] = 'ไม่เผยแพร่ให้ผู้เรียน';
$string['notsubmitted'] = 'ไม่ได้ส่ง';
$string['overdue'] = 'เกินกำหนด';
$string['pausegraphicsanim'] = 'พักภาพเคลื่อนไหว GIF';
$string['personalmenu'] = 'เมนูส่วนตัว';
$string['personalmenuandsnapfeeds'] = 'เมนูส่วนบุคคลและฟีด Snap';
$string['personalmenufeatures'] = 'คุณสมบัติเมนูส่วนบุคคล';
$string['personalmenulogintoggle'] = 'แสดงเมนูส่วนตัวในการเข้าสู่ระบบ';
$string['personalmenulogintoggledesc'] = 'เปิดเมนูส่วนตัวทันทีหลังจากเข้าสู่ระบบ';
$string['personalmenuadvancedfeedsenable'] = 'เปิดใช้งานการฟีดขั้นสูง';
$string['personalmenuadvancedfeedsenabledesc'] = 'ฟีดขั้นสูงจะโหลดรายการเมนูส่วนตัวบางรายการซึ่งช่วยให้เวลาโหลดเร็วขึ้น รวมทั้งสามารถรีเฟรชเนื้อหาได้ตามต้องการ';
$string['personalmenuadvancedfeedsperpage'] = 'จำนวนแสดงรายการฟีดขั้นสูง';
$string['personalmenuadvancedfeedsperpagedesc'] = 'เลือกจำนวนรายการที่จะแสดงในฟีด ผู้ใช้งานสามารถเลือก <strong>ดูเพิ่มเติม</strong> เพื่อแสดงรายการเพิ่มเติมได้';
$string['personalmenuadvancedfeedslifetime'] = 'อายุของฟีดขั้นสูง';
$string['personalmenuadvancedfeedslifetimedesc'] = 'เลือกระยะเวลาที่จะแคชเก็บฟีดไว้ในเบราว์เซอร์หลังจากเข้าสู่ระบบ การตั้งค่าเป็น 0 จะไม่แคชเก็บฟีดไว้ในเบราว์เซอร์';
$string['personalmenurefreshdeadlines'] = 'รีเฟรชเวลาครบกำหนดโดยใช้ภารกิจที่กำหนดเวลาไว้แล้ว';
$string['personalmenurefreshdeadlinesdesc'] = 'เมื่อเปิดใช้งานภารกิจนี้ ข้อมูลเวลาครบกำหนดจะถูกรีเฟรชเพื่อให้เวลาการโหลดหน้าเร็วขึ้น';
$string['personalmenuenablepersonalmenu'] = 'เปิดใช้งานเมนูส่วนบุคคล';
$string['personalmenuenablepersonalmenuheading'] = 'เมนูส่วนตัว';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'หมายเหตุ: หากเมนูส่วนบุคคลถูกปิดใช้งาน คุณจะเข้าถึงรายวิชาของคุณได้จากหน้ารายวิชาของฉัน โปรดตรวจสอบว่าเปิดใช้งานบล็อกสรุปรายวิชาอยู่ เพื่อให้รายวิชาปรากฏในหน้า';
$string['personalmenuenablepersonalmenudesc'] = 'ลิงก์รายวิชาของฉันจะเปิดเมนูส่วนบุคคล หากปิดใช้งาน ลิงก์จะนำทางไปยังหน้ารายวิชาของฉัน';
$string['mycoursessnapfeedsheading'] = 'ฟีด Snap';
$string['mycoursessnapfeedsdesc'] = 'หมายเหตุ: <strong>ฟีดขั้นสูง</strong> จะพร้อมใช้งานเมื่อเลือกอย่างน้อยหนึ่งตัวเลือก <strong>เวลาครบกำหนด</strong> <strong>ความคิดเห็นและการให้เกรด</strong> <strong>ข้อความ</strong> หรือ <strong>โพสต์กระดานเสวนา</strong>';
$string['refreshdeadlinestasksettingheading'] = 'รีเฟรชเวลาครบกำหนดของงานตามกำหนดเวลา';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'รูปภาพหน้าปก';
$string['posterdesc'] = 'ภาพส่วนหัวขนาดใหญ่สำหรับหน้าแรกของเว็บไซต์ของคุณ ภาพแนวนอน (1200 x 600 พิกเซล) หรือใหญ่กว่าทำงานได้ดีที่สุด';
$string['poweredbyrunby'] = 'สร้างด้วย <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a> ผลิตภัณฑ์จาก <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a><br>ลิขสิทธิ์ © {$a->year} Open LMS, สงวนลิขสิทธิ์';
$string['previoussection'] = 'ส่วนก่อนหน้า';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'ID รายวิชาของรายวิชาที่ผู้ใช้งานชื่นชอบ';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'ID ผู้ใช้งานของผู้ใช้งานที่ชื่นชอบรายวิชา';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'เวลาประทับของเวลาที่ผู้ใช้งานชื่นชอบรายวิชา';
$string['privacy:metadata:theme_snap_course_favorites'] = 'จัดเก็บรายการโปรดของรายวิชาของผู้ใช้งานสำหรับ Snap';
$string['problemsfound'] = 'เจอปัญหา';
$string['progress'] = 'ความคืบหน้า';
$string['readmore'] = 'อ่านเพิ่มเติม &nbsp;»';
$string['recentactivity'] = 'กิจกรรมล่าสุด';
$string['recentfeedback'] = 'ผลตอบรับ';
$string['region-main'] = 'หลัก';
$string['region-side-main-box'] = 'หลัก';
$string['region-side-post'] = 'ขวา';
$string['region-side-pre'] = 'ด้านซ้าย';
$string['region-side-top'] = 'ด้านบน';
$string['released'] = 'การเผยแพร่: {$a}';
$string['reopened'] = 'เปิด';
$string['resourcedisplay'] = 'แสดงทรัพยากร';
$string['resourcedisplayhelp'] = 'เลือกว่าจะให้สิ่งที่แนบและลิงก์ปรากฏในรายวิชาของคุณอย่างไร รูปแบบ Snap นี้ไม่รองรับไฟล์มัลติมีเดียในคำอธิบายของกิจกรรมเล็กๆ และบัตรแหล่งข้อมููล';
$string['resumegraphicsanim'] = 'เล่นภาพเคลื่อนไหว GIF ต่อ';
$string['displaydescription'] = 'แสดงผลคำอธิบาย';
$string['displaydescriptionhelp'] = 'เลือกเพื่อแสดงคำอธิบายของกิจกรรมแหล่งที่มาในหน้าแรกเป็นอันดับแรก ผู้เรียนจะเข้าถึงเนื้อหาจากคำอธิบาย';
$string['search'] = 'ค้นหาเนื้อหา';
$string['showcoursegradepersonalmenu'] = 'เกรด';
$string['showcoursegradepersonalmenudesc'] = 'แสดงคะแนนของผู้ใช้งานในการ์ดคอร์สในเมนูส่วนตัว';
$string['socialmedia'] = 'สื่อสังคม';
$string['submitted'] = 'ส่ง';
$string['sitedescription'] = 'รายละเอียดเว็บไซต์';
$string['subtitle'] = 'หัวเรื่องย่อย';
$string['subtitle_desc'] = 'อธิบายเว็บไซต์ของคุณสั้นๆ สำหรับผู้ใช้งาน';
$string['summarylabel'] = 'บทสรุปของส่วน';
$string['themecolor'] = 'สีของเว็บไซต์';
$string['themecolordesc'] = 'สีสดใสทำงานได้ดีที่สุดและจะทำให้เว็บไซต์ของคุณมีความทันสมัย';
$string['title'] = 'ชื่อเรื่อง';
$string['top'] = 'ด้านบน';
$string['topbarbgcolor'] = 'สีแถบนำทาง';
$string['topbarlinkcolor'] = 'ลิงค์แถบนำทางและสีไอคอน';
$string['topbarbuttoncolor'] = 'พื้นหลังรายวิชาของฉัน';
$string['togglenavigation'] = 'สลับการนำทาง';
$string['topicactions'] = 'การดำเนินการของหัวข้อ';
$string['xakatwitter'] = '𝕏';
$string['xakatwitterdesc'] = 'URL ของบัญชี 𝕏 ของคุณ';
$string['unenrolme'] = 'ลงทะเบียนฉัน';
$string['enrolme'] = 'ลงทะเบียนรายวิชาฉัน';
$string['unread'] = 'ไม่ได้อ่าน';
$string['unsupportedcoverimagetype'] = 'ประเภทภาพหน้าปกที่ไม่รองรับ ( {$a} )';
$string['via'] = 'ผ่านทาง';
$string['viewcourse'] = 'ดูรายวิชา';
$string['viewmore'] = 'ดูเพิ่มเติม';
$string['viewyourprofile'] = 'ดูโปรไฟล์ของคุณ';
$string['viewmyfeedback'] = 'ดูผลตอบรับของฉัน';
$string['viewcalendar'] = 'ดูปฏิทินของฉัน';
$string['viewforumposts'] = 'ดูกระทู้ของฉัน';
$string['viewmessaging'] = 'ดูข้อความของฉัน';
$string['vieworiginalimage'] = 'ดูภาพต้นฉบับ';
$string['visibility'] = 'การมองเห็น';
$string['xofyanswered'] = '{$a->completed} ของ {$a->participants} ตอบ';
$string['xofyattempted'] = '{$a->completed} ของ {$a->participants} พยายาม';
$string['xofycontributed'] = '{$a->completed} ของ {$a->participants} มีส่วนร่วม';
$string['xofysubmitted'] = 'ส่งแล้ว {$a->completed} จาก {$a->participants}';
$string['xungraded'] = '{$a} ไม่ได้อัปเกรด';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'URL ของช่อง YouTube ของคุณ';
$string['showallsectionsdisabled'] = 'เนื่องจากภาษาการออกแบบ "แสดงส่วนทั้งหมดในหน้าเดียว" ไม่พร้อมใช้งานใน Snap';
$string['disabled'] = 'ปิดใช้งาน';
$string['showappearancedisabled'] = 'ภาษาการออกแบบของ Snap ป้องกันการเปลี่ยนแปลงการตั้งค่า "ลักษณะ"';
$string['pbb'] = 'การสร้างแบรนด์ตามโปรไฟล์';
$string['pbb_description'] = 'ด้วยการเปิดใช้งาน <strong>การสร้างแบรนด์ตามโปรไฟล์</strong> คุณจะสามารถปรับแต่งประสบการณ์การสร้างแบรนด์สำหรับกลุ่มผู้ใช้งานที่เฉพาะเจาะจงโดยยึดตามฟิลด์โปรไฟล์ผู้ใช้งานที่เลือก<ul><li>ค่าในฟิลด์ผู้ใช้งานจะถูก <em>สร้าง Slug</em> โดยเป็นการแปลงอักขระทั้งหมดเป็นตัวอักษรพิมพ์เล็กและคั่นด้วยเครื่องหมายขีดกลาง (-)</li>
<li>สตริง <code>snap-pbb-</code> จะถูกเพิ่มส่วนนำหน้า</li>
<li>ชั้นเรียนนี้จะถูกเพิ่มลงในองค์แท็ก HTML <code>body</code></li></ul>ตัวอย่างเช่น ค่าในฟิลด์ผู้ใช้งาน <em>Blueberry Extravaganza</em> จะถูกสร้าง Slug เป็น <code>snap-pbb-blueberry-extravaganza</code><br /><br />คุณสมบัตินี้จะใช้ร่วมกับ Custom CSS คุณจำเป็นต้องเพิ่มเครื่องมือเลือก CSS โดยใช้คลาสใหม่ๆ ในส่วน <a class="snap-settings-tab-link" href="#themesnapbranding">พื้นฐาน</a>';
$string['pbb_enable'] = 'เปิดใช้งานการสร้างตราสินค้าตามโปรไฟล์';
$string['pbb_enable_description'] = 'เพิ่มคลาสให้กับแท็กเนื้อความถ้าเปิดใช้งาน';
$string['pbb_field'] = 'ฟิลด์ผู้ใช้งานที่จะใช้';
$string['pbb_field_description'] = 'ค่าของฟิลด์นี้จะถูกสร้าง Slug และใช้เป็นชื่อคลาส CSS ที่นำหน้าด้วย <code>snap-pbb-</code>';
$string['cachedef_profile_based_branding'] = 'การแคชสำหรับการสร้างแบรนด์ตามโปรไฟล์';
$string['cachedef_course_card_bg_image'] = 'แคชสำหรับภาพพื้นหลังของรายวิชา';
$string['cachedef_course_card_teacher_avatar'] = 'แคชสำหรับอวตารของครู';
$string['cachedef_course_card_teacher_avatar_index'] = 'การแคชสำหรับดัชนีรูปภาพประจำตัวของครู';
$string['accessforumstringdis'] = 'ตัวเลือกการแสดงผล';
$string['accessforumstringmov'] = 'ย้ายตัวเลือก';
$string['accesscalendarstring'] = 'ปฏิทิน';
$string['accessglobalsearchstring'] = 'ค้นหา';
$string['admineventwarning'] = 'หากต้องการดูกิจกรรมจากทุกรายวิชา';
$string['gotocalendarsnap'] = 'ไปที่เว็บไซต์ของปฏิทิน';
$string['quizattemptswarn'] = 'ไม่รวมความพยายามจากผู้ใช้งานที่ถูกระงับ';
$string['quizfeedback'] = 'ผลตอบรับ';
$string['validratio'] = 'ชุดรวมสีนี้ไม่ตรงตามค่าอัตราส่วนต่ำสุดของ WCAG 2.0 คือ 4.5:1';
$string['invalidratio'] = 'ชุดรวมสีนี้ไม่ตรงตาม <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a>. ค่า: "{$a}"';
$string['imageinvalidratio'] = 'ภาพนี้มีปัญหาเกี่ยวกับค่าความเปรียบต่าง เนื่องจากไม่ตรงตามค่าอัตราส่วนต่ำสุดของ WCAG 2.0 คือ 4.5:1 ค่าพิกเซลเฉลี่ย: "{$a}"';
$string['catinvalidratio'] = 'หมวดหมู่สีต่อไปนี้ไม่ตรงตาม <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a>: เมื่อเปรียบเทียบกับสีพื้นหลังของเว็บไซต์ (สีขาว): "{$a->white}" เมื่อเปรียบเทียบกับสีพื้นหลังของแถบนำทาง: "{$a->custombar}" เมื่อเปรียบเทียบกับสีพื้นหลังของปุ่มรายวิชาของฉัน: "{$a->customnav}"';
$string['spotinvalidratio'] = 'ชุดรวมสีนี้ไม่ตรงตาม<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum ratio value 4.5:1</a> ค่าปัจจุบันเปรียบเทียบกับ {$a->name}: {$a->value}';
$string['imageinvalidratiocategory'] = 'ภาพนี้มีปัญหาเกี่ยวกับค่าความเปรียบต่างกับสีของรูปแบบ เนื่องจากไม่ตรงตามค่าอัตราส่วนต่ำสุดของ WCAG 2.0 คือ 4.5:1 ค่าพิกเซลเฉลี่ย: "{$a}"';
$string['browseallcategories'] = 'เรียกดูประเภททั้งหมด';
$string['lazyload_mod_page'] = 'เปิดใช้งานการโหลดแบบ Lazy ตามค่าเริ่มต้นสำหรับแหล่งข้อมููลหน้า';
$string['lazyload_mod_page_description'] = 'หากเปิดใช้งาน การตั้งค่านี้จะลดเวลาโหลดหน้ารายวิชาลงได้เป็นอย่างมากในกรณีรายวิชาที่ประกอบด้วยหน้าจำนวนมาก';
$string['pmadvancedfeed_viewmore'] = 'ดูเพิ่มเติม';
$string['pmadvancedfeed_reload'] = 'รีเฟรช';
$string['multimediacard'] = 'ไฟล์มัลติมีเดียจะไม่แสดงในมุมมองบัตรกิจกรรมสำหรับรูปแบบ Snap วิธีการนี้จะใช้ในโฮมเพจและหน้ารายวิชาสำหรับกิจกรรมเล็กๆ และบัตรแหล่งข้อมููลเท่านั้น';
$string['enabledlogin'] = 'ตัวเลือกล็อกอินที่แสดง';
$string['enabledlogindesc'] = 'เลือกตัวเลือกล็อกอินที่ควรแสดง';
$string['moodlelogin'] = 'แสดงล็อกอิน Moodle เท่านั้น';
$string['alternativelogin'] = 'แสดงตัวเลือกล็อกอินทางเลือกเท่านั้น';
$string['bothlogin'] = 'แสดงตัวเลือกล็อกอินทั้งคู่';
$string['enabledloginorder'] = 'ลำดับตัวเลือกล็อกอิน';
$string['enabledloginorderdesc'] = 'เลือกตัวเลือกล็อกอินที่ควรแสดงเป็นอันดับแรก';
$string['moodleloginfirst'] = 'แสดงล็อกอิน Moodle อันดับแรก';
$string['alternativeloginfirst'] = 'แสดงตัวเลือกล็อกอินทางเลือกเป็นอันดับแรก';
$string['alternativeloginoptions'] = 'ตัวเลือกล็อกอินทางเลือก';
$string['openmessagedrawer'] = 'เปิดช่องเก็บข้อความ';
$string['refreshdeadlinestask'] = 'รีเฟรชข้อมูลแคชเวลาครบกำหนด ซึ่งจะทำงานก่อนที่ผู้ใช้งานทั้งหมดเข้าสู่ระบบ';
$string['resetdeadlinesquerycounttask'] = 'รีเซ็ตวันครบกำหนดของจำนวนคำถาม';
$string['refreshdeadlinestaskoff'] = 'ไม่ได้ค้นหาข้อมูลเพื่อรวบรวมข้อมูล โปรดเปิดการตั้งค่า “รีเฟรชกำหนดเวลาสิ้นสุดโดยใช้งานที่ตั้งเวลาไว้” ในการตั้งค่าเมนู Snap’s Personal เพื่ออนุญาตให้งานนี้ทำการรวบรวมข้อมูลที่แคชกำหนดเวลาสิ้นสุด';
$string['activityrestriction'] = 'ข้อบังคับกิจกรรม';
$string['hideandshowactioncb'] = 'ซ่อนและแสดงการดำเนินการของกล่องกาเครื่องหมายกิจกรรม';
$string['retryfeed'] = 'ฟีดไม่สามารถใช้งานได้ในขณะนี้ โปรดลองใหม่อีกครั้งในภายหลัง ฟีด: {$a}';
$string['loadingfeed'] = 'กำลังโหลด...อาจใช้เวลาสักครู่';
$string['hvpcustomcss'] = 'H5P CSS แบบกำหนดเอง';
$string['hvpcustomcssdesc'] = 'CSS แบบกำหนดเองสำหรับโมดูล H5P (moodle.org/plugins/mod_hvp) หากมีการติดตั้งไว้';
$string['courselimitstrdanger'] = 'แถบความคืบหน้าถึงขีดจำกัดรายวิชาจะไม่ปรากฏ';
$string['courselimitstrwarning'] = 'หากมีรายวิชามากกว่า {$a} รายวิชา แถบความคืบหน้าจะไม่ปรากฏขึ้น';
$string['tilesformatcoursehomealttext'] = 'หน้าแรกของรายวิชา';
$string['editmodetiles'] = 'แก้ไขเนื้อหา';
$string['totop'] = 'ไปด้านบนสุด';
$string['loginsetting'] = 'หน้าเข้าสู่ระบบ';
$string['loginbgimgheading'] = 'เทมเพลตหน้าเข้าสู่ระบบ';
$string['loginbgimgheadingdesc'] = 'Snap ช่วยให้สามารถเปลี่ยนแปลงระหว่างเทมเพลตที่แตกต่างกันที่ต้องการแสดงในหน้าการเข้าสู่ระบบ โปรดเลือกระหว่างตัวเลือกต่างๆ ในเมนูดร็อปดาวน์ด้านล่าง';
$string['loginpagetemplate'] = 'เลือกเทมเพลตหน้าเข้าสู่ระบบที่ต้องการใช้';
$string['classic_template'] = 'เทมเพลตคลาสสิค';
$string['loginbgimg'] = 'รูปภาพพื้นหลังการเข้าสู่ระบบ';
$string['loginbgimgdesc'] = 'เลือกภาพที่จะปรากฏบนพื้นหลังของหน้าการเข้าสู่ระบบ เพื่อให้ได้ประสบการณ์ในการแสดงภาพที่ดีขึ้น โปรดอัปโหลดไฟล์ที่มีอัตราส่วนภาพ 16:9 (ความละเอียด 720p หรือขนาด 1280x720 พิกเซล) ภาพที่อัปโหลดต้องมีขนาดเท่ากันเพื่อการแสดงภาพที่ถูกต้อง';
$string['stylish_template'] = 'เทมเพลตแบบมีสไตล์';
$string['activityedit'] = 'แก้ไขกิจกรรม';
$string['snapfeedsblocktitle'] = 'ฟีดสแนป';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'URL ของบัญชี TikTok ของคุณ';
$string['snapfootersettings'] = 'ส่วนท้าย Snap';
$string['snapfootercustomization'] = 'การกำหนดส่วนท้าย';
$string['snapfootercustomizationdesc'] = 'Snap อนุญาตการกำหนดส่วนท้ายของธีมด้วยตนเอง ซึ่งจะแสดงทั่วทั้งไซต์ เพิ่มประสบการณ์ผู้ใช้โดยการเพิ่มลิงก์ที่มีประโยชน์ ทรัพยากรสนับสนุน หรือข้อมูลที่มีค่าอื่นๆ เกี่ยวกับองค์กรของคุณที่คุณต้องการแชร์กับผู้เรียนและผู้สอน';
$string['snapfootercolors'] = 'สีส่วนท้ายของเว็บไซต์';
$string['snapfootercolorsdesc'] = 'เปลี่ยนสีส่วนท้ายได้: หากต้องการเปลี่ยนสีพื้นหลังและ/หรือสีข้อความ ให้เลือกในตัวเลือกสีต่อไปนี้';
$string['snapfooterbgcolor'] = 'สีพื้นหลังส่วนท้าย';
$string['snapfootertxtcolor'] = 'สีข้อความส่วนท้าย';
$string['enableblockmyoverviewwarning'] = 'บล็อกสรุปรายวิชาถูกปิดใช้งาน หากต้องการแสดงรายวิชา โปรดเปิดใช้งานบล็อก';
$string['collapseicon'] = 'ย่อเนื้อหาของ';
$string['expandicon'] = 'ขยายเนื้อหาของ';
$string['imageproperties'] = 'คุณสมบัติภาพ';
$string['coverimagedesc'] = 'เลือกภาพที่ต้องการนำเสนอบนหน้าปก โดยตรวจสอบให้มั่นใจว่าอยู่ในรูปแบบ .jpeg, .png หรือ .gif และไม่ควรมีขนาดไฟล์เกินกว่าค่าสูงสุดที่อนุญาตที่ระดับไซต์ ({$a}) เพื่อประสิทธิภาพการแสดงผลสูงสุด ให้มุ่งเป้าหมายไปที่อัตราส่วน 4:3 (1024x768 พิกเซล) นอกจากนี้ ให้พิจารณาการผสมสีที่สอดคล้องตามแนวทาง WCAG 2.0 โดยเฉพาะในด้านที่เกี่ยวข้องกับชื่อรายวิชาที่เป็นสีขาว เพื่อประสบการณ์ผู้ใช้งานที่ดีขึ้น';
$string['coverimagecropperdesc'] = 'ใช้กล่องครอบตัดเพื่อเลือกพื้นที่ของรูปภาพที่ต้องการแสดง';
$string['browserepositories'] = 'เพิ่มรูปภาพใหม่';
$string['saveimage'] = 'บันทึกภาพ';
$string['selectimage'] = 'เลือกรูปภาพ';
$string['deleteimage'] = 'ลบภาพหน้าปก';
$string['confirmdeletefile'] = 'การดำเนินการนี้จะลบภาพหน้าปก คุณแน่ใจหรือไม่ว่าต้องการลบไฟล์ที่บันทึกไว้';
$string['coverimagesettingswarning'] = 'หากคุณอัปเดตภาพหน้าปกโดยตรงจากการตั้งค่ารายวิชา ภาพหน้าปกที่ครอบตัดจะรีเซ็ต โปรดอย่าลืมเลือกการครอบตัดที่ต้องการหลังจากนั้น';
$string['opens'] = 'เปิด {$a}';
$string['opened'] = 'เปิด {$a} แล้ว';
$string['year'] = 'ปี';
$string['homepage'] = 'หน้าแรก';
$string['allyears'] = 'ปีทั้งหมด';
$string['courselink'] = 'ไปที่รายวิชา';
