<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2024 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'À propos de ce cours';
$string['activity'] = 'Activité';
$string['action:changeassetvisibility'] = 'modifier la visibilité des ressources';
$string['action:duplicateasset'] = 'dupliquer la ressource';
$string['action:changesectionvisibility'] = 'modifier la visibilité des sections';
$string['action:highlightsectionvisibility'] = 'mettre en surbrillance la visibilité des sections';
$string['action:sectiontoc'] = 'obtenir la table des matières de section';
$string['addanewsection'] = 'Créer une section';
$string['addresourceoractivity'] = 'Créer une activité d\'apprentissage';
$string['admin'] = 'Admin';
$string['advancedbrandingheading'] = 'Personnalisation avancée';
$string['ago'] = 'Il y a';
$string['answered'] = 'Répondu';
$string['appendices'] = 'Outils';
$string['arialabelnewsarticle'] = 'article de presse';
$string['assigndraft'] = 'Brouillon nécessitant votre confirmation';
$string['assignreopened'] = 'Réouvert';
$string['at'] = 'à';
$string['attempted'] = 'Tentative effectuée';
$string['basics'] = 'Essentiel';
$string['brandingheading'] = 'Personnalisation';
$string['browse'] = 'parcourir';
$string['browseallcourses'] = 'Parcourir tous les cours';
$string['cachedef_activity_deadlines'] = 'Entrepôt de cache des échéances des activités d\'un utilisateur.';
$string['cachedef_generalstaticappcache'] = 'Cache Snap statique général au niveau de l\'application';
$string['cachedef_course_completion_progress'] = 'Ceci est utilisé pour mettre en cache les données d\'achèvement par cours/utilisateur.';
$string['cachedef_course_completion_progress_ts'] = 'Ceci est utilisé pour que nous puissions invalider les caches au niveau des sessions si les paramètres d\'achèvement changent pour un cours ou un module.';
$string['cachedef_webservicedefinitions'] = 'Mise en cache des définitions de service Web générées automatiquement.';
$string['card'] = 'Carte';
$string['categoryedit'] = 'Modifier une catégorie';
$string['category_color'] = 'Couleur de la catégorie';
$string['category_color_description'] = 'Couleur de la catégorie du cours. Les cours enfants adoptent la configuration de la catégorie du parent le plus proche';
$string['category_color_palette'] = 'Palette de couleurs';
$string['category_color_palette_description'] = 'Examinez la valeur hexadécimale correspondante pour la couleur considérée. Aucune configuration n\'est affectée, il s\'agit simplement d\'un échantillon aidant les utilisateurs à générer la valeur de configuration.';
$string['changecoverimage'] = 'Modifier l\'image de couverture';
$string['changefullname'] = 'Modifier nom du site';
$string['chapters'] = 'Chapitres';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Fermer';
$string['conditional'] = 'Conditionnel';
$string['contents'] = 'Contenus';
$string['contributed'] = 'Contribution apportée';
$string['courses'] = 'Cours';
$string['coursecontacts'] = 'Contacts de cours';
$string['coursedisplay'] = 'Affichage du cours';
$string['coursefootertoggle'] = 'Pied de page du cours';
$string['coursefootertoggledesc'] = 'Le pied de page de cours affiche des informations utiles pour les utilisateurs sur une page de cours, notamment les contacts de cours, la description du cours et l\'activité récente dans le cours.';
$string['courseformatnotification'] = 'Le format de cours que vous utilisez actuellement n\'est pas totalement pris en charge par le thème&nbsp;Snap. Open LMS recommande d\'utiliser les formats de cours Hebdomadaire et Rubrique avec le thème Snap pour bénéficier de la meilleure expérience. Le format de cours peut être modifié dans les <a href="{$a}">réglages du cours</a>.';
$string['coursefixydefaulttext'] = 'Vous n\'êtes inscrit à aucun cours actuellement.<br>Les cours auxquels vous êtes inscrit sont affichés ici.';
$string['coursegrade'] = 'Note du cours&nbsp;:';
$string['coursepartialrender'] = 'Activer le chargement différé des sections de cours';
$string['coursepartialrenderdesc'] = 'Si ce paramètre est activé, les sections de cours sont chargées lorsque l\'utilisateur les sélectionne. Cela permet de charger les cours volumineux plus rapidement.';
$string['coursenavigation'] = 'Navigation de cours';
$string['coursesummaryfilesunsuitable'] = 'Videz vos fichiers de cours avant de tenter de modifier l\'image de couverture';
$string['courseactionslabel'] = 'actions';
$string['courseactivitieslabel'] = 'Activités de la section';
$string['coursetools'] = 'Tableau de bord du cours';
$string['coverdisplay'] = 'Affichage de la couverture';
$string['covercarousel'] = 'Carrousel de couverture';
$string['covercarousellabel'] = 'Carrousel';
$string['covercarouselon'] = 'Utiliser le carrousel de couverture';
$string['covercarouseldescription'] = '<p>Le carrousel est un ensemble de bannières rotatives, ou diaporama, qui s\'affiche sur la page d\'accueil de votre site à la place de l\'image de couverture.</p>
<p>Ajoutez jusqu\'à 3&nbsp;images, un titre pour chaque diapositive et un sous-titre facultatif. La résolution optimale des images est de 1200&nbsp;x&nbsp;600 pixels.</p>';
$string['covercarouselsronly'] = 'Il s\'agit d\'un carrousel avec des diapositives à rotation automatique. Activez l\'un des boutons pour désactiver la rotation. Utilisez les boutons Suivant et Précédent pour naviguer, ou passez à une diapositive en utilisant les points de la diapositive.';
$string['covercarouselplaybutton'] = 'Reprendre les diapositives à rotation automatique pour le carrousel.';
$string['covercarouselpausebutton'] = 'Mettre en pause les diapositives à rotation automatique pour le carrousel.';
$string['coverimage'] = 'Image de couverture';
$string['covervideo'] = 'Vidéo de couverture';
$string['comingsoon'] = 'Bientôt disponible&nbsp;!';
$string['createsection'] = 'Créer une section';
$string['current'] = 'Actuelle';
$string['customcss'] = 'CSS personnalisé';
$string['customcssdesc'] = 'Vous êtes responsable des actions que vous exécutez. Il vous incombera de résoudre tout problème causé par le code CSS ajouté ici. L\'assistance Open LMS ne fournit aucun dépannage ni aucune aide concernant le contenu CSS.';
$string['customtopbar'] = 'Barre de navigation';
$string['customisenavbar'] = 'Modifier les couleurs de la barre de navigation';
$string['customisenavbutton'] = 'Modifier les couleurs du bouton Mes cours';
$string['customisecustommenu'] = 'Modifier la couleur du texte du menu personnalisé';
$string['custommenutext'] = 'Couleur du texte du menu personnalisé';
$string['deadlines'] = 'Échéance';
$string['deadlinestoggle'] = 'Échéance';
$string['deadlinestoggledesc'] = 'Montrer aux utilisateurs les échéances des activités à venir des cours auxquels ils sont inscrits.';
$string['defaultsummary'] = 'Utilisez cette zone pour décrire le thème de cette rubrique. Vous pouvez insérer du texte, des images, ainsi que des contenus audio et vidéo.';
$string['defaultintrosummary'] = 'Bienvenue dans votre nouveau cours {$a}.<br>Commencez par décrire le thème de votre cours à l\'aide de texte, d\'images, ainsi que de contenus audio et vidéo.';
$string['defaultsectiontitle'] = 'Section sans titre';
$string['debugerrors'] = 'Erreurs de débogage';
$string['deleteassetconfirm'] = 'Supprimer {$a}';
$string['deletingasset'] = 'Suppression de l\'élément {$a}';
$string['deletingassetname'] = 'Suppression de l\'élément {$a->type} "{$a->name}"';
$string['deletesectionconfirm'] = 'Supprimer la section';
$string['deletingsection'] = 'Suppression de la section "{$a}"';
$string['draft'] = 'Non publié pour les étudiants';
$string['dropzonelabel'] = 'Faites glisser les fichiers à attacher ou <span class="fake-link">recherchez-les</span>';
$string['due'] = 'À rendre le {$a}';
$string['edit'] = 'Modifier "{$a}"';
$string['editcoursecontent'] = 'Modifier les blocs';
$string['editcoursesettings'] = 'Paramètres de cours';
$string['editcoursetopic'] = 'Modifier la section';
$string['editcustomfooter'] = 'Modifier le pied de page';
$string['editcustommenu'] = 'Modifier le menu personnalisé';
$string['error'] = 'Erreur';
$string['errorgettingfeed'] = 'Une erreur est survenue lors de l\'obtention des éléments de flux.';
$string['error:categorycolorinvalidjson'] = 'Format JSON incorrect pour les catégories de cours';
$string['error:categorycolorinvalidvalue'] = 'L\'identifiant d\'enregistrement ou la valeur de couleur pour la catégorie "{$a}" ne sont pas valides.';
$string['error:categorynotfound'] = 'L\'enregistrement de catégorie associé à l\'identifiant "{$a}" n\'a pas été trouvé';
$string['error:coverimageexceedsmaxbytes'] = 'L\'image de couverture dépasse la taille maximale de fichier autorisée au niveau du site ({$a})';
$string['error:coverimageresolutionlow'] = 'Pour une qualité optimale, nous recommandons de choisir une image plus grande d\'une largeur d\'au moins 1024&nbsp;px.';
$string['error:duplicatedcategoryids'] = 'Format JSON incorrect, certains identifiants ont été dupliqués';
$string['error:failedtochangeassetvisibility'] = 'Échec de l\'action Masquer/Afficher sur la ressource';
$string['error:failedtochangesectionvisibility'] = 'Échec de l\'action Masquer/Afficher sur la section';
$string['error:failedtohighlightsection'] = 'Échec de la mise en surbrillance de la section';
$string['error:failedtoduplicateasset'] = 'Échec de la duplication';
$string['error:failedtodeleteasset'] = 'Impossible de supprimer la ressource';
$string['error:failedtotoc'] = 'Impossible d\'obtenir la table des matières.';
$string['extension'] = 'Extension {$a}';
$string['extra_section_menu'] = 'Menu de section supplémentaire';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'URL de votre page Facebook.';
$string['favicon'] = 'Icône de favori';
$string['favicondesc'] = 'Les icônes de favori apparaissent dans la barre d\'adresse de votre navigateur Web, dans les marque-pages de l\'utilisateur et dans les raccourcis mobiles.';
$string['favorite'] = 'Favori {$a}';
$string['favorited'] = 'Ajouté aux favoris {$a}';
$string['featurespots'] = 'Emplacements de fonctionnalités';
$string['featurespotsedit'] = 'Modifier les emplacements de fonctionnalités';
$string['featurespotshelp'] = '<p>Ajoutez jusqu\'à 6 emplacements de fonctionnalités à la page d\'accueil de votre site pour mettre en évidence les avantages principaux pour les utilisateurs actifs et potentiels.</p>
<p>Vous pouvez ajouter une image, un titre et une description de contenu à chaque fonctionnalité. <strong>Pour afficher la fonctionnalité sur la première page, vous devez saisir un titre.</strong> Les sections Image et Description du contenu sont facultatives.</p>
<p>La taille d\'image recommandée est un carré et ne doit pas dépasser 200&nbsp;px par 200&nbsp;px.</p>';
$string['featurespotsheading'] = 'Titre des emplacements de fonctionnalités';
$string['featureonetitle'] = 'Titre de la fonctionnalité 1';
$string['featuretwotitle'] = 'Titre de la fonctionnalité 2';
$string['featurethreetitle'] = 'Titre de la fonctionnalité 3';
$string['featurefourtitle'] = 'Titre de la fonctionnalité 4';
$string['featurefivetitle'] = 'Titre de la fonctionnalité 5';
$string['featuresixtitle'] = 'Titre de la fonctionnalité 6';
$string['featureonetitlelink'] = 'Lien du titre de la fonctionnalité&nbsp;1';
$string['featuretwotitlelink'] = 'Lien du titre de la fonctionnalité&nbsp;2';
$string['featurethreetitlelink'] = 'Lien du titre de la fonctionnalité&nbsp;3';
$string['featurefourtitlelink'] = 'Lien du titre de la fonctionnalité&nbsp;4';
$string['featurefivetitlelink'] = 'Lien du titre de la fonctionnalité&nbsp;5';
$string['featuresixtitlelink'] = 'Lien du titre de la fonctionnalité&nbsp;6';
$string['featuretitlelinkdesc'] = 'Saisissez l\'URL à laquelle vous souhaitez lier cet emplacement de fonctionnalité. Vous pouvez ajouter des liens externes et internes sur votre site. Pour ajouter un lien externe, copiez-le à partir de l\'URL du site en incluant la barre oblique («&nbsp;/&nbsp;»). Par exemple, pour ajouter un lien vers un cours, copiez «&nbsp;/course/view.php?id=160&nbsp;». Pour ajouter un lien externe, le lien doit commencer par https://';
$string['featureonetitlecb'] = 'La fonctionnalité&nbsp;1 s\'ouvre dans une nouvelle fenêtre';
$string['featuretwotitlecb'] = 'La fonctionnalité&nbsp;2 s\'ouvre dans une nouvelle fenêtre';
$string['featurethreetitlecb'] = 'La fonctionnalité&nbsp;3 s\'ouvre dans une nouvelle fenêtre';
$string['featurefourtitlecb'] = 'La fonctionnalité&nbsp;4 s\'ouvre dans une nouvelle fenêtre';
$string['featurefivetitlecb'] = 'La fonctionnalité&nbsp;5 s\'ouvre dans une nouvelle fenêtre';
$string['featuresixtitlecb'] = 'La fonctionnalité&nbsp;6 s\'ouvre dans une nouvelle fenêtre';
$string['featuretitlecbdesc'] = 'Lorsque cette option est activée, le lien ajouté à l\'emplacement de fonctionnalité s\'ouvre dans une nouvelle fenêtre';
$string['featureonetext'] = 'Contenu de la fonctionnalité 1';
$string['featuretwotext'] = 'Contenu de la fonctionnalité 2';
$string['featurethreetext'] = 'Contenu de la fonctionnalité 3';
$string['featurefourtext'] = 'Contenu de la fonctionnalité 4';
$string['featurefivetext'] = 'Contenu de la fonctionnalité 5';
$string['featuresixtext'] = 'Contenu de la fonctionnalité 6';
$string['featureoneimage'] = 'Image de la fonctionnalité 1';
$string['featuretwoimage'] = 'Image de la fonctionnalité 2';
$string['featurethreeimage'] = 'Image de la fonctionnalité 3';
$string['featurefourimage'] = 'Image de la fonctionnalité 4';
$string['featurefiveimage'] = 'Image de la fonctionnalité 5';
$string['featuresiximage'] = 'Image de la fonctionnalité 6';
$string['featuredcategoriesandcourses'] = 'Catégories et cours mis en avant';
$string['featuredcourses'] = 'Cours mis en avant';
$string['featuredcourseshelp'] = 'Mettez en avant jusqu\'à 8 cours sur la page d\'accueil de votre site. Saisissez l\'identifiant de cours pour mettre en avant un cours.';
$string['featuredcoursesheading'] = 'Titre du cours mis en avant';
$string['featuredcourseone'] = 'Cours mis en avant 1';
$string['featuredcoursetwo'] = 'Cours mis en avant 2';
$string['featuredcoursethree'] = 'Cours mis en avant 3';
$string['featuredcoursefour'] = 'Cours mis en avant 4';
$string['featuredcoursefive'] = 'Cours mis en avant 5';
$string['featuredcoursesix'] = 'Cours mis en avant 6';
$string['featuredcourseseven'] = 'Cours mis en avant 7';
$string['featuredcourseeight'] = 'Cours mis en avant 8';
$string['featuredcoursesedit'] = 'Modifier les cours mis en avant';
$string['featuredcoursesbrowseall'] = 'Parcourir tous les cours';
$string['featuredcoursesbrowsealldesc'] = 'Ajouter un lien Parcourir tous les cours';
$string['featuredcategories'] = 'Catégories mises en avant';
$string['featuredcategorieshelp'] = 'Mettez en avant jusqu\'à 8&nbsp;catégories sur la page d\'accueil de votre site. Saisissez l\'identifiant de catégorie pour mettre en avant une catégorie.';
$string['featuredcategoriesheading'] = 'Titre des catégories mises en avant';
$string['featuredcategoryone'] = 'Catégorie mise en avant&nbsp;1';
$string['featuredcategorytwo'] = 'Catégorie mise en avant&nbsp;2';
$string['featuredcategorythree'] = 'Catégorie mise en avant&nbsp;3';
$string['featuredcategoryfour'] = 'Catégorie mise en avant&nbsp;4';
$string['featuredcategoryfive'] = 'Catégorie mise en avant&nbsp;5';
$string['featuredcategoriesix'] = 'Catégorie mise en avant&nbsp;6';
$string['featuredcategorieseven'] = 'Catégorie mise en avant&nbsp;7';
$string['featuredcategoryeight'] = 'Catégorie mise en avant&nbsp;8';
$string['featuredcategoriesedit'] = 'Modifier les catégories mises en avant';
$string['featuredcategoriesbrowseall'] = 'Parcourir toutes les catégories';
$string['featuredcategoriesbrowsealldesc'] = 'Ajouter un lien Parcourir toutes les catégories';
$string['feature_spot_background_color'] = 'Couleur du fond';
$string['feature_spot_title_color'] = 'Couleur du texte du titre';
$string['feature_spot_description_color'] = 'Couleur du texte de description';
$string['feature_spot_title_color_lower'] = 'couleur du texte du titre';
$string['feature_spot_description_color_lower'] = 'couleur du texte de la description';
$string['feedbackavailable'] = 'Feed-back disponible';
$string['feedbacktoggle'] = 'Feed-back et notation';
$string['feedbacktoggledesc'] = 'Montrez aux élèves leurs feed-backs les plus récents, et aux formateurs les travaux remis les plus récents devant être notés.';
$string['footnote'] = 'Pied de page du site';
$string['footnotedesc'] = 'Vous pouvez ajouter les informations de votre site au format HTML et inclure des liens, des images ou des listes d\'événements.';
$string['forcepwdwarningpersonalmenu'] = 'Vous devez <a href="{$a}">changer votre mot de passe</a> avant d\'utiliser le menu personnel.';
$string['forumauthor'] = 'Auteur';
$string['forumlastpost'] = 'Dernier message';
$string['forumpicturegroup'] = 'Groupe';
$string['forumreplies'] = 'Réponses';
$string['forumtopic'] = 'Rubrique';
$string['forumposts'] = 'Messages de forum';
$string['forumpoststoggle'] = 'Messages de forum';
$string['forumpoststoggledesc'] = 'Montrer aux utilisateurs les 10 messages de forum les plus récents provenant de leurs cours';
$string['fullname'] = 'Nom du site';
$string['fullnamedesc'] = 'Nom de votre site.';
$string['gotoactivity'] = 'Accéder à l\'activité {$a}';
$string['graderadviseuserreport'] = 'Le "rapport de l\'évaluateur" ne fonctionne pas de façon optimale sur les appareils mobiles. Utilisez le "rapport de l\'utilisateur" à la place';
$string['grading'] = 'Évaluation';
$string['help'] = 'Aide';
$string['helpguide'] = 'Guide d\'aide';
$string['headingfont'] = 'Police de titre';
$string['headingfont_desc'] = 'Cette police sans-serif est utilisée dans les titres (éléments&nbsp;h1 à h6) de votre site. Si vous incluez une police Web personnalisée, n\'oubliez pas de l\'ajouter au fichier HTML supplémentaire Moodle. Si vous souhaitez modifier les polices d\'autres éléments, utilisez l\'option CSS personnalisé. Pour obtenir des exemples sur la façon de procéder, consultez la <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">documentation</a>.';
$string['helpwithlogin'] = 'Aide à la connexion';
$string['helpwithloginandguest'] = 'Aide à la connexion/l\'accès anonyme';
$string['loginrequiredmessage'] = '*&nbsp;indique un champ obligatoire';
$string['hiddencoursestoggle'] = 'Cours masqués';
$string['highlightedsection'] = 'mis en surbrillance';
$string['home'] = 'accueil';
$string['image'] = 'image';
$string['images'] = 'Images';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'URL de votre compte Instagram.';
$string['introduction'] = 'Introduction';
$string['jsontext'] = 'Texte JSON';
$string['jsontextdescription'] = 'La zone de texte valide le texte JSON considéré, de manière à ce que seules les catégories existantes soient autorisées, à ce que les seules les valeurs numériques sous forme d\'enregistrements d\'identifiants (enregistrements de catégories) soient valides et à ce que seules les valeurs hexadécimales soient acceptées en tant que couleurs. Voici un exemple&nbsp;:<br>{"1":"#FAAFFF",<br>"45":"#AFF",<br>"65":"#FFF228",<br>"12":"#CC0084",<br>"56":"#CC0087",<br>"89":"#CCF084"}';
$string['knowledgebase'] = 'Base de connaissances Open LMS';
$string['list'] = 'Liste';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'URL de la page LinkedIn de votre organisation.';
$string['leftnav'] = 'Table des matières';
$string['leftnavdesc'] = 'Choisissez où afficher la table des matières. La liste permet d\'afficher plus de contenu et est pratique pour les cours comportant de nombreuses rubriques.';
$string['loading'] = 'Chargement en cours...';
$string['loggedinasguest'] = 'Vous êtes connecté en tant qu\'utilisateur anonyme';
$string['loggedoutmsg'] = 'Vous êtes actuellement déconnecté. Si vous souhaitez continuer à utiliser ce site, reconnectez-vous.';
$string['loggedoutmsgtitle'] = 'Vous êtes déconnecté.';
$string['loggedoutfailmsg'] = 'Vous devez être connecté à {$a}.';
$string['loginform'] = 'Connexion';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Votre logo est affiché dans l\'en-tête sur tout le site.';
$string['menu'] = 'Mes cours';
$string['messageread'] = 'Message lu';
$string['messages'] = 'Messages';
$string['messagestoggle'] = 'Messages';
$string['messagestoggledesc'] = 'Afficher les messages les plus récents reçus par les utilisateurs au cours des 12&nbsp;dernières semaines. Pour activer cette option, assurez-vous que la fonction de messagerie sur la page Fonctions avancées est activée.';
$string['more'] = 'Plus';
$string['morenews'] = 'Plus de nouvelles';
$string['moreoptionslabel'] = 'Plus d’options';
$string['movingstartedhelp'] = 'Accéder à l\'emplacement où vous souhaitez insérer la section "{$a}"';
$string['movingdropsectionhelp'] = 'Insérer la section "{$a->moving}" avant la section "{$a->before}"';
$string['moving'] = 'Déplacement de "{$a}"';
$string['movingcount'] = 'Déplacement de {$a} objets';
$string['movefailed'] = 'Échec du déplacement pour "{$a}"';
$string['move'] = 'Déplacer «&nbsp;{$a}&nbsp;»';
$string['movehere'] = 'Déplacer ici';
$string['movesection'] = 'Déplacer la section';
$string['navbarbg'] = 'Couleur du fond';
$string['navbarlink'] = 'Couleur du texte';
$string['navbarbuttoncolor'] = 'Couleur du fond';
$string['navbarbuttonlink'] = 'Couleur du texte';
$string['nextsection'] = 'Section suivante';
$string['nodeadlines'] = 'Vous n\'avez pas d\'échéances à venir.';
$string['noforumposts'] = 'Aucun message de forum à afficher.';
$string['nograded'] = 'Vous n\'avez aucun feed-back récent.';
$string['nograding'] = 'Vous n\'avez aucun travail remis à noter.';
$string['nomessages'] = 'Vous n\'avez pas de messages.';
$string['notanswered'] = 'Non répondue';
$string['notattempted'] = 'Aucune tentative';
$string['notcontributed'] = 'Contribution non apportée';
$string['notpublished'] = 'Non publié pour les étudiants';
$string['notsubmitted'] = 'Non remis';
$string['overdue'] = 'En retard';
$string['pausegraphicsanim'] = 'Mettre en pause l\'animation GIF.';
$string['personalmenu'] = 'Menu personnel';
$string['personalmenuandsnapfeeds'] = 'Menu personnel et flux de Snap';
$string['personalmenufeatures'] = 'Fonctionnalités du menu personnel';
$string['personalmenulogintoggle'] = 'Afficher le menu personnel lors de la connexion';
$string['personalmenulogintoggledesc'] = 'Ouvre immédiatement le menu personnel après la connexion';
$string['personalmenuadvancedfeedsenable'] = 'Activer les flux avancés';
$string['personalmenuadvancedfeedsenabledesc'] = 'Les flux avancés chargent des éléments de menu personnalisés, ce qui permet de réduire les temps de chargement et d\'actualiser le contenu sur demande.';
$string['personalmenuadvancedfeedsperpage'] = 'Nombre d\'éléments d\'affichage des flux avancés';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Choisissez le nombre d\'éléments à afficher dans le flux. Les utilisateurs pourront sélectionner l\'option <strong>Voir plus</strong> pour afficher davantage d\'éléments.';
$string['personalmenuadvancedfeedslifetime'] = 'Durée de vie des flux avancés';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Choisissez la durée pendant laquelle les flux seront mis en cache dans le navigateur après connexion. Sélectionner une valeur de 0 empêchera la mise en cache des flux dans le navigateur.';
$string['personalmenurefreshdeadlines'] = 'Actualiser les échéances à l\'aide d\'une tâche planifiée.';
$string['personalmenurefreshdeadlinesdesc'] = 'Lorsque la tâche s\'exécute, les données d\'échéance seront actualisées pour permettre un chargement plus rapide des pages.';
$string['personalmenuenablepersonalmenu'] = 'Activer le menu personnel';
$string['personalmenuenablepersonalmenuheading'] = 'Menu personnel';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'Remarque&nbsp;: si le menu personnel est désactivé, vous pourrez accéder à vos cours à partir de la page Mes cours. Assurez-vous que le bloc Présentation du cours est activé afin que les cours soient visibles sur la page.';
$string['personalmenuenablepersonalmenudesc'] = 'Le lien Mes cours ouvre le menu personnel. Si cette option est désactivée, le lien redirigera vers la page Mes cours.';
$string['mycoursessnapfeedsheading'] = 'Flux de Snap';
$string['mycoursessnapfeedsdesc'] = 'Remarque&nbsp;: <strong>les flux avancés</strong> deviennent disponibles uniquement si au moins l\'une des options <strong>Délais</strong>, <strong>Commentaires et notation</strong>, <strong>Messages</strong> ou <strong>Publications du forum</strong> est sélectionnée.';
$string['refreshdeadlinestasksettingheading'] = 'Actualiser les échéances d\'une tâche planifiée';
$string['pld'] = 'CPP';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Image de couverture';
$string['posterdesc'] = 'Image d\'en-tête de grande taille destinée à la page d\'accueil de votre site. Les images en mode paysage (1200&nbsp;pixels x 600&nbsp;pixels ou plus) sont plus optimales.';
$string['poweredbyrunby'] = 'Conçu avec <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>, un produit basé sur <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>Copyright © {$a->year} Open LMS, tous droits réservés.';
$string['previoussection'] = 'Section précédente';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'Identifiant du cours que l\'utilisateur a ajouté à ses favoris';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'Identifiant de l\'utilisateur qui a ajouté le cours à ses favoris';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'Horodatage de l\'ajout du cours aux favoris de l\'utilisateur';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Enregistre les cours favoris de l\'utilisateur pour Snap';
$string['problemsfound'] = 'Problèmes détectés';
$string['progress'] = 'Progression';
$string['readmore'] = 'Lire la suite&nbsp;»';
$string['recentactivity'] = 'Activité récente';
$string['recentfeedback'] = 'Feed-backs';
$string['region-main'] = 'Menu principal';
$string['region-side-main-box'] = 'Menu principal';
$string['region-side-post'] = 'Droit';
$string['region-side-pre'] = 'Gauche (flottant)';
$string['region-side-top'] = 'En haut';
$string['released'] = 'Version&nbsp;: {$a}';
$string['reopened'] = 'Réouvert';
$string['resourcedisplay'] = 'Affichage des ressources';
$string['resourcedisplayhelp'] = 'Sélectionnez le mode d\'affichage des pièces jointes et des liens dans votre cours. Le thème Snap ne prend pas en charge les fichiers multimédias dans la brève description des fiches de ressources et d\'activité.';
$string['resumegraphicsanim'] = 'Reprendre l\'animation GIF.';
$string['displaydescription'] = 'Afficher la description';
$string['displaydescriptionhelp'] = 'Choisissez d\'afficher une description de la ressource et des activités dans une nouvelle page d\'abord. Les étudiants accéderont au contenu depuis la description.';
$string['search'] = 'Rechercher du contenu';
$string['showcoursegradepersonalmenu'] = 'Notes';
$string['showcoursegradepersonalmenudesc'] = 'Montrer aux utilisateurs leur note dans les cartes de cours dans le menu personnel';
$string['socialmedia'] = 'Réseau social';
$string['submitted'] = 'Devoir soumis';
$string['sitedescription'] = 'Description du site';
$string['subtitle'] = 'Sous-titre';
$string['subtitle_desc'] = 'Décrivez brièvement votre site pour les utilisateurs.';
$string['summarylabel'] = 'Sommaire de la section';
$string['themecolor'] = 'Couleur des sites';
$string['themecolordesc'] = 'Les couleurs claires fonctionnent mieux et donneront une apparence moderne à votre site.';
$string['title'] = 'Titre';
$string['top'] = 'En haut';
$string['topbarbgcolor'] = 'Couleur de la barre de navigation';
$string['topbarlinkcolor'] = 'Couleur de l\'icône et du lien de la barre de navigation';
$string['topbarbuttoncolor'] = 'Arrière-plan de Mes cours';
$string['togglenavigation'] = 'Activer/désactiver la navigation';
$string['topicactions'] = 'Actions relatives à la rubrique';
$string['xakatwitter'] = '𝕏';
$string['xakatwitterdesc'] = 'URL de votre compte 𝕏 (Twitter).';
$string['unenrolme'] = 'Me désinscrire';
$string['enrolme'] = 'M\'inscrire';
$string['unread'] = 'non lu';
$string['unsupportedcoverimagetype'] = 'Type d\'image de couverture non pris en charge ({$a})';
$string['via'] = 'via';
$string['viewcourse'] = 'Afficher le cours';
$string['viewmore'] = 'Voir plus';
$string['viewyourprofile'] = 'Afficher votre profil';
$string['viewmyfeedback'] = 'Afficher mon feed-back';
$string['viewcalendar'] = 'Afficher mon calendrier';
$string['viewforumposts'] = 'Afficher mes messages du forum';
$string['viewmessaging'] = 'Afficher mes messages';
$string['vieworiginalimage'] = 'Afficher l\'image d\'origine';
$string['visibility'] = 'Visibilité';
$string['xofyanswered'] = '{$a->completed} sur {$a->participants} ont répondu';
$string['xofyattempted'] = '{$a->completed} sur {$a->participants} ont effectué une tentative';
$string['xofycontributed'] = '{$a->completed} sur {$a->participants} ont contribué';
$string['xofysubmitted'] = '{$a->completed} sur {$a->participants} remis';
$string['xungraded'] = '{$a} non noté';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'URL de votre chaîne YouTube.';
$string['showallsectionsdisabled'] = 'En raison de son langage de conception, la fonctionnalité d\'affichage de l\'ensemble des sections sur une seule page n\'est pas disponible sur Snap.';
$string['disabled'] = 'Désactivée';
$string['showappearancedisabled'] = 'Le langage de conception de Snap empêche les modifications des paramètres d\'apparence.';
$string['pbb'] = 'Personnalisation basée sur les profils';
$string['pbb_description'] = 'En activant <strong>Image de marque basée sur le profil</strong>, vous pourrez personnaliser l\'expérience de marque pour un groupe spécifique d\'utilisateurs en fonction du champ de profil utilisateur choisi.<ul><li>La valeur du champ utilisateur sera <em>slugified</em>&nbsp;; tous les caractères seront convertis en minuscules et séparés par un tiret (-).</li>
<li>La chaîne <code>snap-pbb-</code> sera ajoutée au début.</li>
<li>Cette classe sera ajoutée à la balise <code>body</code>.</li></ul>Par exemple, la valeur du champ utilisateur <em>Blueberry Extravaganza</em> sera «&nbsp;slugified&nbsp;» pour être <code>snap-pbb-blueberry-extravaganza</code><br /><br />Cette fonction est utilisée conjointement avec les CSS personnalisés. Vous devrez ajouter des sélecteurs CSS à l\'aide des nouvelles classes de la section <a class="snap-settings-tab-link" href="#themesnapbranding">Basique</a>.';
$string['pbb_enable'] = 'Activer la personnalisation basée sur les profils';
$string['pbb_enable_description'] = 'Ajoute uniquement la classe à la balise BODY si activée.';
$string['pbb_field'] = 'Champ utilisateur à utiliser';
$string['pbb_field_description'] = 'La valeur de ce champ sera convertie en slug et utilisée comme nom de classe CSS précédé de <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Mise en cache de la personnalisation basée sur les profils.';
$string['cachedef_course_card_bg_image'] = 'Mise en cache de l\'image d\'arrière plan du cours.';
$string['cachedef_course_card_teacher_avatar'] = 'Mise en cache des avatars des enseignants.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Mise en cache de l\'index des avatars des enseignants.';
$string['accessforumstringdis'] = 'Option d\'affichage';
$string['accessforumstringmov'] = 'Déplacer les options';
$string['accesscalendarstring'] = 'Calendrier';
$string['accessglobalsearchstring'] = 'Chercher';
$string['admineventwarning'] = 'Pour afficher les événements de tous les cours,';
$string['gotocalendarsnap'] = 'accédez au calendrier du site.';
$string['quizattemptswarn'] = 'Les tentatives des utilisateurs suspendus sont exclues';
$string['quizfeedback'] = 'Feed-backs';
$string['validratio'] = 'Cette combinaison de couleurs ne respecte pas la valeur de proportion minimum WCAG 2.0 de 4.5:1.';
$string['invalidratio'] = 'Cette combinaison de couleurs ne respecte pas la valeur de proportion minimum <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 de 4.5:1</a>. Valeur&nbsp;: «&nbsp;{$a}&nbsp;»';
$string['imageinvalidratio'] = 'Cette image ne respectant pas la valeur de proportion minimum WCAG 2.0 de 4.5:1, elle peut présenter des problèmes de contraste. Valeur moyenne de pixels&nbsp;: «&nbsp;{$a}&nbsp;»';
$string['catinvalidratio'] = 'Les catégories de couleurs suivantes ne respectent pas la <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">valeur de proportion minimum WCAG 2.0 de 4.5:1</a>&nbsp;: couleur d\'arrière-plan du site (blanc)&nbsp;: «&nbsp;{$a->white}&nbsp;». Couleur d\'arrière-plan de la barre de navigation&nbsp;: «&nbsp;{$a->custombar}&nbsp;». Couleur d\'arrière-plan du bouton Mes cours&nbsp;: «&nbsp;{$a->customnav}&nbsp;»';
$string['spotinvalidratio'] = 'La couleur d\'arrière-plan ne respecte pas la valeur de proportion minimum <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 de 4.5:1</a>. Couleur actuelle de {$a->name}&nbsp;: {$a->value}.';
$string['imageinvalidratiocategory'] = 'Cette image ne respectant pas la valeur de proportion minimum WCAG 2.0 de 4.5:1, elle peut présenter des problèmes de contraste avec la couleur du thème. Valeur moyenne de pixels&nbsp;: «&nbsp;{$a}&nbsp;»';
$string['browseallcategories'] = 'Parcourir toutes les catégories';
$string['lazyload_mod_page'] = 'Activer le chargement différé par défaut pour les ressources des pages';
$string['lazyload_mod_page_description'] = 'Lorsque ce paramètre est activé, il réduit de manière significative le temps de chargement des cours composés de nombreuses pages.';
$string['pmadvancedfeed_viewmore'] = 'Voir plus';
$string['pmadvancedfeed_reload'] = 'Actualiser';
$string['multimediacard'] = 'Les fichiers multimédias ne s\'afficheront pas dans la fiche d\'activité pour le thème Snap. Ceci sera appliqué à la page d\'accueil et aux pages de cours uniquement pour les brèves fiches de ressource et d\'activité.';
$string['enabledlogin'] = 'Options de connexion affichées';
$string['enabledlogindesc'] = 'Sélectionnez les options de connexion à afficher.';
$string['moodlelogin'] = 'Afficher la connexion à Moodle uniquement';
$string['alternativelogin'] = 'Afficher les autres options de connexion uniquement';
$string['bothlogin'] = 'Afficher les deux options de connexion';
$string['enabledloginorder'] = 'Ordre des options de connexion';
$string['enabledloginorderdesc'] = 'Sélectionnez l\'option de connexion à afficher en premier.';
$string['moodleloginfirst'] = 'Afficher la connexion à Moodle en premier';
$string['alternativeloginfirst'] = 'Afficher les autres options de connexion en premier';
$string['alternativeloginoptions'] = 'Autres options de connexion';
$string['openmessagedrawer'] = 'Ouvrir le tiroir de messagerie.';
$string['refreshdeadlinestask'] = 'Actualiser les échéances des données mises en cache. Cette tâche doit être exécutée avant que tous les utilisateurs se connectent.';
$string['resetdeadlinesquerycounttask'] = 'Réinitialiser le nombre de requêtes d\'échéance';
$string['refreshdeadlinestaskoff'] = 'Aucune recherche de données à remplir n’a été effectuée. Veuillez activer le paramètre «&nbsp;Actualiser les dates limites à l\'aide d\'une tâche planifiée&nbsp;» dans les paramètres du menu personnel de Snap pour permettre à cette tâche de renseigner les données mises en cache des dates limites.';
$string['activityrestriction'] = 'Restriction d\'activité';
$string['hideandshowactioncb'] = 'Masquer et afficher l\'action de la case à cocher d\'activité';
$string['retryfeed'] = 'Ce flux est actuellement indisponible, veuillez réessayer plus tard. Flux&nbsp;: {$a}';
$string['loadingfeed'] = 'En cours de chargement... L\'opération peut prendre du temps.';
$string['hvpcustomcss'] = 'CSS personnalisé&nbsp;H5P';
$string['hvpcustomcssdesc'] = 'CSS personnalisé pour le module&nbsp;H5P (moodle.org/plugins/mod_hvp) s\'il est installé.';
$string['courselimitstrdanger'] = 'La barre de progression de la limite de cours atteinte ne s\'affichera pas.';
$string['courselimitstrwarning'] = 'Si plus de {$a} cours sont répertoriés, la barre de progression ne s\'affichera pas';
$string['tilesformatcoursehomealttext'] = 'Page d\'accueil du cours';
$string['editmodetiles'] = 'Modifier le contenu';
$string['totop'] = 'Haut de page';
$string['loginsetting'] = 'Page de connexion';
$string['loginbgimgheading'] = 'Modèle de page de connexion';
$string['loginbgimgheadingdesc'] = 'Snap permet de basculer entre différents modèles à afficher sur la page de connexion. Veuillez choisir parmi les différentes options dans le menu déroulant ci-dessous.';
$string['loginpagetemplate'] = 'Sélectionnez le modèle de page de connexion à utiliser';
$string['classic_template'] = 'Modèle classique';
$string['loginbgimg'] = 'Image d\'arrière-plan de connexion';
$string['loginbgimgdesc'] = 'Sélectionnez les images qui apparaîtront en arrière-plan de la page de connexion. Pour une meilleure expérience avec les images affichées, veuillez charger des fichiers avec un rapport d\'aspect de 16:9 (résolution de 720p ou dimensions de 1280x720 pixels). Les images chargées doivent avoir les mêmes dimensions pour être correctement visualisées.';
$string['stylish_template'] = 'Modèle élégant';
$string['activityedit'] = 'Modifier une activité';
$string['snapfeedsblocktitle'] = 'Flux de Snap';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'URL de votre compte TikTok';
$string['snapfootersettings'] = 'Pied de page Snap';
$string['snapfootercustomization'] = 'Personnalisation du pied de page';
$string['snapfootercustomizationdesc'] = 'Snap permet de personnaliser le pied de page du thème, qui s\'affiche sur l\'ensemble du site. Améliorez l\'expérience utilisateur en ajoutant des liens utiles, des ressources d\'assistance ou toute autre information utile sur votre organisation que vous souhaitez partager avec les apprenants et les enseignants.';
$string['snapfootercolors'] = 'Couleurs du pied de page du site';
$string['snapfootercolorsdesc'] = 'Les couleurs du pied de page peuvent être modifiées&nbsp;: pour modifier la couleur d\'arrière-plan et/ou la couleur du texte, sélectionnez-les dans les nuanciers suivants.';
$string['snapfooterbgcolor'] = 'Couleur d\'arrière-plan du pied de page';
$string['snapfootertxtcolor'] = 'Couleur du texte du pied de page';
$string['enableblockmyoverviewwarning'] = 'Le bloc Présentation du cours est désactivé. Pour afficher les cours, veuillez activer le bloc.';
$string['collapseicon'] = 'Réduire le contenu de';
$string['expandicon'] = 'Développer le contenu de';
$string['imageproperties'] = 'Propriétés de l\'image';
$string['coverimagedesc'] = 'Sélectionnez l\'image de la couverture en vous assurant qu\'elle est au format .JPEG, .PNG ou .GIF. Elle ne doit pas dépasser la taille de fichier maximale autorisée au niveau du site ({$a}). Pour un affichage optimal, préférez un format d\'image de 4:3 (1&nbsp;024&nbsp;x&nbsp;768&nbsp;pixels). En outre, envisagez des combinaisons de couleurs conformes aux recommandations&nbsp;WCAG&nbsp;2.0, en particulier en ce qui concerne le titre blanc du cours, pour une meilleure expérience utilisateur.';
$string['coverimagecropperdesc'] = 'À l\'aide de la boîte de recadrage, sélectionnez la zone de l\'image qui sera affichée.';
$string['browserepositories'] = 'Charger une nouvelle image';
$string['saveimage'] = 'Enregistrer l\'image';
$string['selectimage'] = 'Sélectionner l\'image';
$string['deleteimage'] = 'Supprimer l\'image de couverture';
$string['confirmdeletefile'] = 'Cette opération supprime l\'image de couverture. Voulez-vous vraiment supprimer le fichier enregistré&nbsp;?';
$string['coverimagesettingswarning'] = 'Si vous mettez à jour l\'image de couverture directement à partir de la page des paramètres du cours, l\'image de couverture recadrée sera réinitialisée. N\'oubliez pas de resélectionner le cadrage souhaité par la suite.';
$string['opens'] = 'Ouvre {$a}';
$string['opened'] = '{$a} ouvert';
$string['year'] = 'Année';
$string['homepage'] = 'Page d\'accueil';
$string['allyears'] = 'Toutes les années';
$string['courselink'] = 'Accéder au cours';
