define("core_table/dynamic",["exports","core_table/local/dynamic/selectors","./local/dynamic/events","core/pending","core/loadingicon","core_table/local/dynamic/repository","core/notification"],(function(_exports,Selectors,_events,_pending,_loadingicon,_repository,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}Object.defineProperty(_exports,"__esModule",{value:!0}),Object.defineProperty(_exports,"Events",{enumerable:!0,get:function(){return _events.default}}),_exports.updateTable=_exports.showColumn=_exports.setSortOrder=_exports.setPageSize=_exports.setPageNumber=_exports.setLastInitial=_exports.setFirstInitial=_exports.setFilters=_exports.refreshTableContent=_exports.init=_exports.hideColumn=_exports.getTableFromId=_exports.getPageSize=_exports.getPageNumber=_exports.getLastInitial=_exports.getFirstInitial=_exports.getFilters=void 0,Selectors=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}
/**
   * Module to handle dynamic table features.
   *
   * @module     core_table/dynamic
   * @copyright  2020 Simey Lameze <simey@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */(Selectors),_events=_interopRequireDefault(_events),_pending=_interopRequireDefault(_pending),_notification=_interopRequireDefault(_notification);let watching=!1;const checkTableIsDynamic=tableRoot=>{if(!tableRoot)throw new Error("The table specified is not a dynamic table and cannot be updated");if(!tableRoot.matches(Selectors.main.region))throw new Error("The table specified is not a dynamic table and cannot be updated");return!0},getFiltersetFromTable=tableRoot=>JSON.parse(tableRoot.dataset.tableFilters),refreshTableContent=function(tableRoot){let resetContent=arguments.length>1&&void 0!==arguments[1]&&arguments[1];const filterset=getFiltersetFromTable(tableRoot);(0,_loadingicon.addIconToContainer)(tableRoot);const pendingPromise=new _pending.default("core_table/dynamic:refreshTableContent");return(0,_repository.fetch)(tableRoot.dataset.tableComponent,tableRoot.dataset.tableHandler,tableRoot.dataset.tableUniqueid,{sortData:JSON.parse(tableRoot.dataset.tableSortData),joinType:filterset.jointype,filters:filterset.filters,firstinitial:tableRoot.dataset.tableFirstInitial,lastinitial:tableRoot.dataset.tableLastInitial,pageNumber:tableRoot.dataset.tablePageNumber,pageSize:tableRoot.dataset.tablePageSize,hiddenColumns:JSON.parse(tableRoot.dataset.tableHiddenColumns)},resetContent).then((data=>{const placeholder=document.createElement("div");return placeholder.innerHTML=data.html,tableRoot.replaceWith(...placeholder.childNodes),getTableFromId(tableRoot.dataset.tableUniqueid)})).then((tableRoot=>(tableRoot.dispatchEvent(new CustomEvent(_events.default.tableContentRefreshed,{bubbles:!0})),tableRoot))).then((tableRoot=>(pendingPromise.resolve(),tableRoot)))};_exports.refreshTableContent=refreshTableContent;const updateTable=function(tableRoot){let{sortBy:sortBy=null,sortOrder:sortOrder=null,filters:filters=null,firstInitial:firstInitial=null,lastInitial:lastInitial=null,pageNumber:pageNumber=null,pageSize:pageSize=null,hiddenColumns:hiddenColumns=null}=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];checkTableIsDynamic(tableRoot);const pendingPromise=new _pending.default("core_table/dynamic:updateTable");let tableConfigChanged=!1;if(sortBy&&sortOrder){tableConfigChanged=!0;const sortData=JSON.parse(tableRoot.dataset.tableSortData);sortData.unshift({sortby:sortBy,sortorder:parseInt(sortOrder,10)}),tableRoot.dataset.tableSortData=JSON.stringify(sortData)}if(null!==firstInitial&&(tableRoot.dataset.tableFirstInitial!==firstInitial&&(tableConfigChanged=!0),tableRoot.dataset.tableFirstInitial=firstInitial),null!==lastInitial&&(tableRoot.dataset.tableLastInitial!==lastInitial&&(tableConfigChanged=!0),tableRoot.dataset.tableLastInitial=lastInitial),null!==pageSize&&(tableRoot.dataset.tablePageSize!=pageSize&&(tableConfigChanged=!0),tableRoot.dataset.tablePageSize=pageSize),filters){const filterJson=JSON.stringify(filters);tableRoot.dataset.tableFilters!==filterJson&&(tableConfigChanged=!0),tableRoot.dataset.tableFilters=filterJson}if(tableConfigChanged&&(pageNumber=1),hiddenColumns){const columnJson=JSON.stringify(hiddenColumns);tableRoot.dataset.tableHiddenColumns!==columnJson&&(tableConfigChanged=!0),tableRoot.dataset.tableHiddenColumns=columnJson}return null!==pageNumber&&(tableRoot.dataset.tablePageNumber!=pageNumber&&(tableConfigChanged=!0),tableRoot.dataset.tablePageNumber=pageNumber),refreshContent&&tableConfigChanged?refreshTableContent(tableRoot).then((tableRoot=>(pendingPromise.resolve(),tableRoot))):(pendingPromise.resolve(),Promise.resolve(tableRoot))};_exports.updateTable=updateTable;const getTableData=tableRoot=>(checkTableIsDynamic(tableRoot),tableRoot.dataset);_exports.setFilters=function(tableRoot,filters){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];return updateTable(tableRoot,{filters:filters},refreshContent)};_exports.getFilters=tableRoot=>(checkTableIsDynamic(tableRoot),getFiltersetFromTable(tableRoot));const setSortOrder=function(tableRoot,sortBy,sortOrder){let refreshContent=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];return updateTable(tableRoot,{sortBy:sortBy,sortOrder:sortOrder},refreshContent)};_exports.setSortOrder=setSortOrder;const setPageNumber=function(tableRoot,pageNumber){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];return updateTable(tableRoot,{pageNumber:pageNumber},refreshContent)};_exports.setPageNumber=setPageNumber;_exports.getPageNumber=tableRoot=>getTableData(tableRoot).tablePageNumber;const setPageSize=function(tableRoot,pageSize){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];return updateTable(tableRoot,{pageSize:pageSize,pageNumber:1},refreshContent)};_exports.setPageSize=setPageSize;_exports.getPageSize=tableRoot=>getTableData(tableRoot).tablePageSize;const setFirstInitial=function(tableRoot,firstInitial){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];return updateTable(tableRoot,{firstInitial:firstInitial},refreshContent)};_exports.setFirstInitial=setFirstInitial;_exports.getFirstInitial=tableRoot=>getTableData(tableRoot).tableFirstInitial;const setLastInitial=function(tableRoot,lastInitial){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];return updateTable(tableRoot,{lastInitial:lastInitial},refreshContent)};_exports.setLastInitial=setLastInitial;_exports.getLastInitial=tableRoot=>getTableData(tableRoot).tableLastInitial;const hideColumn=function(tableRoot,columnToHide){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];const hiddenColumns=JSON.parse(tableRoot.dataset.tableHiddenColumns);return hiddenColumns.push(columnToHide),updateTable(tableRoot,{hiddenColumns:hiddenColumns},refreshContent)};_exports.hideColumn=hideColumn;const showColumn=function(tableRoot,columnToShow){let refreshContent=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],hiddenColumns=JSON.parse(tableRoot.dataset.tableHiddenColumns);return hiddenColumns=hiddenColumns.filter((columnName=>columnName!==columnToShow)),updateTable(tableRoot,{hiddenColumns:hiddenColumns},refreshContent)};_exports.showColumn=showColumn;_exports.init=()=>{watching||(watching=!0,document.addEventListener("click",(e=>{const tableRoot=e.target.closest(Selectors.main.region);if(!tableRoot)return;const sortableLink=e.target.closest(Selectors.table.links.sortableColumn);sortableLink&&(e.preventDefault(),setSortOrder(tableRoot,sortableLink.dataset.sortby,sortableLink.dataset.sortorder).catch(_notification.default.exception));const firstInitialLink=e.target.closest(Selectors.initialsBar.links.firstInitial);null!==firstInitialLink&&(e.preventDefault(),setFirstInitial(tableRoot,firstInitialLink.dataset.initial).catch(_notification.default.exception));const lastInitialLink=e.target.closest(Selectors.initialsBar.links.lastInitial);null!==lastInitialLink&&(e.preventDefault(),setLastInitial(tableRoot,lastInitialLink.dataset.initial).catch(_notification.default.exception));const pageItem=e.target.closest(Selectors.paginationBar.links.pageItem);pageItem&&(e.preventDefault(),setPageNumber(tableRoot,pageItem.dataset.pageNumber).catch(_notification.default.exception));const hide=e.target.closest(Selectors.table.links.hide);hide&&(e.preventDefault(),hideColumn(tableRoot,hide.dataset.column).catch(_notification.default.exception));const show=e.target.closest(Selectors.table.links.show);show&&(e.preventDefault(),showColumn(tableRoot,show.dataset.column).catch(_notification.default.exception));e.target.closest(".resettable a")&&(e.preventDefault(),(tableRoot=>refreshTableContent(tableRoot,!0))(tableRoot).catch(_notification.default.exception));const showCountLink=e.target.closest(Selectors.showCount.links.toggle);showCountLink&&(e.preventDefault(),setPageSize(tableRoot,showCountLink.dataset.targetPageSize).catch(_notification.default.exception))})))};const getTableFromId=tableRegionId=>{const tableRoot=document.querySelector(Selectors.main.fromRegionId(tableRegionId));if(!tableRoot)throw new Error("The table specified is not a dynamic table and cannot be updated");return tableRoot};_exports.getTableFromId=getTableFromId}));

//# sourceMappingURL=dynamic.min.js.map