/*
 * JavaScript to provide automatic scrolling, e.g. during a drag operation.
 *
 * Note: this module is defined statically. It is a singleton. You
 * can only have one use of it active at any time. However, since this
 * is usually used in relation to drag-drop, and since you only ever
 * drag one thing at a time, this is not a problem in practice.
 *
 * @module     core/autoscroll
 * @copyright  2016 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.6
 */
define("core/autoscroll",["jquery"],(function($){var autoscroll={SCROLL_THRESHOLD:30,SCROLL_FREQUENCY:1e3/60,SCROLL_SPEED:.5,scrollingId:null,scrollAmount:0,callback:null,start:function(callback){$(window).on("mousemove",autoscroll.mouseMove),$(window).on("touchmove",autoscroll.touchMove),autoscroll.callback=callback},stop:function(){$(window).off("mousemove",autoscroll.mouseMove),$(window).off("touchmove",autoscroll.touchMove),null!==autoscroll.scrollingId&&autoscroll.stopScrolling()},touchMove:function(e){for(var i=0;i<e.changedTouches.length;i++)autoscroll.handleMove(e.changedTouches[i].clientX,e.changedTouches[i].clientY)},mouseMove:function(e){autoscroll.handleMove(e.clientX,e.clientY)},handleMove:function(clientX,clientY){clientY<autoscroll.SCROLL_THRESHOLD?autoscroll.scrollAmount=-Math.min(autoscroll.SCROLL_THRESHOLD-clientY,autoscroll.SCROLL_THRESHOLD):clientY>$(window).height()-autoscroll.SCROLL_THRESHOLD?autoscroll.scrollAmount=Math.min(clientY-($(window).height()-autoscroll.SCROLL_THRESHOLD),autoscroll.SCROLL_THRESHOLD):autoscroll.scrollAmount=0,autoscroll.scrollAmount&&null===autoscroll.scrollingId?autoscroll.startScrolling():autoscroll.scrollAmount||null===autoscroll.scrollingId||autoscroll.stopScrolling()},startScrolling:function(){var maxScroll=$(document).height()-$(window).height();autoscroll.scrollingId=window.setInterval((function(){var y=$(window).scrollTop(),offset=Math.round(autoscroll.scrollAmount*autoscroll.SCROLL_SPEED);if(y+offset<0&&(offset=-y),y+offset>maxScroll&&(offset=maxScroll-y),0!==offset){$(window).scrollTop(y+offset);var realOffset=$(window).scrollTop()-y;0!==realOffset&&autoscroll.callback&&autoscroll.callback(realOffset)}}),autoscroll.SCROLL_FREQUENCY)},stopScrolling:function(){window.clearInterval(autoscroll.scrollingId),autoscroll.scrollingId=null}};return{start:autoscroll.start,stop:autoscroll.stop}}));

//# sourceMappingURL=autoscroll.min.js.map