define("core_contentbank/sort",["exports","./selectors","core/str","core/prefetch","core/ajax","core/notification"],(function(_exports,_selectors,_str,_prefetch,_ajax,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Content bank UI actions.
   *
   * @module     core_contentbank/sort
   * @copyright  2020 Bas Brands <bas@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_selectors=_interopRequireDefault(_selectors),_prefetch=_interopRequireDefault(_prefetch),_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification);_exports.init=function(){var contentBank=document.querySelector(_selectors.default.regions.contentbank);_prefetch.default.prefetchStrings("contentbank",["contentname","uses","lastmodified","size","type","author"]),_prefetch.default.prefetchStrings("moodle",["sortbyx","sortbyxreverse"]),registerListenerEvents(contentBank)};var registerListenerEvents=function(contentBank){contentBank.addEventListener("click",(function(e){var viewList=contentBank.querySelector(_selectors.default.actions.viewlist),viewGrid=contentBank.querySelector(_selectors.default.actions.viewgrid),fileArea=contentBank.querySelector(_selectors.default.regions.filearea),shownItems=fileArea.querySelectorAll(_selectors.default.elements.listitem);if(e.target.closest(_selectors.default.actions.viewgrid)){if(contentBank.classList.remove("view-list"),contentBank.classList.add("view-grid"),fileArea&&shownItems){fileArea.setAttribute("role","list"),shownItems.forEach((function(listItem){listItem.setAttribute("role","listitem"),listItem.querySelectorAll(_selectors.default.elements.cell).forEach((function(cell){return cell.removeAttribute("role")}))}));var heading=fileArea.querySelector(_selectors.default.elements.heading);heading.removeAttribute("role"),heading.querySelectorAll(_selectors.default.elements.cell).forEach((function(cell){return cell.removeAttribute("role")}))}return viewGrid.classList.add("active"),viewList.classList.remove("active"),void setViewListPreference(!1)}if(e.target.closest(_selectors.default.actions.viewlist)){if(contentBank.classList.remove("view-grid"),contentBank.classList.add("view-list"),fileArea&&shownItems){fileArea.setAttribute("role","table"),shownItems.forEach((function(listItem){listItem.setAttribute("role","row"),listItem.querySelectorAll(_selectors.default.elements.cell).forEach((function(cell){return cell.setAttribute("role","cell")}))}));var _heading=fileArea.querySelector(_selectors.default.elements.heading);_heading.setAttribute("role","row"),_heading.querySelectorAll(_selectors.default.elements.cell).forEach((function(cell){return cell.setAttribute("role","columnheader")}))}return viewList.classList.add("active"),viewGrid.classList.remove("active"),void setViewListPreference(!0)}if(fileArea&&shownItems){var sortByName=e.target.closest(_selectors.default.actions.sortname);if(sortByName){var ascending=updateSortButtons(contentBank,sortByName);return void updateSortOrder(fileArea,shownItems,"data-file",ascending)}var sortByUses=e.target.closest(_selectors.default.actions.sortuses);if(sortByUses){var _ascending=updateSortButtons(contentBank,sortByUses);return void updateSortOrder(fileArea,shownItems,"data-uses",_ascending)}var sortByDate=e.target.closest(_selectors.default.actions.sortdate);if(sortByDate){var _ascending2=updateSortButtons(contentBank,sortByDate);return void updateSortOrder(fileArea,shownItems,"data-timemodified",_ascending2)}var sortBySize=e.target.closest(_selectors.default.actions.sortsize);if(sortBySize){var _ascending3=updateSortButtons(contentBank,sortBySize);return void updateSortOrder(fileArea,shownItems,"data-bytes",_ascending3)}var sortByType=e.target.closest(_selectors.default.actions.sorttype);if(sortByType){var _ascending4=updateSortButtons(contentBank,sortByType);return void updateSortOrder(fileArea,shownItems,"data-type",_ascending4)}var sortByAuthor=e.target.closest(_selectors.default.actions.sortauthor);if(sortByAuthor){var _ascending5=updateSortButtons(contentBank,sortByAuthor);updateSortOrder(fileArea,shownItems,"data-author",_ascending5)}}else;}))},setViewListPreference=function(viewList){!1===viewList&&(viewList=null);var request={methodname:"core_user_update_user_preferences",args:{preferences:[{type:"core_contentbank_view_list",value:viewList}]}};return _ajax.default.call([request])[0].catch(_notification.default.exception)},updateSortButtons=function(contentBank,sortButton){contentBank.querySelectorAll(_selectors.default.elements.sortbutton).forEach((function(button){button!==sortButton&&(button.classList.remove("dir-asc"),button.classList.remove("dir-desc"),button.classList.add("dir-none"),button.closest(_selectors.default.elements.cell).setAttribute("aria-sort","none"),updateButtonTitle(button,!1))}));var ascending=!0;return sortButton.classList.contains("dir-none")?(sortButton.classList.remove("dir-none"),sortButton.classList.add("dir-asc"),sortButton.closest(_selectors.default.elements.cell).setAttribute("aria-sort","ascending")):sortButton.classList.contains("dir-asc")?(sortButton.classList.remove("dir-asc"),sortButton.classList.add("dir-desc"),sortButton.closest(_selectors.default.elements.cell).setAttribute("aria-sort","descending"),ascending=!1):sortButton.classList.contains("dir-desc")&&(sortButton.classList.remove("dir-desc"),sortButton.classList.add("dir-asc"),sortButton.closest(_selectors.default.elements.cell).setAttribute("aria-sort","ascending")),updateButtonTitle(sortButton,ascending),ascending},updateButtonTitle=function(button,ascending){var sortString=ascending?"sortbyxreverse":"sortbyx";return(0,_str.get_string)(button.dataset.string,"contentbank").then((function(columnName){return(0,_str.get_string)(sortString,"core",columnName)})).then((function(sortByString){return button.setAttribute("title",sortByString),sortByString})).catch()},updateSortOrder=function(fileArea,itemList,attribute,ascending){[].slice.call(itemList).sort((function(a,b){var aa=a.getAttribute(attribute),bb=b.getAttribute(attribute);return isNaN(aa)||(aa=parseInt(aa),bb=parseInt(bb)),ascending?aa>bb?1:-1:aa<bb?1:-1})).forEach((function(listItem){return fileArea.appendChild(listItem)}))}}));

//# sourceMappingURL=sort.min.js.map